/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.io.File;
import java.util.List;
import org.openmicroscopy.shoola.env.data.ImportException;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.svc.SvcRegistry;
import org.openmicroscopy.shoola.svc.communicator.Communicator;
import org.openmicroscopy.shoola.svc.communicator.CommunicatorDescriptor;
import org.openmicroscopy.shoola.util.ui.FileTableNode;
import org.openmicroscopy.shoola.util.ui.MessengerDetails;

public class FileUploader
extends BatchCallTree {
    private MessengerDetails details;
    private Object uploadedFile;

    private void uploadFile(File file, ImportException exception) {
        String tokenURL = (String)this.context.lookup("/services/DEBUGGER/hostnameToken");
        String processURL = (String)this.context.lookup("/services/DEBUGGER/hostnameProcessing");
        String appName = (String)this.context.lookup("/services/DEBUGGER/applicationNameBug");
        int timeout = (Integer)this.context.lookup("/services/DEBUGGER/postTimeout");
        Object version = this.context.lookup("Version");
        String v = "";
        if (version != null && version instanceof String) {
            v = (String)version;
        }
        try {
            CommunicatorDescriptor desc = new CommunicatorDescriptor(1, tokenURL, -1);
            Communicator c = SvcRegistry.getCommunicator(desc);
            StringBuilder token = new StringBuilder();
            c.submitError("", this.details.getEmail(), this.details.getComment(), this.details.getExtra(), exception.toString(), appName, v, token);
            desc = new CommunicatorDescriptor(1, processURL, timeout);
            c = SvcRegistry.getCommunicator(desc);
            StringBuilder reply = new StringBuilder();
            c.submitFile(token.toString(), file, exception.getReaderType(), reply);
            this.uploadedFile = file;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected Object getPartialResult() {
        return this.uploadedFile;
    }

    protected Object getResult() {
        return null;
    }

    protected void buildTree() {
        List l = (List)this.details.getObjectToSubmit();
        String description = "Uploading files to QA system.";
        for (FileTableNode node : l) {
            node.setStatus(true);
            final File f = node.getFile();
            final ImportException e = (ImportException)node.getException();
            this.add(new BatchCall(description){

                public void doCall() {
                    FileUploader.this.uploadFile(f, e);
                }
            });
        }
    }

    public FileUploader(MessengerDetails details) {
        if (details == null) {
            throw new IllegalArgumentException("No files to submit.");
        }
        this.details = details;
    }
}

