/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.List;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.GroupData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminSaver
extends BatchCallTree {
    public static final int DELETE = 0;
    private Object result;
    private BatchCall loadCall;

    private BatchCall deleteObjects(final List<DataObject> objects) {
        return new BatchCall("Delete objects"){

            public void doCall() throws Exception {
                AdminService os = AdminSaver.this.context.getAdminService();
                ArrayList<Object> l = new ArrayList<Object>();
                ArrayList<GroupData> groups = new ArrayList<GroupData>();
                ArrayList<ExperimenterData> experimenters = new ArrayList<ExperimenterData>();
                for (DataObject data : objects) {
                    if (data instanceof GroupData) {
                        groups.add((GroupData)data);
                        continue;
                    }
                    if (!(data instanceof ExperimenterData)) continue;
                    experimenters.add((ExperimenterData)data);
                }
                if (groups.size() > 0) {
                    l.addAll(os.deleteGroups(groups));
                }
                if (experimenters.size() > 0) {
                    l.addAll(os.deleteExperimenters(experimenters));
                }
                AdminSaver.this.result = l;
            }
        };
    }

    private BatchCall createExperimenters(final AdminObject object) {
        return new BatchCall("Create experimenters"){

            public void doCall() throws Exception {
                AdminService os = AdminSaver.this.context.getAdminService();
                AdminSaver.this.result = os.createExperimenters(object);
            }
        };
    }

    private BatchCall resetExperimentersPassword(final AdminObject object) {
        return new BatchCall("Reset password"){

            public void doCall() throws Exception {
                AdminService os = AdminSaver.this.context.getAdminService();
                AdminSaver.this.result = os.resetExperimentersPassword(object);
            }
        };
    }

    private BatchCall createGroup(final AdminObject object) {
        return new BatchCall("Create group"){

            public void doCall() throws Exception {
                AdminService os = AdminSaver.this.context.getAdminService();
                AdminSaver.this.result = os.createGroup(object);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public AdminSaver(AdminObject object) {
        if (object == null) {
            throw new IllegalArgumentException("Object not valid.");
        }
        switch (object.getIndex()) {
            case 1: {
                this.loadCall = this.createExperimenters(object);
                break;
            }
            case 0: {
                this.loadCall = this.createGroup(object);
                break;
            }
            case 4: {
                this.loadCall = this.resetExperimentersPassword(object);
            }
        }
    }

    public AdminSaver(List<DataObject> objects, int index) {
        if (objects == null || objects.size() == 0) {
            throw new IllegalArgumentException("No objects to handle");
        }
        switch (index) {
            case 0: {
                this.loadCall = this.deleteObjects(objects);
            }
        }
    }
}

