/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.GroupData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminLoader
extends BatchCallTree {
    public static final int SPACE = 0;
    public static final int GROUPS = 1;
    public static final int EXPERIMENTERS = 2;
    public static final int EXPERIMENTER_PHOTO = 3;
    public static final int EXPERIMENTER_UPDATE = 4;
    private Object result;
    private BatchCall loadCall;

    private BatchCall availableSpaceCall(final long userID) {
        return new BatchCall("Loading disk space information"){

            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                ArrayList<Long> l = new ArrayList<Long>();
                l.add(os.getSpace(101, userID));
                l.add(os.getSpace(100, userID));
                AdminLoader.this.result = l;
            }
        };
    }

    private BatchCall changePassword(final String oldPassword, final String newPassword) {
        return new BatchCall("Change password"){

            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.changePassword(oldPassword, newPassword);
            }
        };
    }

    private BatchCall updateExperimenter(final ExperimenterData exp) {
        return new BatchCall("Update experimenter"){

            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.updateExperimenter(exp, null);
            }
        };
    }

    private BatchCall updateGroup(final GroupData group, final int permissions) {
        return new BatchCall("Update group"){

            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.updateGroup(group, permissions);
            }
        };
    }

    private BatchCall loadGroup(final long id) {
        return new BatchCall("Load groups"){

            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.loadGroups(id);
            }
        };
    }

    private BatchCall loadExperimenters(final long id) {
        return new BatchCall("Load experimenters"){

            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.loadExperimenters(id);
            }
        };
    }

    private BatchCall updateExperimenters(final GroupData group, final Map<ExperimenterData, UserCredentials> experimenters) {
        return new BatchCall("Update experimenters"){

            public void doCall() throws Exception {
                AdminService os = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = os.updateExperimenters(group, experimenters);
            }
        };
    }

    private BatchCall loadExperimenterPhoto(final ExperimenterData experimenter) {
        return new BatchCall("Load photo"){

            public void doCall() throws Exception {
                OmeroImageService os = AdminLoader.this.context.getImageService();
                ArrayList<DataObject> exps = new ArrayList<DataObject>();
                exps.add((DataObject)experimenter);
                Map<DataObject, BufferedImage> map = os.getExperimenterThumbnailSet(exps, 96);
                AdminLoader.this.result = map.get(experimenter);
            }
        };
    }

    private BatchCall uploadExperimenterPhoto(final ExperimenterData experimenter, final File photo, final String format) {
        return new BatchCall("Update experimenters"){

            public void doCall() throws Exception {
                AdminService svc = AdminLoader.this.context.getAdminService();
                AdminLoader.this.result = svc.uploadUserPhoto(photo, format, experimenter);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public AdminLoader(long id, int index) {
        switch (index) {
            case 0: {
                this.loadCall = this.availableSpaceCall(id);
                break;
            }
            case 1: {
                this.loadCall = this.loadGroup(id);
                break;
            }
            case 2: {
                this.loadCall = this.loadExperimenters(id);
            }
        }
    }

    public AdminLoader(String oldPassword, String newPassword) {
        if (newPassword == null || newPassword.trim().length() == 0) {
            throw new IllegalArgumentException("Password not valid.");
        }
        if (oldPassword == null || oldPassword.trim().length() == 0) {
            throw new IllegalArgumentException("Password not valid.");
        }
        this.loadCall = this.changePassword(oldPassword, newPassword);
    }

    public AdminLoader(ExperimenterData exp, int index) {
        if (exp == null) {
            throw new IllegalArgumentException("Experimenter not valid.");
        }
        switch (index) {
            case 4: {
                this.loadCall = this.updateExperimenter(exp);
                break;
            }
            case 3: {
                this.loadCall = this.loadExperimenterPhoto(exp);
            }
        }
    }

    public AdminLoader(ExperimenterData exp, File photo, String format) {
        if (exp == null) {
            throw new IllegalArgumentException("Experimenter not valid.");
        }
        if (photo == null) {
            throw new IllegalArgumentException("Photo not valid.");
        }
        this.loadCall = this.uploadExperimenterPhoto(exp, photo, format);
    }

    public AdminLoader(GroupData group, int permissions) {
        if (group == null) {
            throw new IllegalArgumentException("Group not valid.");
        }
        this.loadCall = this.updateGroup(group, permissions);
    }

    public AdminLoader(GroupData group, Map<ExperimenterData, UserCredentials> experimenters) {
        if (experimenters == null) {
            throw new IllegalArgumentException("No experimenters to update.");
        }
        this.loadCall = this.updateExperimenters(group, experimenters);
    }
}

