/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import javax.swing.JLabel;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportEvent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class StatusLabel
extends JLabel
implements IObserver {
    private int maxPlanes;
    private int numberOfFiles;

    public StatusLabel() {
        this.setForeground(UIUtilities.LIGHT_GREY);
        this.maxPlanes = 0;
        this.numberOfFiles = 0;
    }

    public void setStatus(String value) {
        if (value == null) {
            value = "";
        }
        this.setText(value);
    }

    public void update(IObservable observable, ImportEvent event) {
        if (event == null) {
            return;
        }
        if (event instanceof ImportEvent.LOADING_IMAGE) {
            this.setText("prepping");
        } else if (event instanceof ImportEvent.LOADED_IMAGE) {
            this.setText("analyzing");
        } else if (event instanceof ImportEvent.IMPORT_DONE) {
            if (this.numberOfFiles == 1) {
                this.setText("one file");
            } else if (this.numberOfFiles == 0) {
                this.setText("");
            } else {
                this.setText(this.numberOfFiles + " files");
            }
        } else if (event instanceof ImportEvent.IMPORT_ARCHIVING) {
            this.setText("archiving");
        } else if (event instanceof ImportEvent.DATASET_STORED) {
            ImportEvent.DATASET_STORED ev = (ImportEvent.DATASET_STORED)event;
            this.maxPlanes = ev.size.imageCount;
        } else if (event instanceof ImportEvent.IMPORT_STEP) {
            int value;
            ImportEvent.IMPORT_STEP ev = (ImportEvent.IMPORT_STEP)event;
            if (ev.step <= this.maxPlanes && (value = ev.step) <= this.maxPlanes) {
                int count = ev.seriesCount;
                int series = ev.series;
                String text = count > 1 ? series + 1 + "/" + count + ": " + value + "/" + this.maxPlanes : value + "/" + this.maxPlanes;
                this.setText(text);
            }
        } else if (event instanceof ImportCandidates.SCANNING) {
            ImportCandidates.SCANNING ev = (ImportCandidates.SCANNING)event;
            this.numberOfFiles = ev.totalFiles;
            this.setText("scanning");
        }
    }
}

