/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.editorpreview;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLParserFactory;
import org.openmicroscopy.shoola.agents.util.editorpreview.StepObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PreviewModel {
    private String protocolName;
    private String protocolDescription;
    private List<StepObject> protocolSteps = new ArrayList<StepObject>();

    private void parseXmlDescription(String xmlDescription) {
        IXMLElement root = null;
        try {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            ByteArrayInputStream bs = new ByteArrayInputStream(xmlDescription.getBytes());
            StdXMLReader reader = new StdXMLReader((InputStream)bs);
            parser.setReader((IXMLReader)reader);
            root = (IXMLElement)parser.parse();
            bs.close();
        }
        catch (Throwable ex) {
            return;
        }
        this.protocolName = PreviewModel.getChildContent(root, "n");
        this.protocolDescription = PreviewModel.getChildContent(root, "d");
        IXMLElement ss = root.getFirstChildNamed("ss");
        if (ss == null) {
            return;
        }
        ArrayList steps = ss.getChildrenNamed("s");
        for (IXMLElement step : steps) {
            String name = step.getAttribute("n", "Step");
            int level = step.getAttribute("l", 0);
            StepObject so = new StepObject(name, level);
            ArrayList params = step.getChildrenNamed("p");
            for (IXMLElement element : params) {
                String key = PreviewModel.getChildContent(element, "n");
                String value = PreviewModel.getChildContent(element, "v");
                so.addParam(key, value);
            }
            this.protocolSteps.add(so);
        }
    }

    private static String getChildContent(IXMLElement parent, String childName) {
        if (parent == null) {
            return null;
        }
        IXMLElement child = parent.getFirstChildNamed(childName);
        if (child == null) {
            return null;
        }
        return child.getContent();
    }

    PreviewModel(String summary) {
        if (summary != null) {
            this.parseXmlDescription(summary);
        }
    }

    String getTitle() {
        return this.protocolName;
    }

    String getDescription() {
        return this.protocolDescription;
    }

    List<StepObject> getSteps() {
        return this.protocolSteps;
    }
}

