/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import org.openmicroscopy.shoola.agents.util.SelectionWizardUI;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;
import org.openmicroscopy.shoola.util.ui.IconManager;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.TagAnnotationData;
import pojos.TermAnnotationData;

public class DataObjectListCellRenderer
extends DefaultListCellRenderer {
    public static final Color NEW_FOREGROUND_COLOR = Color.red;
    private IconManager icons;
    private long currentUserID;
    private EditorFileFilter filter;
    private Collection immutable;
    private SelectionWizardUI model;

    private void createTooltip(ExperimenterData exp) {
        if (exp == null) {
            return;
        }
        String s = "Created by: " + exp.getFirstName() + " " + exp.getLastName();
        this.setToolTipText(s);
    }

    private boolean isImmutable(Object value) {
        if (this.immutable == null || this.immutable.size() == 0) {
            return false;
        }
        if (!(value instanceof DataObject)) {
            return false;
        }
        Iterator i = this.immutable.iterator();
        long id = ((DataObject)value).getId();
        if (id < 0L) {
            return false;
        }
        while (i.hasNext()) {
            Object object = i.next();
            if (!object.getClass().equals(value.getClass()) || ((DataObject)object).getId() != id) continue;
            return !this.model.isAddedNode(value);
        }
        return false;
    }

    DataObjectListCellRenderer(long currentUserID, SelectionWizardUI model) {
        this.model = model;
        this.currentUserID = currentUserID;
        this.icons = IconManager.getInstance();
        this.filter = new EditorFileFilter();
    }

    void setImmutableElements(Collection immutable) {
        this.immutable = immutable;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof TagAnnotationData) {
            TagAnnotationData tag;
            block23: {
                tag = (TagAnnotationData)value;
                this.setText(tag.getTagValue());
                String ns = tag.getNameSpace();
                if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                    if (this.currentUserID >= 0L) {
                        try {
                            ExperimenterData exp = tag.getOwner();
                            long id = exp.getId();
                            if (id == this.currentUserID) {
                                this.setIcon(this.icons.getIcon(65));
                                break block23;
                            }
                            this.createTooltip(exp);
                            this.setIcon(this.icons.getIcon(136));
                        }
                        catch (Exception e) {
                            this.setIcon(this.icons.getIcon(65));
                        }
                    } else {
                        this.setIcon(this.icons.getIcon(65));
                    }
                } else if (this.currentUserID >= 0L) {
                    try {
                        ExperimenterData exp = tag.getOwner();
                        long id = exp.getId();
                        if (id == this.currentUserID) {
                            this.setIcon(this.icons.getIcon(64));
                            break block23;
                        }
                        this.createTooltip(exp);
                        this.setIcon(this.icons.getIcon(88));
                    }
                    catch (Exception e) {
                        this.setIcon(this.icons.getIcon(64));
                    }
                } else {
                    this.setIcon(this.icons.getIcon(64));
                }
            }
            if (tag.getId() <= 0L) {
                this.setForeground(NEW_FOREGROUND_COLOR);
            }
        } else if (value instanceof FileAnnotationData) {
            FileAnnotationData fad = (FileAnnotationData)value;
            this.setText(fad.getFileName());
            if (fad.getId() <= 0L) {
                this.setForeground(NEW_FOREGROUND_COLOR);
            }
            String format = fad.getFileFormat();
            Icon icon = this.icons.getIcon(94);
            icon = "pdf".equals(format) ? this.icons.getIcon(101) : ("txt".equals(format) || "csv".equals(format) ? this.icons.getIcon(102) : ("html".equals(format) || "htm".equals(format) ? this.icons.getIcon(108) : ("ppt".equals(format) || "pps".equals(format) || "pptx".equals(format) ? this.icons.getIcon(106) : ("doc".equals(format) || "docx".equals(format) ? this.icons.getIcon(104) : ("xls".equals(format) ? this.icons.getIcon(105) : ("xml".equals(format) || "rtf".equals(format) ? (this.filter.accept(fad.getFileName()) ? ("openmicroscopy.org/omero/editor/experiment".equals(fad.getNameSpace()) ? this.icons.getIcon(117) : this.icons.getIcon(103)) : this.icons.getIcon(107)) : this.icons.getIcon(94)))))));
            this.setIcon(icon);
        } else if (value instanceof TermAnnotationData) {
            TermAnnotationData term = (TermAnnotationData)value;
            this.setText(term.getTerm());
            this.setIcon(this.icons.getIcon(149));
        } else if (value instanceof DatasetData) {
            DatasetData d = (DatasetData)value;
            this.setText(d.getName());
            this.setIcon(this.icons.getIcon(45));
        } else if (value instanceof GroupData) {
            GroupData d = (GroupData)value;
            this.setText(d.getName());
            this.setIcon(this.icons.getIcon(137));
        }
        this.setEnabled(!this.isImmutable(value));
        return this;
    }
}

