/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.SmartFolder;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.FileData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.MultiImageData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Dimension SIZE = new Dimension(16, 16);
    private IconManager icons;
    private boolean numberChildrenVisible;
    private long userID;
    private EditorFileFilter filter;

    private void setIcon(TreeImageDisplay node) {
        Object usrObject = node.getUserObject();
        Icon icon = this.icons.getIcon(83);
        if (usrObject instanceof ProjectData) {
            icon = EditorUtil.isAnnotated(usrObject) ? this.icons.getIcon(67) : this.icons.getIcon(4);
        } else if (usrObject instanceof DatasetData) {
            icon = EditorUtil.isAnnotated(usrObject) ? this.icons.getIcon(18) : this.icons.getIcon(5);
        } else if (usrObject instanceof ImageData) {
            ImageData o;
            icon = EditorUtil.isAnnotated(usrObject) ? this.icons.getIcon(19) : ((o = (ImageData)usrObject).getId() < 0L ? this.icons.getIcon(121) : this.icons.getIcon(6));
        } else if (usrObject instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)usrObject;
            String ns = tag.getNameSpace();
            icon = "openmicroscopy.org/omero/insight/tagset".equals(ns) ? this.icons.getIcon(71) : this.icons.getIcon(69);
        } else if (usrObject instanceof ScreenData) {
            icon = EditorUtil.isAnnotated(usrObject) ? this.icons.getIcon(76) : this.icons.getIcon(75);
        } else if (usrObject instanceof PlateData) {
            icon = EditorUtil.isAnnotated(usrObject) ? this.icons.getIcon(78) : this.icons.getIcon(77);
        } else if (usrObject instanceof PlateAcquisitionData) {
            icon = this.icons.getIcon(114);
        } else if (usrObject instanceof GroupData) {
            icon = this.icons.getIcon(112);
        } else if (usrObject instanceof FileAnnotationData) {
            FileAnnotationData data = (FileAnnotationData)usrObject;
            String format = data.getFileFormat();
            icon = "pdf".equals(format) ? this.icons.getIcon(82) : ("txt".equals(format) || "csv".equals(format) ? this.icons.getIcon(83) : ("html".equals(format) || "htm".equals(format) ? this.icons.getIcon(89) : ("ppt".equals(format) || "pps".equals(format) || "pptx".equals(format) ? this.icons.getIcon(87) : ("doc".equals(format) || "docx".equals(format) ? this.icons.getIcon(85) : ("xls".equals(format) ? this.icons.getIcon(86) : ("xml".equals(format) || "rtf".equals(format) ? (this.filter.accept(data.getFileName()) ? ("openmicroscopy.org/omero/editor/experiment".equals(data.getNameSpace()) ? this.icons.getIcon(99) : this.icons.getIcon(84)) : this.icons.getIcon(88)) : (data.isMovieFile() ? this.icons.getIcon(101) : this.icons.getIcon(83))))))));
        } else if (usrObject instanceof MultiImageData) {
            MultiImageData mi = (MultiImageData)usrObject;
            icon = mi.getId() > 0L ? this.icons.getIcon(126) : this.icons.getIcon(127);
        } else if (usrObject instanceof FileData) {
            FileData f = (FileData)usrObject;
            icon = f.isDirectory() ? (f.getId() > 0L ? this.icons.getIcon(119) : this.icons.getIcon(102)) : (f.getId() > 0L ? this.icons.getIcon(120) : this.icons.getIcon(83));
        } else if (node instanceof SmartFolder) {
            if (GroupData.class.equals((Object)((SmartFolder)node).getType())) {
                icon = this.icons.getIcon(112);
            }
        } else if (node instanceof TreeImageTimeSet) {
            icon = this.icons.getIcon(62);
        } else if (node instanceof TreeFileSet) {
            TreeFileSet n = (TreeFileSet)node;
            switch (n.getType()) {
                case 1: {
                    icon = this.icons.getIcon(98);
                    break;
                }
                case 0: {
                    icon = this.icons.getIcon(97);
                    break;
                }
                case 2: {
                    icon = this.icons.getIcon(106);
                    break;
                }
                default: {
                    icon = this.icons.getIcon(7);
                    break;
                }
            }
        } else if (usrObject instanceof String) {
            icon = this.icons.getIcon(7);
        } else if (usrObject instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)usrObject;
            icon = this.icons.getIcon(23);
            if (!exp.isActive()) {
                icon = this.icons.getIcon(124);
            }
        }
        this.setIcon(icon);
    }

    private void setTextColor(Color c) {
        if (c == null) {
            return;
        }
        if (UIUtilities.isDarkColor(c)) {
            this.setForeground(UIUtilities.DEFAULT_TEXT);
        }
    }

    public TreeCellRenderer(boolean b) {
        this.numberChildrenVisible = b;
        this.icons = IconManager.getInstance();
        this.filter = new EditorFileFilter();
    }

    public TreeCellRenderer() {
        this(true);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setIcon(this.icons.getIcon(83));
        if (!(value instanceof TreeImageDisplay)) {
            return this;
        }
        TreeImageDisplay node = (TreeImageDisplay)value;
        int w = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Object ho = node.getUserObject();
        if (node.getLevel() == 0) {
            if (ho instanceof ExperimenterData) {
                this.setIcon(this.icons.getIcon(23));
            } else {
                this.setIcon(this.icons.getIcon(7));
            }
            if (this.getIcon() != null) {
                w += this.getIcon().getIconWidth();
            }
            w += this.getIconTextGap();
            this.setPreferredSize(new Dimension(w += fm.stringWidth(this.getText()), fm.getHeight()));
            Color c = node.getHighLight();
            if (c == null) {
                c = tree.getForeground();
            }
            this.setForeground(c);
            if (!sel) {
                this.setBorderSelectionColor(this.getBackground());
            } else {
                this.setTextColor(this.getBackgroundSelectionColor());
            }
            return this;
        }
        this.setIcon(node);
        if (this.numberChildrenVisible) {
            this.setText(node.getNodeText());
        } else {
            this.setText(node.getNodeName());
        }
        this.setToolTipText(node.getToolTip());
        Color c = node.getHighLight();
        if (c == null) {
            c = tree.getForeground();
        }
        this.setForeground(c);
        if (!sel) {
            this.setBorderSelectionColor(this.getBackground());
        } else {
            this.setTextColor(this.getBackgroundSelectionColor());
        }
        w = this.getIcon() != null ? (w += this.getIcon().getIconWidth()) : (w += TreeCellRenderer.SIZE.width);
        w += this.getIconTextGap();
        w = ho instanceof ImageData ? (w += fm.stringWidth(node.getNodeName())) : (node instanceof TreeFileSet ? (w += fm.stringWidth(this.getText()) + 40) : (w += fm.stringWidth(this.getText())));
        this.setPreferredSize(new Dimension(w, fm.getHeight() + 4));
        this.setEnabled(node.isSelectable());
        return this;
    }
}

