/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.ImportManager;
import org.openmicroscopy.shoola.env.data.ImportException;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.util.StatusLabel;
import pojos.ImageData;

public class FileImportComponent
extends JPanel
implements ChangeListener {
    public static final String SEND_FILE_PROPERTY = "sendFile";
    private static final Dimension SIZE = new Dimension(16, 16);
    private static final Border LABEL_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    private static final String FAILURE_TEXT = "failed";
    private static final String IMAGE_LABEL_TOOLTIP = "Click on thumbnail to launch the viewer.";
    private File file;
    private JXBusyLabel busyLabel;
    private JPanel nameLabel;
    private JLabel thumbLabel;
    private JLabel imageLabel;
    private JLabel status;
    private JComponent control;
    private ImportManager parent;
    private Object image;
    private JCheckBox errorBox;
    private StatusLabel statusLabel;

    private void initComponents() {
        this.setLayout(new FlowLayout(0));
        this.busyLabel = new JXBusyLabel(SIZE);
        this.busyLabel.setVisible(true);
        this.busyLabel.setBusy(false);
        this.nameLabel = new JPanel();
        this.nameLabel.setLayout(new FlowLayout(0, 5, 5));
        IconManager icons = IconManager.getInstance();
        Icon icon = this.file.isFile() ? icons.getIcon(6) : icons.getIcon(102);
        this.imageLabel = new JLabel(icon);
        this.imageLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (FileImportComponent.this.image instanceof ThumbnailData) {
                    ThumbnailData thumb = (ThumbnailData)FileImportComponent.this.image;
                    FileImportComponent.this.parent.viewImage(thumb.getImage());
                }
            }
        });
        this.nameLabel.add(this.imageLabel);
        this.nameLabel.add(Box.createHorizontalStrut(4));
        this.nameLabel.add(new JLabel(this.file.getName()));
        this.nameLabel.add(Box.createHorizontalStrut(10));
        this.thumbLabel = new JLabel();
        this.control = this.busyLabel;
        this.errorBox = new JCheckBox("Send file");
        this.errorBox.setOpaque(false);
        this.errorBox.setToolTipText("Select the file to send.");
        this.errorBox.addChangeListener(this);
        this.errorBox.setVisible(false);
        this.statusLabel = new StatusLabel();
    }

    private void buildGUI() {
        this.removeAll();
        this.add(this.nameLabel);
        this.add(this.control);
        if (this.statusLabel.isVisible()) {
            this.add(this.statusLabel);
        }
        if (this.image instanceof ImportException) {
            this.errorBox.setSelected(true);
            this.errorBox.setVisible(true);
            this.add(this.errorBox);
        }
    }

    private void setStatusText(String text) {
        if (text == null) {
            text = "";
        }
        if ((text = text.trim()).length() == 0) {
            this.thumbLabel.setText(FAILURE_TEXT);
        } else {
            this.thumbLabel.setText(text);
        }
    }

    public FileImportComponent(ImportManager parent, File file) {
        if (file == null) {
            throw new IllegalArgumentException("No file specified.");
        }
        this.parent = parent;
        this.file = file;
        this.initComponents();
        this.buildGUI();
    }

    public StatusLabel getStatus() {
        return this.statusLabel;
    }

    public JPanel getNameLabel() {
        return this.nameLabel;
    }

    public void setStatus(boolean status, Object image) {
        this.image = image;
        this.busyLabel.setBusy(status);
        if (image instanceof ImageData) {
            this.thumbLabel.setText("Preview not available");
            this.thumbLabel.setToolTipText("");
            this.thumbLabel.setEnabled(false);
            this.control = this.thumbLabel;
            this.statusLabel.setVisible(false);
        } else if (image instanceof ThumbnailData) {
            ThumbnailData thumb = (ThumbnailData)image;
            ImageIcon icon = new ImageIcon(thumb.getThumbnail());
            this.imageLabel.setToolTipText(IMAGE_LABEL_TOOLTIP);
            this.imageLabel.setIcon(icon);
            this.imageLabel.setBorder(LABEL_BORDER);
            if (icon != null) {
                this.imageLabel.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
            }
            this.statusLabel.setVisible(false);
            this.control = this.thumbLabel;
        } else if (!status) {
            this.statusLabel.setVisible(false);
            this.thumbLabel.setToolTipText("");
            this.thumbLabel.setEnabled(false);
            if (image == null) {
                this.setStatusText(null);
            } else if (image instanceof String) {
                this.setStatusText((String)image);
            } else if (image instanceof Map) {
                Map m = (Map)image;
                if (m == null || m.size() == 0) {
                    this.setStatusText("Folder imported");
                }
            } else if (image instanceof ImportException) {
                ImportException ie = (ImportException)image;
                this.setStatusText(ie.getMessage());
                this.errorBox.setSelected(true);
            }
            this.control = this.thumbLabel;
        } else {
            this.control = this.busyLabel;
        }
        this.buildGUI();
        this.revalidate();
        this.repaint();
    }

    public boolean isSelected() {
        if (this.errorBox != null && this.errorBox.isVisible()) {
            return this.errorBox.isSelected();
        }
        return this.errorBox.isSelected();
    }

    public File getOriginalFile() {
        return this.file;
    }

    public Exception getImportException() {
        if (this.image instanceof Exception) {
            return (Exception)this.image;
        }
        return null;
    }

    public void setBackground(Color color) {
        if (this.busyLabel != null) {
            this.busyLabel.setBackground(color);
        }
        if (this.nameLabel != null) {
            this.nameLabel.setBackground(color);
            for (int i = 0; i < this.nameLabel.getComponentCount(); ++i) {
                this.nameLabel.getComponent(i).setBackground(color);
            }
        }
        if (this.status != null) {
            this.status.setBackground(color);
        }
        super.setBackground(color);
    }

    public void stateChanged(ChangeEvent e) {
        if (this.errorBox != null) {
            this.firePropertyChange(SEND_FILE_PROPERTY, !this.errorBox.isSelected(), this.errorBox.isSelected());
        }
    }
}

