/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.util.DeletableTableNode;

class DeletableTableRenderer
extends DefaultTreeCellRenderer {
    private IconManager icons;

    DeletableTableRenderer() {
        this.setOpaque(true);
        this.icons = IconManager.getInstance();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            this.setBackground(this.getBackgroundSelectionColor());
        } else {
            this.setBackground(this.getBackgroundNonSelectionColor());
        }
        if (!(value instanceof DeletableTableNode)) {
            return this;
        }
        DeletableTableNode node = (DeletableTableNode)((Object)value);
        String type = node.getType();
        if ("Image".equals(type)) {
            this.setIcon(this.icons.getIcon(6));
        } else if ("Dataset".equals(type)) {
            this.setIcon(this.icons.getIcon(5));
        } else if ("Project".equals(type)) {
            this.setIcon(this.icons.getIcon(4));
        } else if ("Plate".equals(type)) {
            this.setIcon(this.icons.getIcon(77));
        } else if ("Screen".equals(type)) {
            this.setIcon(this.icons.getIcon(75));
        } else if ("File".equals(type)) {
            this.setIcon(this.icons.getIcon(81));
        }
        this.setText(type);
        return this;
    }
}

