/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.finder;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FinderAction;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FilterMenuAction
extends FinderAction
implements MouseListener {
    private static final String DESCRIPTION = "Menu. Press (Shift) to keep the menu on screen during selection";
    private Point pressedPoint;

    protected void onTextChanged() {
        this.setEnabled(!this.model.isTextEmpty());
    }

    public FilterMenuAction(Finder model) {
        super(model);
        this.setEnabled(true);
        IconManager im = IconManager.getInstance();
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.putValue("SmallIcon", im.getIcon(17));
    }

    public void mousePressed(MouseEvent me) {
        this.pressedPoint = me.getPoint();
    }

    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (source instanceof Component && this.isEnabled()) {
            this.model.showMenu((Component)source, this.pressedPoint);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

