/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.cmd;

import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.treeviewer.util.ImportDialog;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public class CreateCmd
implements ActionCmd {
    public static final int PROJECT = 0;
    public static final int DATASET = 1;
    public static final int TAG = 2;
    public static final int SCREEN = 3;
    public static final int PLATE = 4;
    public static final int IMAGE = 5;
    public static final int TAG_SET = 6;
    public static final int GROUP = 7;
    public static final int EXPERIMENTER = 8;
    private TreeViewer model;
    private DataObject userObject;
    private boolean withParent;
    private boolean chooser;
    private ImportDialog importDialog;

    private DataObject checkNodeType(int type) {
        switch (type) {
            case 0: {
                return new ProjectData();
            }
            case 1: {
                return new DatasetData();
            }
            case 3: {
                return new ScreenData();
            }
            case 2: {
                return new TagAnnotationData("foo");
            }
            case 6: {
                return new TagAnnotationData("foo", true);
            }
            case 4: {
                return new PlateData();
            }
            case 5: {
                return new ImageData();
            }
            case 7: {
                return new GroupData();
            }
            case 8: {
                return new ExperimenterData();
            }
        }
        throw new IllegalArgumentException("Type not supported");
    }

    public CreateCmd(TreeViewer model, int type, boolean chooser) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.userObject = this.checkNodeType(type);
        this.model = model;
        this.chooser = chooser;
        this.withParent = true;
    }

    public void setWithParent(boolean withParent) {
        this.withParent = withParent;
    }

    public void execute() {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        if (this.userObject == null) {
            return;
        }
        if (this.userObject instanceof ImageData) {
            if (this.chooser) {
                this.model.showImporter();
            } else {
                this.model.importFiles(null);
            }
        } else {
            this.model.createDataObject(this.userObject, this.withParent);
        }
    }
}

