/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserDeleteAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserImportAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserInfoAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserManageAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserPasswordResetAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserRefreshAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CloseAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CollapseAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ShowNameAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SortAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SortByDateAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.FileData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BrowserControl
implements ChangeListener {
    static final Integer COLLAPSE = 0;
    static final Integer CLOSE = 1;
    static final Integer SORT = 2;
    static final Integer SORT_DATE = 3;
    static final Integer PARTIAL_NAME = 4;
    static final Integer INFO = 5;
    static final Integer DELETE = 6;
    static final Integer NEW_CONTAINER = 7;
    static final Integer NEW_TAG = 8;
    static final Integer IMPORT = 9;
    static final Integer REFRESH = 10;
    static final Integer NEW_ADMIN = 11;
    static final Integer RESET_PASSWORD = 12;
    private Browser model;
    private BrowserUI view;
    private Map<Integer, Action> actionsMap;

    private void createActions() {
        this.actionsMap.put(COLLAPSE, new CollapseAction(this.model));
        this.actionsMap.put(CLOSE, new CloseAction(this.model));
        this.actionsMap.put(SORT, new SortAction(this.model));
        this.actionsMap.put(SORT_DATE, new SortByDateAction(this.model));
        this.actionsMap.put(PARTIAL_NAME, new ShowNameAction(this.model));
        this.actionsMap.put(INFO, new BrowserInfoAction(this.model));
        this.actionsMap.put(DELETE, new BrowserDeleteAction(this.model));
        this.actionsMap.put(NEW_CONTAINER, new BrowserManageAction(this.model, 1));
        this.actionsMap.put(NEW_ADMIN, new BrowserManageAction(this.model, 2));
        this.actionsMap.put(NEW_TAG, new BrowserManageAction(this.model, 0));
        this.actionsMap.put(IMPORT, new BrowserImportAction(this.model));
        this.actionsMap.put(REFRESH, new BrowserRefreshAction(this.model));
        this.actionsMap.put(RESET_PASSWORD, new BrowserPasswordResetAction(this.model));
    }

    BrowserControl(Browser model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.actionsMap = new HashMap<Integer, Action>();
        this.createActions();
    }

    void initialize(BrowserUI view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.model.addChangeListener(this);
    }

    void onNodeNavigation(TreeImageDisplay display, boolean expanded) {
        Object ho = display.getUserObject();
        if (this.model.getBrowserType() == 105) {
            if (ho instanceof FileData) {
                FileData f = (FileData)ho;
                if (f.isDirectory()) {
                    this.model.loadDirectory(display);
                }
                return;
            }
            if (ho instanceof ImageData && display.isChildrenLoaded()) {
                return;
            }
        }
        if (!expanded) {
            this.model.cancel();
            return;
        }
        int state = this.model.getState();
        if (state == 11 || state == 12) {
            return;
        }
        this.model.setSelectedDisplay(display);
        int browserType = this.model.getBrowserType();
        if ((browserType == 101 || browserType == 104) && !display.isChildrenLoaded() && ho instanceof ExperimenterData) {
            this.model.countExperimenterImages(display);
            return;
        }
        if (display.isChildrenLoaded()) {
            if (this.view.isFirstChildMessage(display)) {
                List l = display.getChildrenDisplay();
                ArrayList list = new ArrayList(l.size());
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    list.add(i.next());
                }
                this.view.setLeavesViews(list, (TreeImageSet)display);
            }
            return;
        }
        if ((ho instanceof ProjectData || ho instanceof ScreenData || ho instanceof PlateData || ho instanceof GroupData) && display.getNumberOfItems() == 0L) {
            return;
        }
        this.view.loadAction(display);
        if (display instanceof TreeImageTimeSet || display instanceof TreeFileSet) {
            this.model.loadExperimenterData(BrowserFactory.getDataOwner(display), display);
            return;
        }
        if (ho instanceof DatasetData || ho instanceof TagAnnotationData) {
            this.model.loadExperimenterData(BrowserFactory.getDataOwner(display), display);
        } else if (ho instanceof ExperimenterData) {
            this.model.loadExperimenterData(display, null);
        } else if (ho instanceof GroupData) {
            this.model.loadExperimenterData(display, display);
        }
    }

    void showPopupMenu(int index) {
        this.model.showPopupMenu(index);
    }

    void onClick(List<TreePath> added) {
        JTree tree = this.view.getTreeDisplay();
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            this.model.setSelectedDisplay(null);
            return;
        }
        ArrayList<TreePath> toRemove = new ArrayList<TreePath>();
        if (paths.length == 1) {
            Object p = paths[0].getLastPathComponent();
            if (!(p instanceof TreeImageDisplay)) {
                return;
            }
            TreeImageDisplay node = (TreeImageDisplay)p;
            if (node.isSelectable()) {
                TreeImageDisplay[] nodes = new TreeImageDisplay[]{node};
                this.model.setSelectedDisplays(nodes);
            } else {
                toRemove.add(paths[0]);
                this.view.removeTreePaths(toRemove);
                paths = tree.getSelectionPaths();
                TreeImageDisplay[] nodes = new TreeImageDisplay[paths.length];
                for (int j = 0; j < paths.length; ++j) {
                    nodes[j] = (TreeImageDisplay)paths[j].getLastPathComponent();
                }
                this.model.setSelectedDisplays(nodes);
            }
            return;
        }
        TreeImageDisplay previous = this.model.getLastSelectedDisplay();
        Object ho = previous.getUserObject();
        Class<?> ref = ho.getClass();
        ArrayList<TreeImageDisplay> l = new ArrayList<TreeImageDisplay>();
        String ns = null;
        if (TagAnnotationData.class.equals(ref)) {
            ns = ((TagAnnotationData)ho).getNameSpace();
        }
        if (added != null) {
            for (TreePath path : added) {
                TreeImageDisplay node = (TreeImageDisplay)path.getLastPathComponent();
                Object nho = node.getUserObject();
                if (nho.getClass().equals(ref) && node.isSelectable()) {
                    if (nho.getClass().equals(TagAnnotationData.class)) {
                        String nsNode = ((TagAnnotationData)nho).getNameSpace();
                        if (ns == null && nsNode == null) {
                            l.add(node);
                            continue;
                        }
                        if (ns == null && nsNode != null) {
                            toRemove.add(path);
                            continue;
                        }
                        if (ns != null && nsNode == null) {
                            toRemove.add(path);
                            continue;
                        }
                        if (ns == null || nsNode == null || !ns.equals(nsNode)) continue;
                        l.add(node);
                        continue;
                    }
                    l.add(node);
                    continue;
                }
                toRemove.add(path);
            }
        }
        if (toRemove.size() > 0) {
            String text = "";
            if (ImageData.class.equals(ref)) {
                text = "Images.";
            } else if (ProjectData.class.equals(ref)) {
                text = "Projects.";
            } else if (DatasetData.class.equals(ref)) {
                text = "Datasets.";
            } else if (ScreenData.class.equals(ref)) {
                text = "Screens.";
            } else if (PlateData.class.equals(ref)) {
                text = "Plates.";
            } else if (PlateAcquisitionData.class.equals(ref)) {
                text = "Acquisitions.";
            } else if (TagAnnotationData.class.equals(ref)) {
                TagAnnotationData tag = (TagAnnotationData)ho;
                text = "openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace()) ? "Tag Sets." : "Tags.";
            } else if (FileAnnotationData.class.equals(ref)) {
                text = "Files.";
            } else if (FileData.class.equals(ref)) {
                text = "Files.";
            } else if (ExperimenterData.class.equals(ref)) {
                text = "Experimenters";
            } else if (GroupData.class.equals(ref)) {
                text = "User Groups";
            }
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Tree selection", "You can only select " + text);
            this.view.removeTreePaths(toRemove);
        }
        paths = tree.getSelectionPaths();
        TreeImageDisplay[] nodes = new TreeImageDisplay[paths.length];
        for (int j = 0; j < paths.length; ++j) {
            nodes[j] = (TreeImageDisplay)paths[j].getLastPathComponent();
        }
        this.model.setSelectedDisplays(nodes);
    }

    Action getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int state = this.model.getState();
        switch (state) {
            case 14: {
                break;
            }
        }
        this.view.onStateChanged(state == 15);
    }
}

