/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PasteRndSettingsCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.WellSampleData;

public class ManageRndSettingsAction
extends TreeViewerAction {
    public static final int COPY = 0;
    public static final int PASTE = 1;
    public static final int RESET = 2;
    public static final int SET_MIN_MAX = 3;
    public static final int SET_OWNER_SETTING = 4;
    private static final String NAME_COPY = "Copy Settings";
    private static final String DESCRIPTION_COPY = "Copy the rendering settings.";
    private static final String NAME_PASTE = "Paste Settings";
    private static final String DESCRIPTION_PASTE = "Paste the rendering settings.";
    private static final String NAME_RESET = "Reset Default Settings";
    private static final String DESCRIPTION_RESET = "Reset the rendering settings created while importing.";
    private static final String NAME_SET_MIN_MAX = "Set Min/Max";
    private static final String DESCRIPTION_SET_MIN_MAX = "Set the Pixels Intensity interval to min/maxfor all channels.";
    private static final String NAME_SET_OWNER_SETTING = "Set Owner's Settings";
    private static final String DESCRIPTION_SET_OWNER_SETTING = "Set the Owner's rendering settings.";
    private int index;
    private IconManager icons;

    private void handleTreeTimeNode(TreeImageDisplay[] nodes) {
        int count = 0;
        for (int i = 0; i < nodes.length; ++i) {
            TreeImageTimeSet node = (TreeImageTimeSet)nodes[i];
            if (node.getNumberItems() <= 0L || !this.model.isObjectWritable(node)) continue;
            ++count;
        }
        this.setEnabled(count == nodes.length);
    }

    private void checkIndex(int value) {
        switch (value) {
            case 0: {
                this.name = NAME_COPY;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY));
                this.putValue("SmallIcon", this.icons.getIcon(24));
                break;
            }
            case 1: {
                this.name = NAME_PASTE;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE));
                this.putValue("SmallIcon", this.icons.getIcon(25));
                break;
            }
            case 2: {
                this.name = NAME_RESET;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_RESET));
                this.putValue("SmallIcon", this.icons.getIcon(138));
                break;
            }
            case 3: {
                this.name = NAME_SET_MIN_MAX;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SET_MIN_MAX));
                this.putValue("SmallIcon", this.icons.getIcon(139));
                break;
            }
            case 4: {
                this.name = NAME_SET_OWNER_SETTING;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SET_OWNER_SETTING));
                this.putValue("SmallIcon", this.icons.getIcon(140));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    protected void onBrowserStateChange(Browser browser) {
        if (browser != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        Browser browser = this.model.getSelectedBrowser();
        if (ho == null || browser == null) {
            this.setEnabled(false);
            return;
        }
        TreeImageDisplay[] selected = browser.getSelectedDisplays();
        int count = 0;
        switch (this.index) {
            case 0: {
                if (selected.length > 1) {
                    this.setEnabled(false);
                    break;
                }
                if (ho instanceof ImageData || ho instanceof WellSampleData) {
                    this.setEnabled(true);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 1: {
                if (!this.model.hasRndSettings()) {
                    this.setEnabled(false);
                    return;
                }
                if (selectedDisplay instanceof TreeImageTimeSet) {
                    this.handleTreeTimeNode(selected);
                    return;
                }
                if (!(ho instanceof ImageData || ho instanceof DatasetData || ho instanceof PlateData || ho instanceof ScreenData || ho instanceof ProjectData)) {
                    this.setEnabled(false);
                    break;
                }
                for (int i = 0; i < selected.length; ++i) {
                    if (!this.model.isObjectWritable(selected[i].getUserObject())) continue;
                    ++count;
                }
                this.setEnabled(count == selected.length);
                break;
            }
            case 2: 
            case 3: {
                if (selectedDisplay instanceof TreeImageTimeSet) {
                    this.handleTreeTimeNode(selected);
                    return;
                }
                if (!(ho instanceof ImageData || ho instanceof DatasetData || ho instanceof PlateData)) {
                    this.setEnabled(false);
                    break;
                }
                for (int i = 0; i < selected.length; ++i) {
                    if (!this.model.isObjectWritable(selected[i].getUserObject())) continue;
                    ++count;
                }
                this.setEnabled(count == selected.length);
                break;
            }
            case 4: {
                if (selectedDisplay instanceof TreeImageTimeSet) {
                    this.handleTreeTimeNode(selected);
                    return;
                }
                if (!(ho instanceof ImageData || ho instanceof DatasetData || ho instanceof PlateData)) {
                    this.setEnabled(false);
                    break;
                }
                for (int i = 0; i < selected.length; ++i) {
                    Object object = selected[i].getUserObject();
                    if (!this.model.isObjectWritable(object) || this.model.isUserOwner(object)) continue;
                    ++count;
                }
                this.setEnabled(count == selected.length);
            }
        }
    }

    public ManageRndSettingsAction(TreeViewer model, int index) {
        super(model);
        this.setEnabled(false);
        this.name = "Name";
        this.icons = IconManager.getInstance();
        this.checkIndex(index);
        this.index = index;
    }

    public void actionPerformed(ActionEvent e) {
        switch (this.index) {
            case 0: {
                this.model.copyRndSettings(null);
                break;
            }
            case 2: {
                PasteRndSettingsCmd cmd = new PasteRndSettingsCmd(this.model, 1);
                cmd.execute();
                break;
            }
            case 3: {
                PasteRndSettingsCmd cmd = new PasteRndSettingsCmd(this.model, 2);
                cmd.execute();
                break;
            }
            case 1: {
                PasteRndSettingsCmd cmd = new PasteRndSettingsCmd(this.model, 0);
                cmd.execute();
                break;
            }
            case 4: {
                PasteRndSettingsCmd cmd = new PasteRndSettingsCmd(this.model, 3);
                cmd.execute();
            }
        }
    }
}

