/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CopyCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CutCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.DeleteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PasteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public class ManageObjectAction
extends TreeViewerAction {
    public static final int COPY = 0;
    public static final int PASTE = 1;
    public static final int REMOVE = 2;
    public static final int CUT = 3;
    private static final String NAME_COPY = "Copy";
    private static final String DESCRIPTION_COPY = "Copy the selected elements.";
    private static final String NAME_PASTE = "Paste";
    private static final String DESCRIPTION_PASTE = "Paste the selected elements.";
    private static final String NAME_REMOVE = "Delete";
    private static final String DESCRIPTION_REMOVE = "Delete the selected elements.";
    private static final String NAME_CUT = "Cut";
    private static final String DESCRIPTION_CUT = "Cut the selected elements.";
    private int index;
    private IconManager icons = IconManager.getInstance();

    private void checkIndex(int value) {
        switch (value) {
            case 0: {
                this.name = NAME_COPY;
                this.putValue("Name", NAME_COPY);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY));
                this.putValue("SmallIcon", this.icons.getIcon(24));
                break;
            }
            case 1: {
                this.name = NAME_PASTE;
                this.putValue("Name", NAME_PASTE);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE));
                this.putValue("SmallIcon", this.icons.getIcon(25));
                break;
            }
            case 2: {
                this.name = NAME_REMOVE;
                this.putValue("Name", NAME_REMOVE);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_REMOVE));
                this.putValue("SmallIcon", this.icons.getIcon(26));
                break;
            }
            case 3: {
                this.name = NAME_CUT;
                this.putValue("Name", NAME_CUT);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CUT));
                this.putValue("SmallIcon", this.icons.getIcon(50));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    private boolean isPasteValid(Object ho, Class klass) {
        TagAnnotationData tag;
        if (ho instanceof ProjectData && DatasetData.class.equals((Object)klass)) {
            return true;
        }
        if (ho instanceof ScreenData && PlateData.class.equals((Object)klass)) {
            return true;
        }
        if (ho instanceof DatasetData && ImageData.class.equals((Object)klass)) {
            return true;
        }
        if (ho instanceof GroupData && ExperimenterData.class.equals((Object)klass)) {
            return true;
        }
        return ho instanceof TagAnnotationData && TagAnnotationData.class.equals((Object)klass) && "openmicroscopy.org/omero/insight/tagset".equals((tag = (TagAnnotationData)ho).getNameSpace());
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        int count = 0;
        TreeImageDisplay parentDisplay = selectedDisplay.getParentDisplay();
        Object parent = null;
        if (parentDisplay != null) {
            parent = parentDisplay.getUserObject();
        }
        switch (this.index) {
            case 1: {
                Class klass = this.model.hasDataToCopy();
                if (klass == null) {
                    this.setEnabled(false);
                    return;
                }
                if (ho instanceof ProjectData || ho instanceof ScreenData || ho instanceof DatasetData || ho instanceof GroupData || ho instanceof TagAnnotationData) {
                    TreeImageDisplay[] selected = browser.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        ho = selected[i].getUserObject();
                        if (!this.isPasteValid(ho, klass)) continue;
                        if (ho instanceof GroupData) {
                            ++count;
                            continue;
                        }
                        if (!this.model.isUserOwner(ho)) continue;
                        ++count;
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 2: {
                if (ho instanceof ProjectData || ho instanceof DatasetData || ho instanceof ScreenData || ho instanceof PlateData || ho instanceof PlateAcquisitionData || ho instanceof FileAnnotationData || ho instanceof TagAnnotationData || ho instanceof ImageData) {
                    TreeImageDisplay[] selected = browser.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        if (!this.model.isUserOwner(selected[i].getUserObject())) continue;
                        ++count;
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                if (ho instanceof ExperimenterData) {
                    if (browser.getBrowserType() == 107) {
                        this.setEnabled(false);
                        break;
                    }
                    this.setEnabled(false);
                    break;
                }
                if (ho instanceof GroupData) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 0: 
            case 3: {
                if (ho instanceof DatasetData || ho instanceof ImageData || ho instanceof PlateData) {
                    TreeImageDisplay[] selected = browser.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        if (!this.model.isUserOwner(selected[i].getUserObject())) continue;
                        ++count;
                    }
                    if (this.index == 3) {
                        if (ho instanceof DatasetData) {
                            if (!(parent instanceof ProjectData)) {
                                this.setEnabled(false);
                                return;
                            }
                        } else if (ho instanceof ImageData) {
                            if (!(parent instanceof DatasetData) && !(parent instanceof TagAnnotationData)) {
                                this.setEnabled(false);
                                return;
                            }
                        } else if (ho instanceof PlateData && !(parent instanceof ScreenData)) {
                            this.setEnabled(false);
                            return;
                        }
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                if (ho instanceof ExperimenterData) {
                    this.setEnabled(browser.getBrowserType() == 107);
                    break;
                }
                if (ho instanceof TagAnnotationData) {
                    TagAnnotationData tag = (TagAnnotationData)ho;
                    if ("openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                        this.setEnabled(false);
                        break;
                    }
                    TreeImageDisplay[] selected = browser.getSelectedDisplays();
                    for (int i = 0; i < selected.length; ++i) {
                        if (!this.model.isUserOwner(selected[i].getUserObject())) continue;
                        ++count;
                    }
                    if (this.index == 3 && !(parent instanceof TagAnnotationData)) {
                        this.setEnabled(false);
                        return;
                    }
                    this.setEnabled(count == selected.length);
                    break;
                }
                this.setEnabled(false);
            }
        }
    }

    public ManageObjectAction(TreeViewer model, int index) {
        super(model);
        this.checkIndex(index);
        this.index = index;
    }

    public void actionPerformed(ActionEvent e) {
        ActionCmd cmd = null;
        switch (this.index) {
            case 0: {
                cmd = new CopyCmd(this.model);
                break;
            }
            case 1: {
                cmd = new PasteCmd(this.model);
                break;
            }
            case 2: {
                cmd = new DeleteCmd(this.model.getSelectedBrowser());
                break;
            }
            case 3: {
                cmd = new CutCmd(this.model);
            }
        }
        if (cmd != null) {
            cmd.execute();
        }
    }
}

