/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.events.iviewer.ImageProjected;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsCopied;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewerCreated;
import org.openmicroscopy.shoola.agents.events.treeviewer.DataObjectSelectionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.SaveEventRequest;
import org.openmicroscopy.shoola.env.data.events.UserGroupSwitched;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.ActivityProcessEvent;
import org.openmicroscopy.shoola.env.ui.ViewObjectEvent;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ProjectData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeViewerAgent
implements Agent,
AgentEventListener {
    public static final String MULTI_USER = "MultiUser";
    public static final String LAYOUT_TYPE = "BrowserLayout";
    private static Registry registry;

    public static Registry getRegistry() {
        return registry;
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static Set getAvailableUserGroups() {
        return (Set)registry.lookup("/userGroup/details");
    }

    public static boolean isAdministrator() {
        Boolean b = (Boolean)registry.lookup("/users/administrator");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static Set getGroupsLeaderOf() {
        HashSet<GroupData> values = new HashSet<GroupData>();
        Set groups = TreeViewerAgent.getAvailableUserGroups();
        Iterator i = groups.iterator();
        ExperimenterData exp2 = TreeViewerAgent.getUserDetails();
        long id = exp2.getId();
        while (i.hasNext()) {
            GroupData g = (GroupData)i.next();
            Set leaders = g.getLeaders();
            if (leaders == null || leaders.size() <= 0) continue;
            for (ExperimenterData exp2 : leaders) {
                if (exp2.getId() != id) continue;
                values.add(g);
            }
        }
        return values;
    }

    public static boolean isLeaderOfCurrentGroup() {
        ExperimenterData exp = TreeViewerAgent.getUserDetails();
        Set groups = TreeViewerAgent.getGroupsLeaderOf();
        if (groups.size() == 0) {
            return false;
        }
        GroupData group = exp.getDefaultGroup();
        for (GroupData g : groups) {
            if (g.getId() != group.getId()) continue;
            return true;
        }
        return false;
    }

    private void handleCopyRndSettings(CopyRndSettings evt) {
        TreeViewerFactory.copyRndSettings(evt.getImage());
    }

    private void handleSaveEventRequest(SaveEventRequest evt) {
        Object origin = evt.getOrigin();
        if (!(origin instanceof TreeViewer)) {
            return;
        }
        TreeViewerFactory.saveOnClose(evt, this);
    }

    private void handleRndSettingsCopied(RndSettingsCopied evt) {
        TreeViewerFactory.onRndSettingsCopied(evt.getImagesIDs());
    }

    private void handleImageProjected(ImageProjected evt) {
        TreeViewer viewer;
        Environment env = (Environment)registry.lookup("/env");
        if (!env.isServerAvailable()) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        GroupData gp = exp.getDefaultGroup();
        long id = -1L;
        if (gp != null) {
            id = gp.getId();
        }
        if ((viewer = TreeViewerFactory.getTreeViewer(exp, id)) != null) {
            viewer.refreshTree();
        }
    }

    private void handleActivityFinished(ActivityProcessEvent evt) {
        TreeViewer viewer;
        Environment env = (Environment)registry.lookup("/env");
        if (!env.isServerAvailable()) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        GroupData gp = exp.getDefaultGroup();
        long id = -1L;
        if (gp != null) {
            id = gp.getId();
        }
        if ((viewer = TreeViewerFactory.getTreeViewer(exp, id)) != null) {
            viewer.onActivityProcessed(evt.getActivity(), evt.isFinished());
        }
    }

    private void handleViewerCreated(ViewerCreated evt) {
        Environment env = (Environment)registry.lookup("/env");
        if (!env.isServerAvailable()) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        GroupData gp = exp.getDefaultGroup();
        long id = -1L;
        if (gp != null) {
            id = gp.getId();
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp, id);
    }

    private void handleDataObjectSelectionEvent(DataObjectSelectionEvent evt) {
        TreeViewer viewer;
        Environment env = (Environment)registry.lookup("/env");
        if (!env.isServerAvailable()) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        GroupData gp = exp.getDefaultGroup();
        long id = -1L;
        if (gp != null) {
            id = gp.getId();
        }
        if ((viewer = TreeViewerFactory.getTreeViewer(exp, id)) != null) {
            viewer.findDataObject(evt.getDataType(), evt.getID(), evt.isSelectTab());
        }
    }

    private void handleUserGroupSwitched(UserGroupSwitched evt) {
        if (evt == null) {
            return;
        }
        Environment env = (Environment)registry.lookup("/env");
        if (!env.isServerAvailable()) {
            return;
        }
        TreeViewerFactory.onGroupSwitched(evt.isSuccessful());
    }

    private void handleViewObjectEvent(ViewObjectEvent evt) {
        Environment env = (Environment)registry.lookup("/env");
        if (!env.isServerAvailable()) {
            return;
        }
        if (evt == null) {
            return;
        }
        Object o = evt.getObject();
        if (o instanceof DatasetData || o instanceof ProjectData) {
            TreeViewer viewer;
            DataObject data = (DataObject)o;
            ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
            GroupData gp = exp.getDefaultGroup();
            long id = -1L;
            if (gp != null) {
                id = gp.getId();
            }
            if ((viewer = TreeViewerFactory.getTreeViewer(exp, id)) != null) {
                viewer.findDataObject(data.getClass(), data.getId(), false);
            }
        }
    }

    @Override
    public void activate() {
        TreeViewer viewer;
        Environment env = (Environment)registry.lookup("/env");
        if (env == null) {
            return;
        }
        if (!env.isServerAvailable()) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        GroupData gp = exp.getDefaultGroup();
        long id = -1L;
        if (gp != null) {
            id = gp.getId();
        }
        if ((viewer = TreeViewerFactory.getTreeViewer(exp, id)) != null) {
            viewer.activate();
        }
    }

    @Override
    public void terminate() {
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, CopyRndSettings.class);
        bus.register((AgentEventListener)this, SaveEventRequest.class);
        bus.register((AgentEventListener)this, RndSettingsCopied.class);
        bus.register((AgentEventListener)this, ImageProjected.class);
        bus.register((AgentEventListener)this, ActivityProcessEvent.class);
        bus.register((AgentEventListener)this, ViewerCreated.class);
        bus.register((AgentEventListener)this, UserGroupSwitched.class);
        bus.register((AgentEventListener)this, DataObjectSelectionEvent.class);
    }

    @Override
    public boolean canTerminate() {
        TreeViewerFactory.writeExternalApplications();
        return true;
    }

    @Override
    public AgentSaveInfo getDataToSave() {
        return null;
    }

    @Override
    public void save(List<Object> instances) {
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof CopyRndSettings) {
            this.handleCopyRndSettings((CopyRndSettings)e);
        } else if (e instanceof SaveEventRequest) {
            this.handleSaveEventRequest((SaveEventRequest)e);
        } else if (e instanceof RndSettingsCopied) {
            this.handleRndSettingsCopied((RndSettingsCopied)e);
        } else if (e instanceof ImageProjected) {
            this.handleImageProjected((ImageProjected)e);
        } else if (e instanceof ActivityProcessEvent) {
            this.handleActivityFinished((ActivityProcessEvent)e);
        } else if (e instanceof ViewerCreated) {
            this.handleViewerCreated((ViewerCreated)e);
        } else if (e instanceof UserGroupSwitched) {
            this.handleUserGroupSwitched((UserGroupSwitched)e);
        } else if (e instanceof DataObjectSelectionEvent) {
            this.handleDataObjectSelectionEvent((DataObjectSelectionEvent)e);
        } else if (e instanceof ViewObjectEvent) {
            this.handleViewObjectEvent((ViewObjectEvent)e);
        }
    }
}

