/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerControl;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerModel;
import org.openmicroscopy.shoola.agents.util.ViewedByItem;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.ProjectData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataViewerUI
extends TopWindow
implements PropertyChangeListener {
    private static final String PROJECT_MSG = "Project";
    private static final String DATASET_MSG = "Dataset";
    private static final String IMAGE_MSG = "Image";
    private static final String TITLE = "Add metadata";
    private static final String DESCRIPTION = "Add comments, tags, etc., to the selected items.";
    private MetadataViewerControl controller;
    private MetadataViewerModel model;
    private JPanel uiDelegate;
    private TitlePanel titlePanel;
    private Component source;
    private Point location;
    private JPopupMenu viewedByMenu;
    private JMenuItem thumbnailsMenuItem;

    private String getMessage() {
        Class<?> nodeType = this.model.getRefObject().getClass();
        if (nodeType.equals(ProjectData.class)) {
            return PROJECT_MSG;
        }
        if (nodeType.equals(DatasetData.class)) {
            return DATASET_MSG;
        }
        if (nodeType.equals(ImageData.class)) {
            return IMAGE_MSG;
        }
        return "";
    }

    private void buildGUI() {
        IconManager icons = IconManager.getInstance();
        this.titlePanel = new TitlePanel(TITLE, DESCRIPTION, icons.getIcon(43));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        JSplitPane pane = new JSplitPane();
        pane.setResizeWeight(1.0);
        pane.setOrientation(1);
        pane.setOneTouchExpandable(true);
        pane.setContinuousLayout(true);
        pane.setLeftComponent(this.model.getEditor().getUI());
        this.uiDelegate = new JPanel();
        this.uiDelegate.setLayout(new BorderLayout(0, 0));
        this.uiDelegate.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.uiDelegate.add((Component)this.model.getEditor().getUI(), "Center");
        c.add((Component)((Object)this.titlePanel), "North");
        c.add((Component)this.uiDelegate, "Center");
    }

    MetadataViewerUI() {
        super("");
    }

    void initialize(MetadataViewerControl controller, MetadataViewerModel model) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.buildGUI();
    }

    void setRootObject() {
        String message = this.getMessage();
        this.titlePanel.setTitle(message);
        this.titlePanel.setSubtitle("Edit the " + message.toLowerCase() + ": " + this.model.getRefObjectName());
        this.uiDelegate.revalidate();
        this.uiDelegate.repaint();
        this.viewedByMenu = null;
    }

    JComponent getUI() {
        return this.uiDelegate;
    }

    void onChannelColorChanged(int index) {
        this.model.getEditor().onChannelColorChanged(index);
    }

    void setLocationAndSource(Component source, Point location) {
        this.source = source;
        this.location = location;
    }

    void viewedBy() {
        if (this.viewedByMenu == null) {
            Map m = this.model.getViewedBy();
            this.viewedByMenu = new JPopupMenu();
            ViewerSorter sorter = new ViewerSorter();
            List list = sorter.sort(m.keySet());
            for (ExperimenterData exp : list) {
                ViewedByItem item = new ViewedByItem(exp, (RndProxyDef)m.get(exp));
                item.addPropertyChangeListener("viewedBy", this);
                this.viewedByMenu.add(item);
            }
            if (list.size() == 0) {
                this.thumbnailsMenuItem = new JMenuItem("Not viewed");
                this.thumbnailsMenuItem.setToolTipText("No other users viewed the image.");
            } else {
                IconManager icons = IconManager.getInstance();
                this.thumbnailsMenuItem = new JMenuItem("Show thumbnails");
                this.thumbnailsMenuItem.setIcon(icons.getIcon(112));
                this.thumbnailsMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MetadataViewerUI.this.showViewedBy();
                    }
                });
            }
            this.viewedByMenu.add(this.thumbnailsMenuItem);
        }
        this.viewedByMenu.show(this.source, this.location.x, this.location.y);
    }

    private void showViewedBy() {
        if (this.viewedByMenu == null) {
            return;
        }
        Component[] components = this.viewedByMenu.getComponents();
        ArrayList<ViewedByItem> items = new ArrayList<ViewedByItem>();
        for (int i = 0; i < components.length; ++i) {
            ViewedByItem item;
            BufferedImage img;
            Component comp = components[i];
            if (!(comp instanceof ViewedByItem) || (img = (item = (ViewedByItem)comp).getImage()) == null) continue;
            item.setImage(img);
            ViewedByItem itemNew = new ViewedByItem(item.getExperimenter(), item.getRndDef(), false);
            itemNew.setImage(img);
            itemNew.addPropertyChangeListener("viewedBy", this);
            items.add(itemNew);
        }
        this.model.getEditor().getRenderer().loadRndSettings(true, items);
    }

    void setThumbnails(Map<Long, BufferedImage> thumbnails) {
        if (this.viewedByMenu == null) {
            return;
        }
        Component[] components = this.viewedByMenu.getComponents();
        ArrayList<ViewedByItem> items = new ArrayList<ViewedByItem>();
        for (int i = 0; i < components.length; ++i) {
            ViewedByItem item;
            BufferedImage img;
            Component comp = components[i];
            if (!(comp instanceof ViewedByItem) || (img = thumbnails.get((item = (ViewedByItem)comp).getExperimenterID())) == null) continue;
            item.setImage(img);
            ViewedByItem itemNew = new ViewedByItem(item.getExperimenter(), item.getRndDef(), false);
            itemNew.setImage(img);
            itemNew.addPropertyChangeListener("viewedBy", this);
            items.add(itemNew);
        }
        this.thumbnailsMenuItem.setEnabled(items.size() > 0);
        this.model.getEditor().getRenderer().loadRndSettings(true, null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("viewedBy".equals(evt.getPropertyName())) {
            this.model.applyRenderingSettings((RndProxyDef)evt.getNewValue());
        }
    }

    @Override
    public void setOnScreen() {
    }
}

