/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.util.ComplexParamPane;
import org.openmicroscopy.shoola.agents.metadata.util.ScriptComponent;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.data.model.ParamData;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEWikiComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptingDialog
extends JDialog
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    public static final String RUN_SELECTED_SCRIPT_PROPERTY = "runSelectedScript";
    public static final String DOWNLOAD_SELECTED_SCRIPT_PROPERTY = "downloadSelectedScript";
    public static final String VIEW_SELECTED_SCRIPT_PROPERTY = "viewSelectedScript";
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private static final Color BG_COLOR = Color.LIGHT_GRAY;
    private static final String TITLE = "Run Script";
    private static final String TEXT = "Set the parameters of the selected script: ";
    private static final String TEXT_END = " * indicates the required parameter.";
    private static final int CANCEL = 0;
    private static final int APPLY = 1;
    private static final int DOWNLOAD = 2;
    private static final int VIEW = 3;
    private JButton cancelButton;
    private JButton applyButton;
    private JButton menuButton;
    private ScriptObject script;
    private Map<String, ScriptComponent> components;
    private ViewerSorter sorter;
    private JPopupMenu optionMenu;

    private JPopupMenu createOptionMenu() {
        if (this.optionMenu != null) {
            return this.optionMenu;
        }
        this.optionMenu = new JPopupMenu();
        this.optionMenu.add(this.createButton("Download", 2));
        this.optionMenu.add(this.createButton("View", 3));
        return this.optionMenu;
    }

    private JButton createButton(String text, int actionID) {
        JButton b = new JButton(text);
        b.setActionCommand("" + actionID);
        b.addActionListener(this);
        b.setOpaque(false);
        UIUtilities.unifiedButtonLookAndFeel(b);
        return b;
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void canRunScript() {
        Iterator<Map.Entry<String, ScriptComponent>> i = this.components.entrySet().iterator();
        int required = 0;
        int valueSet = 0;
        while (i.hasNext()) {
            Map.Entry<String, ScriptComponent> entry = i.next();
            ScriptComponent c = entry.getValue();
            if (!c.isRequired()) continue;
            ++required;
            Object value = c.getValue();
            if (value == null) continue;
            if (value instanceof String) {
                if (((String)value).length() == 0) continue;
                ++valueSet;
                continue;
            }
            ++valueSet;
        }
        this.applyButton.setEnabled(required == valueSet);
        if (!MetadataViewerAgent.isBinaryAvailable()) {
            this.applyButton.setEnabled(false);
        }
    }

    private void runScript() {
        Iterator<Map.Entry<String, ScriptComponent>> i = this.components.entrySet().iterator();
        Map<String, ParamData> inputs = this.script.getInputs();
        while (i.hasNext()) {
            Map.Entry<String, ScriptComponent> entry = i.next();
            ScriptComponent c = entry.getValue();
            ParamData param = inputs.get(entry.getKey());
            param.setValueToPass(c.getValue());
        }
        this.firePropertyChange(RUN_SELECTED_SCRIPT_PROPERTY, null, this.script);
        this.close();
    }

    private JComboBox createValuesBox(List<Object> values, Object defValue) {
        if (values == null) {
            return null;
        }
        Object[] v = new Object[values.size()];
        Iterator<Object> i = values.iterator();
        int j = 0;
        while (i.hasNext()) {
            v[j] = i.next();
            ++j;
        }
        JComboBox<Object> box = new JComboBox<Object>(v);
        if (defValue != null) {
            box.setSelectedItem(defValue);
        }
        return box;
    }

    private void initComponents() {
        List<ScriptComponent> l;
        String grouping;
        this.sorter = new ViewerSorter();
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Close the dialog.");
        this.cancelButton.setActionCommand("0");
        this.cancelButton.addActionListener(this);
        this.applyButton = new JButton("Run");
        this.applyButton.setToolTipText("Run the script.");
        this.applyButton.setActionCommand("1");
        this.applyButton.addActionListener(this);
        IconManager icons = IconManager.getInstance();
        this.menuButton = new JButton(icons.getIcon(108));
        this.menuButton.setText("Script");
        this.menuButton.setHorizontalTextPosition(2);
        this.menuButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                Object src = e.getSource();
                if (src instanceof Component) {
                    Point p = e.getPoint();
                    ScriptingDialog.this.createOptionMenu().show((Component)src, p.x, p.y);
                }
            }
        });
        this.components = new LinkedHashMap<String, ScriptComponent>();
        Map<String, ParamData> types = this.script.getInputs();
        if (types == null) {
            return;
        }
        ArrayList<ScriptComponent> results = new ArrayList<ScriptComponent>();
        Iterator<Map.Entry<String, ParamData>> i = types.entrySet().iterator();
        String details = "";
        String text = "";
        HashMap<String, ArrayList<ScriptComponent>> childrenMap = new HashMap<String, ArrayList<ScriptComponent>>();
        HashMap parents = new HashMap();
        while (i.hasNext()) {
            text = "";
            JComponent comp = null;
            Map.Entry<String, ParamData> entry = i.next();
            ParamData param = entry.getValue();
            String name = entry.getKey();
            Class type = param.getPrototype();
            List<Object> values = param.getValues();
            Object defValue = param.getDefaultValue();
            if (values != null && values.size() > 0) {
                comp = this.createValuesBox(values, defValue);
            }
            if (Long.class.equals((Object)type) || Integer.class.equals((Object)type) || Float.class.equals((Object)type) || Double.class.equals((Object)type)) {
                if (comp == null) {
                    comp = new NumericalTextField();
                    ((NumericalTextField)comp).setNumberType(type);
                    Number n = param.getMinValue();
                    if (n != null) {
                        if (Long.class.equals((Object)type)) {
                            text = text + "Min: " + n.longValue() + " ";
                            ((NumericalTextField)comp).setMinimum(n.longValue());
                        } else if (Integer.class.equals((Object)type)) {
                            text = text + "Min: " + n.intValue() + " ";
                            ((NumericalTextField)comp).setMinimum(n.intValue());
                        } else if (Double.class.equals((Object)type)) {
                            text = text + "Min: " + n.doubleValue() + " ";
                            ((NumericalTextField)comp).setMinimum(n.doubleValue());
                        } else if (Float.class.equals((Object)type)) {
                            text = text + "Min: " + n.floatValue() + " ";
                            ((NumericalTextField)comp).setMinimum(n.floatValue());
                        }
                    }
                    if ((n = param.getMaxValue()) != null) {
                        if (Long.class.equals((Object)type)) {
                            text = text + "Max: " + n.longValue() + " ";
                            ((NumericalTextField)comp).setMaximum(n.longValue());
                        } else if (Integer.class.equals((Object)type)) {
                            text = text + "Max: " + n.intValue() + " ";
                            ((NumericalTextField)comp).setMaximum(n.intValue());
                        } else if (Double.class.equals((Object)type)) {
                            text = text + "Max: " + n.doubleValue() + " ";
                            ((NumericalTextField)comp).setMaximum(n.doubleValue());
                        } else if (Float.class.equals((Object)type)) {
                            text = text + "Max: " + n.floatValue() + " ";
                            ((NumericalTextField)comp).setMaximum(n.floatValue());
                        }
                    }
                    if (defValue != null) {
                        ((NumericalTextField)comp).setText("" + defValue);
                    }
                }
            } else if (String.class.equals((Object)type)) {
                if (comp == null) {
                    comp = new JTextField();
                    if (defValue != null) {
                        ((JTextField)comp).setText("" + defValue);
                    }
                }
            } else if (Boolean.class.equals((Object)type)) {
                if (comp == null) {
                    comp = new JCheckBox();
                    if (defValue != null) {
                        ((JCheckBox)comp).setSelected((Boolean)defValue);
                    }
                }
            } else if (Map.class.equals((Object)type)) {
                comp = comp == null ? new ComplexParamPane(param.getKeyType(), param.getValueType()) : new ComplexParamPane(param.getKeyType(), (JComboBox)comp);
            } else if (List.class.equals((Object)type)) {
                comp = comp == null ? new ComplexParamPane(param.getKeyType()) : new ComplexParamPane((JComboBox)comp);
            }
            if (comp == null) continue;
            if (comp instanceof JTextField) {
                ((JTextField)comp).setColumns(ScriptComponent.COLUMNS);
                ((JTextField)comp).getDocument().addDocumentListener(this);
            }
            if (comp instanceof ComplexParamPane) {
                comp.addPropertyChangeListener(this);
            }
            comp.setToolTipText(param.getDescription());
            ScriptComponent c = new ScriptComponent(comp, name);
            if (text.trim().length() > 0) {
                c.setUnit(text);
            }
            if (!(comp instanceof JComboBox) && !(comp instanceof JCheckBox)) {
                c.setRequired(!param.isOptional());
            }
            if (details != null && details.trim().length() > 0) {
                c.setInfo(details);
            }
            grouping = param.getGrouping();
            String parent = param.getParent();
            c.setParentIndex(parent);
            if (parent.length() > 0) {
                l = (List)childrenMap.get(parent);
                if (l == null) {
                    l = new ArrayList<ScriptComponent>();
                    childrenMap.put(parent, (ArrayList<ScriptComponent>)l);
                }
                l.add(c);
            }
            if (grouping.length() > 0) {
                c.setGrouping(grouping);
                c.setNameLabel(grouping);
            } else {
                c.setNameLabel(name);
            }
            results.add(c);
        }
        for (ScriptComponent key : results) {
            grouping = key.getGrouping();
            l = (ArrayList<ScriptComponent>)childrenMap.get(grouping);
            if (l == null) continue;
            key.setChildren(l);
        }
        List sortedKeys = this.sorter.sort(results);
        for (ScriptComponent key : sortedKeys) {
            this.components.put(key.getParameterName(), key);
        }
        this.canRunScript();
    }

    private JPanel buildControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setBorder(null);
        controlPanel.add(this.applyButton);
        controlPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        controlPanel.add(this.cancelButton);
        controlPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 1));
        bar.add(controlPanel);
        bar.add(Box.createVerticalStrut(10));
        JPanel all = new JPanel();
        all.setLayout(new BoxLayout(all, 0));
        all.add(UIUtilities.buildComponentPanel(this.menuButton));
        all.add(UIUtilities.buildComponentPanelRight(bar));
        return all;
    }

    private JComponent buildDescriptionPane() {
        String description = this.script.getDescription();
        if (description == null || description.trim().length() == 0) {
            return null;
        }
        OMEWikiComponent area = new OMEWikiComponent(false);
        area.setEnabled(false);
        area.setText(description);
        JPanel p = UIUtilities.buildComponentPanel(area);
        p.setBackground(BG_COLOR);
        area.setBackground(BG_COLOR);
        return p;
    }

    private JPanel buildScriptDetails() {
        JLabel l;
        String[] authors = this.script.getAuthors();
        String contact = this.script.getContact();
        String version = this.script.getVersion();
        if (authors == null && contact == null && version == null) {
            return null;
        }
        JPanel p = new JPanel();
        p.setBackground(BG_COLOR);
        double[] columns = new double[]{-2.0, 5.0, -1.0};
        TableLayout layout = new TableLayout();
        layout.setColumn(columns);
        p.setLayout((LayoutManager)layout);
        int row = 0;
        if (authors != null && authors.length > 0) {
            l = UIUtilities.setTextFont("Authors:");
            String v = "";
            int n = authors.length - 1;
            for (int i = 0; i < authors.length; ++i) {
                v = v + authors[i];
                if (i >= n) continue;
                v = v + ", ";
            }
            layout.insertRow(row, -2.0);
            p.add((Component)l, "0," + row);
            l = new JLabel();
            l.setText(v);
            p.add((Component)l, "2," + row);
            ++row;
        }
        if (contact != null && contact.trim().length() != 0) {
            l = UIUtilities.setTextFont("Contact:");
            layout.insertRow(row, -2.0);
            p.add((Component)l, "0," + row);
            l = new JLabel();
            l.setText(contact);
            p.add((Component)l, "2," + row);
            ++row;
        }
        if (version != null && version.trim().length() != 0) {
            l = UIUtilities.setTextFont("Version:");
            layout.insertRow(row, -2.0);
            p.add((Component)l, "0," + row);
            l = new JLabel();
            l.setText(version);
            p.add((Component)l, "2," + row);
        }
        if (p.getComponentCount() == 0) {
            return null;
        }
        return p;
    }

    private JPanel buildBody() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        double[] columns = new double[]{-2.0, 5.0, -1.0};
        TableLayout layout = new TableLayout();
        layout.setColumn(columns);
        p.setLayout((LayoutManager)layout);
        int row = 0;
        JComponent area = this.buildDescriptionPane();
        JPanel authorsPane = this.buildScriptDetails();
        if (area != null) {
            layout.insertRow(row, -2.0);
            p.add((Component)area, "0," + row + ", 2, " + row);
            ++row;
            if (authorsPane == null) {
                layout.insertRow(row, -2.0);
                p.add((Component)new JSeparator(), "0," + row + ", 2, " + row);
                ++row;
            }
        }
        if (authorsPane != null) {
            layout.insertRow(row, -2.0);
            p.add((Component)authorsPane, "0," + row + ", 2, " + row);
            layout.insertRow(++row, -2.0);
            p.add((Component)new JSeparator(), "0," + row + ", 2, " + row);
            ++row;
        }
        Iterator<Map.Entry<String, ScriptComponent>> i = this.components.entrySet().iterator();
        int required = 0;
        while (i.hasNext()) {
            Map.Entry<String, ScriptComponent> entry = i.next();
            ScriptComponent comp = entry.getValue();
            layout.insertRow(row, -2.0);
            comp.buildUI();
            if (comp.isRequired()) {
                ++required;
            }
            p.add((Component)comp, "0," + row + ", 2, " + row);
            ++row;
        }
        if (required > 0) {
            JLabel label = new JLabel(TEXT_END);
            Font font = label.getFont();
            label.setFont(font.deriveFont(font.getStyle(), font.getSize() - 2));
            label.setForeground(UIUtilities.REQUIRED_FIELDS_COLOR);
            layout.insertRow(row, -2.0);
            p.add((Component)UIUtilities.buildComponentPanel(label), "0," + row + ",2, " + row);
        }
        JPanel controls = new JPanel();
        controls.setLayout(new BorderLayout(0, 0));
        controls.add((Component)new JScrollPane(p), "Center");
        controls.add((Component)this.buildControlPanel(), "South");
        return controls;
    }

    private void buildGUI() {
        String text = TEXT + this.script.getDisplayedName();
        TitlePanel tp = new TitlePanel(TITLE, text, this.script.getIconLarge());
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.buildBody(), "Center");
    }

    public ScriptingDialog(JFrame parent, ScriptObject script) {
        super(parent);
        if (script == null) {
            throw new IllegalArgumentException("No script specified");
        }
        this.script = script;
        this.initComponents();
        this.buildGUI();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.runScript();
                break;
            }
            case 2: {
                this.firePropertyChange(DOWNLOAD_SELECTED_SCRIPT_PROPERTY, null, this.script);
                break;
            }
            case 3: {
                this.firePropertyChange(VIEW_SELECTED_SCRIPT_PROPERTY, null, this.script);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("modifiedContent".equals(name)) {
            this.canRunScript();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.canRunScript();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.canRunScript();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

