/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.UserDiskSpace;
import org.openmicroscopy.shoola.agents.metadata.editor.UserProfile;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.AnnotationData;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UserUI
extends AnnotationUI
implements PropertyChangeListener {
    static final String TITLE = "Disk Space";
    private static final String TITLE_DETAILS = "Personal details";
    private UserProfile profile;
    private UserDiskSpace diskSpace;
    private JXTaskPane diskTask;
    private List space;

    private void initComponents(EditorControl control) {
        this.profile = new UserProfile(this.model);
        this.profile.addPropertyChangeListener(control);
        JXTaskPane pane = EditorUtil.createTaskPane(TITLE_DETAILS);
        pane.add((Component)this.profile, null, 0);
        this.diskSpace = new UserDiskSpace(this);
        this.diskTask = EditorUtil.createTaskPane(TITLE);
        this.diskTask.add((Component)this.diskSpace, null, 0);
        this.diskTask.addPropertyChangeListener("collapsed", (PropertyChangeListener)this);
        JXTaskPaneContainer container = new JXTaskPaneContainer();
        container.setBackground(UIUtilities.BACKGROUND);
        if (container.getLayout() instanceof VerticalLayout) {
            VerticalLayout vl = (VerticalLayout)container.getLayout();
            vl.setGap(0);
        }
        container.add(pane);
        container.add(this.diskTask);
        this.setLayout(new BorderLayout());
        this.add((Component)container, "North");
    }

    UserUI(EditorModel model, EditorControl control) {
        super(model);
        if (control == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.initComponents(control);
    }

    void passwordChanged() {
        this.profile.passwordChanged();
    }

    Object getExperimenterToSave() {
        return this.profile.getExperimenterToSave();
    }

    void setDiskSpace(List space) {
        this.space = space;
    }

    List isDiskSpaceLoaded() {
        return this.space;
    }

    void setUserPhoto(BufferedImage photo) {
        this.profile.setUserPhoto(photo);
    }

    @Override
    protected void buildUI() {
        this.profile.buildGUI();
        this.diskSpace.buildGUI();
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void clearData() {
        this.space = null;
        this.clearDisplay();
    }

    @Override
    protected void clearDisplay() {
        this.diskSpace.clearDisplay();
        if (!this.diskTask.isCollapsed()) {
            this.diskTask.setCollapsed(true);
        }
        this.diskSpace.revalidate();
    }

    @Override
    protected List<AnnotationData> getAnnotationToRemove() {
        return new ArrayList<AnnotationData>();
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        return new ArrayList<AnnotationData>();
    }

    @Override
    protected String getComponentTitle() {
        return "";
    }

    @Override
    protected boolean hasDataToSave() {
        return this.profile.hasDataToSave();
    }

    @Override
    protected void setComponentTitle() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!(this.model.getRefObject() instanceof ExperimenterData)) {
            return;
        }
        if (this.diskTask.isCollapsed()) {
            this.model.cancelDiskSpaceLoading();
        } else {
            this.model.loadDiskSpace(this.model.getRefObjectID());
        }
    }
}

