/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.PermissionsPane;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.AnnotationData;
import pojos.ExperimenterData;
import pojos.GroupData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupProfile
extends AnnotationUI
implements DocumentListener,
PropertyChangeListener {
    private JTextField namePane;
    private JTextField descriptionPane;
    private PermissionsPane permissionsPane;
    private int level;

    private void initComponents() {
        GroupData data = (GroupData)this.model.getRefObject();
        this.permissionsPane = new PermissionsPane(data.getPermissions(), UIUtilities.BACKGROUND_COLOR);
        this.level = this.permissionsPane.getPermissions();
        this.permissionsPane.setBorder(BorderFactory.createTitledBorder("Permissions"));
        this.permissionsPane.displayWarningText();
        this.permissionsPane.addPropertyChangeListener(this);
        this.namePane = new JTextField();
        this.namePane.setText(data.getName());
        this.descriptionPane = new JTextField();
        this.descriptionPane.setText(data.getDescription());
        GroupData group = (GroupData)this.model.getRefObject();
        ExperimenterData exp = MetadataViewerAgent.getUserDetails();
        Set l = group.getLeaders();
        boolean edit = false;
        if (l != null) {
            for (ExperimenterData leader : l) {
                if (leader.getId() != exp.getId()) continue;
                edit = true;
                break;
            }
        }
        if (!edit) {
            edit = MetadataViewerAgent.isAdministrator();
        }
        this.namePane.setEditable(edit);
        if (edit) {
            this.namePane.getDocument().addDocumentListener(this);
        }
        this.descriptionPane.getDocument().addDocumentListener(this);
    }

    private JPanel buildContentPanel() {
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        JComponent label = EditorUtil.getLabel("Name", true);
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.namePane, c);
        c.gridx = 0;
        ++c.gridy;
        label = UIUtilities.setTextFont("Description");
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.descriptionPane, c);
        c.gridx = 0;
        ++c.gridy;
        label = UIUtilities.setTextFont("* indicates the required fields.", 2);
        label.setForeground(UIUtilities.REQUIRED_FIELDS_COLOR);
        c.weightx = 0.0;
        content.add((Component)label, c);
        return content;
    }

    private JPanel buildOwnersPane() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        GroupData group = (GroupData)this.model.getRefObject();
        Set leaders = group.getLeaders();
        if (leaders == null || leaders.size() == 0) {
            return p;
        }
        for (ExperimenterData exp : leaders) {
            p.add(new JLabel(exp.getFirstName() + " " + exp.getLastName()));
        }
        JPanel content = UIUtilities.buildComponentPanel(p);
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createTitledBorder("Owners"));
        return content;
    }

    GroupProfile(EditorModel model) {
        super(model);
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    AdminObject getAdminObject() {
        GroupData data = (GroupData)this.model.getRefObject();
        String v = this.namePane.getText();
        v = v.trim();
        if (!data.getName().equals(v)) {
            AdminService svc = MetadataViewerAgent.getRegistry().getAdminService();
            try {
                GroupData g = svc.lookupGroup(v);
                if (g != null && data.getId() != g.getId()) {
                    UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
                    un.notifyInfo("Update Group", "A group with the same name already exists.");
                    return null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            data.setName(v);
        }
        v = this.descriptionPane.getText();
        v = v.trim();
        String description = data.getDescription();
        if (description == null) {
            description = "";
        }
        if (!description.equals(v)) {
            data.setDescription(v);
        }
        AdminObject o = new AdminObject(data, null, 2);
        if (this.level != this.permissionsPane.getPermissions()) {
            o.setPermissions(this.permissionsPane.getPermissions());
        }
        return o;
    }

    @Override
    protected void buildUI() {
        this.removeAll();
        this.initComponents();
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.weightx = 1.0;
        p.add((Component)this.buildContentPanel(), c);
        ++c.gridy;
        p.add((Component)this.permissionsPane, c);
        ++c.gridy;
        p.add((Component)this.buildOwnersPane(), c);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)p, "North");
    }

    @Override
    protected void clearData() {
        this.clearDisplay();
    }

    @Override
    protected void clearDisplay() {
        this.revalidate();
        this.repaint();
    }

    @Override
    protected List<AnnotationData> getAnnotationToRemove() {
        return new ArrayList<AnnotationData>();
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        return new ArrayList<AnnotationData>();
    }

    @Override
    protected String getComponentTitle() {
        return "Group";
    }

    @Override
    protected boolean hasDataToSave() {
        GroupData data = (GroupData)this.model.getRefObject();
        String v = this.namePane.getText();
        v = v.trim();
        if (!data.getName().equals(v)) {
            return true;
        }
        v = this.descriptionPane.getText();
        v = v.trim();
        String description = data.getDescription();
        if (description == null) {
            description = "";
        }
        if (!description.equals(v)) {
            return true;
        }
        return this.level != this.permissionsPane.getPermissions();
    }

    @Override
    protected void setComponentTitle() {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("permissionsChange".equals(name)) {
            this.firePropertyChange("save", (Object)false, (Object)true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

