/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.actions.RndAction;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ManageRndSettingsAction
extends RndAction
implements MouseListener {
    public static final int MIN_MAX = 0;
    public static final int RESET = 1;
    public static final int UNDO = 2;
    public static final int APPLY_TO_ALL = 3;
    public static final int SET_OWNER_SETTING = 4;
    public static final int ABSOLUTE_MIN_MAX = 5;
    private static final String NAME_APPLY_TO_ALL = "Apply to All";
    private static final String NAME_ABSOLUTE_MIN_MAX = "Full Range";
    private static final String NAME_MIN_MAX = "Min/Max";
    private static final String NAME_UNDO = "Undo";
    private static final String NAME_RESET = "Reset";
    public static final String NAME_OWNER = "Viewed by";
    private static final String DESCRIPTION_MIN_MAX = "Set the Pixels Intensity interval to min/max for all channels.";
    private static final String DESCRIPTION_ABSOLUTE_MIN_MAX = "Set the Pixels Intensity interval to the full range for all channels.";
    private static final String DESCRIPTION_UNDO = "Undo the changes.";
    private static final String DESCRIPTION_RESET = "Reset the rendering settings created while importing.";
    private static final String DESCRIPTION_APPLY_TO_ALL = "Apply the rendering settings to all images.";
    private static final String DESCRIPTION_SET_OWNER_SETTING = "View the image using the rendering settings used by other users.";
    private int index;

    private void checkIndex(int value) {
        IconManager icons = IconManager.getInstance();
        switch (value) {
            case 0: {
                this.putValue("Name", NAME_MIN_MAX);
                this.setEnabled(this.model.getPixelsDimensionsC() < 10);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_MIN_MAX));
                this.putValue("SmallIcon", icons.getIcon(103));
                break;
            }
            case 5: {
                this.putValue("Name", NAME_ABSOLUTE_MIN_MAX);
                this.setEnabled(this.model.getPixelsDimensionsC() < 10);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_ABSOLUTE_MIN_MAX));
                this.putValue("SmallIcon", icons.getIcon(103));
                break;
            }
            case 1: {
                this.putValue("Name", NAME_RESET);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_RESET));
                this.putValue("SmallIcon", icons.getIcon(102));
                break;
            }
            case 2: {
                this.putValue("Name", NAME_UNDO);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_UNDO));
                this.putValue("SmallIcon", icons.getIcon(105));
                break;
            }
            case 3: {
                this.putValue("Name", NAME_APPLY_TO_ALL);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_APPLY_TO_ALL));
                this.putValue("SmallIcon", icons.getIcon(106));
                break;
            }
            case 4: {
                this.putValue("Name", NAME_OWNER);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SET_OWNER_SETTING));
                this.putValue("SmallIcon", icons.getIcon(104));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not valid.");
            }
        }
    }

    public ManageRndSettingsAction(Renderer model, int index) {
        super(model);
        this.setEnabled(true);
        this.checkIndex(index);
        this.index = index;
    }

    public void actionPerformed(ActionEvent e) {
        switch (this.index) {
            case 0: {
                this.model.setRangeAllChannels(false);
                break;
            }
            case 5: {
                this.model.setRangeAllChannels(true);
                break;
            }
            case 1: {
                this.model.resetSettings();
                break;
            }
            case 2: {
                this.model.resetSettings(this.model.getInitialRndSettings(), true);
                break;
            }
            case 3: {
                this.model.applyToAll();
            }
        }
    }

    public void mouseReleased(MouseEvent me) {
        if (this.index != 4) {
            return;
        }
        Object source = me.getSource();
        if (source instanceof Component) {
            this.model.retrieveRelatedSettings((Component)source, me.getPoint());
        }
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }
}

