/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Tool;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.actions.DrawingAction;
import org.openmicroscopy.shoola.agents.measurement.util.workflow.CreateWorkflowDialog;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.measurement.view.WorkflowPanel;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureEllipseFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineConnectionFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureRectangleFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.io.IOConstants;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.FigureProperties;
import org.openmicroscopy.shoola.util.ui.drawingtools.creationtools.DrawingBezierTool;
import org.openmicroscopy.shoola.util.ui.drawingtools.creationtools.DrawingConnectionTool;
import org.openmicroscopy.shoola.util.ui.drawingtools.creationtools.DrawingObjectCreationTool;
import org.openmicroscopy.shoola.util.ui.drawingtools.creationtools.DrawingPointCreationTool;
import org.openmicroscopy.shoola.util.ui.drawingtools.creationtools.DrawingToolBarButtonFactory;
import pojos.WorkflowData;

class ToolBar
extends JPanel
implements MouseListener {
    private static final Map<AttributeKey, Object> defaultConnectionAttributes = new HashMap<AttributeKey, Object>();
    private static final boolean addPolyline = false;
    private static final boolean addPolygon = true;
    private static final boolean addConnection = false;
    private static final String CREATE_KEY = "create";
    private static final Dimension HGLUE;
    private FigureProperties lineConnectionProperties;
    private JToolBar toolBar;
    private MeasurementViewerControl controller;
    private MeasurementViewerUI view;
    private MeasurementViewerModel model;
    private MeasurementViewer measurementcomponent;
    private DrawingObjectCreationTool ellipseTool;
    private DrawingObjectCreationTool rectTool;
    private DrawingObjectCreationTool lineTool;
    private DrawingObjectCreationTool textTool;
    private DrawingPointCreationTool pointTool;
    private DrawingBezierTool polygonTool;
    private DrawingBezierTool polylineTool;
    private DrawingConnectionTool connectionTool;
    private JButton assistantButton;
    private WorkflowPanel workflowPanel;
    private CreateWorkflowDialog createWorkflowDialog;

    private void setUpToggleButton(JToggleButton button) {
        button.setAction(new DrawingAction(this.measurementcomponent, button));
        button.addMouseListener(this);
    }

    private void initComponents() {
        this.lineConnectionProperties = new FigureProperties(defaultConnectionAttributes);
        this.ellipseTool = new DrawingObjectCreationTool(new MeasureEllipseFigure(false, true));
        this.rectTool = new DrawingObjectCreationTool(new MeasureRectangleFigure(false, true));
        this.textTool = new DrawingObjectCreationTool(new MeasureTextFigure(false, true));
        this.lineTool = new DrawingObjectCreationTool(new MeasureLineFigure(false, true));
        this.connectionTool = new DrawingConnectionTool((ConnectionFigure)new MeasureLineConnectionFigure(), this.lineConnectionProperties.getProperties());
        this.pointTool = new DrawingPointCreationTool(new MeasurePointFigure(false, true));
        this.polygonTool = new DrawingBezierTool(new MeasureBezierFigure(true, false, true));
        this.polylineTool = new DrawingBezierTool(new MeasureBezierFigure(false, false, true));
        this.toolBar = DrawingToolBarButtonFactory.createDefaultBar();
        DrawingEditor editor = this.model.getDrawingEditor();
        DrawingToolBarButtonFactory.addSelectionToolTo(this.toolBar, editor, true);
        Component component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
        this.toolBar.add(new JSeparator());
        this.toolBar.add(Box.createRigidArea(HGLUE));
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.rectTool, "createRectangle");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.ellipseTool, "createEllipse");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.pointTool, "createEllipse");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            JToggleButton button = (JToggleButton)component;
            IconManager icons = IconManager.getInstance();
            button.setIcon(icons.getIcon(24));
            button.setToolTipText("Point");
            this.setUpToggleButton(button);
        }
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.lineTool, "createLine");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.polygonTool, "createPolygon");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.textTool, "createText");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
        this.workflowPanel = new WorkflowPanel(this.view, this.model, this.controller);
    }

    private JToolBar buildControlsBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        JButton button = new JButton(this.controller.getAction(MeasurementViewerControl.SAVE));
        UIUtilities.unifiedButtonLookAndFeel(button);
        bar.add(button);
        button = new JButton(this.controller.getAction(MeasurementViewerControl.LOAD));
        UIUtilities.unifiedButtonLookAndFeel(button);
        bar.add(button);
        this.assistantButton = new JButton(this.controller.getAction(MeasurementViewerControl.ROI_ASSISTANT));
        UIUtilities.unifiedButtonLookAndFeel(this.assistantButton);
        bar.add(this.assistantButton);
        button = new JButton(this.controller.getAction(MeasurementViewerControl.DELETE));
        UIUtilities.unifiedButtonLookAndFeel(button);
        bar.add(button);
        bar.add(new JSeparator());
        return bar;
    }

    private void buildGUI() {
        JPanel j = new JPanel();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.buildControlsBar());
        p.add(Box.createHorizontalStrut(5));
        p.add(this.toolBar);
        this.setLayout(new FlowLayout(0));
        j.setLayout(new BoxLayout(j, 1));
        j.add(p);
        this.add(j);
    }

    ToolBar(MeasurementViewer component, MeasurementViewerUI view, MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (component == null) {
            throw new IllegalArgumentException("No component.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.measurementcomponent = component;
        this.view = view;
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    protected boolean rightClick(MouseEvent e) {
        return e.getButton() == 3 || e.getButton() == 1 && e.isControlDown();
    }

    void createSingleFigure(boolean option) {
        this.ellipseTool.setResetToSelect(option);
        this.rectTool.setResetToSelect(option);
        this.textTool.setResetToSelect(option);
        this.lineTool.setResetToSelect(option);
        this.pointTool.setResetToSelect(option);
        this.polygonTool.setResetToSelect(option);
    }

    void onFigureSelected() {
        int size = this.view.getDrawingView().getSelectedFigures().size();
        this.assistantButton.getAction().setEnabled(size == 1);
    }

    void updateWorkflow() {
        this.workflowPanel.updateWorkflow();
    }

    WorkflowPanel getWorkflowPanel() {
        return this.workflowPanel;
    }

    void createWorkflow() {
        this.createWorkflowDialog = new CreateWorkflowDialog(this.model.getWorkflowDataList());
        List<WorkflowData> newWorkflows = this.createWorkflowDialog.show();
        if (newWorkflows != null) {
            this.model.resetWorkflows(newWorkflows);
            this.model.saveWorkflowToServer(false);
            this.model.retrieveWorkflowsFromServer();
        }
    }

    void addedWorkflow() {
        this.workflowPanel.addedWorkflow();
    }

    public void mouseClicked(MouseEvent e) {
        if (this.rightClick(e)) {
            this.createSingleFigure(false);
            JToggleButton button = (JToggleButton)e.getSource();
            button.setSelected(true);
        } else {
            this.createSingleFigure(this.view.isCreateSingleFigure());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    static {
        defaultConnectionAttributes.put(MeasurementAttributes.FILL_COLOR, IOConstants.DEFAULT_FILL_COLOUR);
        defaultConnectionAttributes.put(MeasurementAttributes.STROKE_COLOR, IOConstants.DEFAULT_STROKE_COLOUR);
        defaultConnectionAttributes.put(MeasurementAttributes.TEXT_COLOR, IOConstants.DEFAULT_TEXT_COLOUR);
        defaultConnectionAttributes.put(MeasurementAttributes.FONT_SIZE, new Double(10.0));
        defaultConnectionAttributes.put(MeasurementAttributes.FONT_BOLD, false);
        defaultConnectionAttributes.put(MeasurementAttributes.STROKE_WIDTH, new Double(1.0));
        defaultConnectionAttributes.put(MeasurementAttributes.TEXT, "Text");
        defaultConnectionAttributes.put(MeasurementAttributes.MEASUREMENTTEXT_COLOUR, IOConstants.DEFAULT_MEASUREMENT_TEXT_COLOUR);
        defaultConnectionAttributes.put(MeasurementAttributes.SHOWMEASUREMENT, Boolean.FALSE);
        defaultConnectionAttributes.put(DrawingAttributes.SHOWTEXT, Boolean.FALSE);
        HGLUE = new Dimension(5, 5);
    }
}

