/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurementTool;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.actions.ActivationAction;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerComponent;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import pojos.ChannelData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementViewerFactory
implements ChangeListener {
    private static final String MENU_NAME = "ROI Tool";
    private static final MeasurementViewerFactory singleton = new MeasurementViewerFactory();
    private Set<MeasurementViewer> viewers = new HashSet<MeasurementViewer>();
    private Set<MeasurementTool> requests = new HashSet<MeasurementTool>();
    private JMenu windowMenu = new JMenu("ROI Tool");
    private boolean isAttached = false;

    static JMenu getWindowMenu() {
        return MeasurementViewerFactory.singleton.windowMenu;
    }

    static void attachWindowMenuToTaskBar() {
        if (MeasurementViewerFactory.singleton.isAttached) {
            return;
        }
        TaskBar tb = MeasurementAgent.getRegistry().getTaskBar();
        tb.addToMenu(0, MeasurementViewerFactory.singleton.windowMenu);
        MeasurementViewerFactory.singleton.isAttached = true;
    }

    static void register(JMenu menu) {
        if (menu == null) {
            return;
        }
        Iterator<MeasurementViewer> i = MeasurementViewerFactory.singleton.viewers.iterator();
        menu.removeAll();
        while (i.hasNext()) {
            menu.add(new JMenuItem(new ActivationAction(i.next())));
        }
    }

    public static MeasurementViewer getViewer(PixelsData pixels, long imageID, String name, Rectangle bounds, int z, int t, double magnification, Map activeChannels, List<ChannelData> channelsData) {
        MeasurementViewerModel model = new MeasurementViewerModel(imageID, pixels, name, bounds, channelsData);
        model.setPlane(z, t);
        model.setMagnification(magnification);
        model.setActiveChannels(activeChannels);
        return singleton.createROIViewer(model);
    }

    public static MeasurementViewer getViewer(long pixelsID) {
        for (MeasurementViewerComponent measurementViewerComponent : MeasurementViewerFactory.singleton.viewers) {
            if (measurementViewerComponent.getModel().getPixelsID() != pixelsID) continue;
            return measurementViewerComponent;
        }
        return null;
    }

    public static void addRequest(MeasurementTool request) {
        if (request == null) {
            return;
        }
        MeasurementViewerFactory.singleton.requests.add(request);
    }

    public static MeasurementTool getRequest(long pixelsID) {
        for (MeasurementTool request : MeasurementViewerFactory.singleton.requests) {
            PixelsData pixels = request.getPixels();
            if (pixels == null || pixels.getId() != pixelsID) continue;
            return request;
        }
        return null;
    }

    public static List<Object> getInstancesToSave() {
        if (MeasurementViewerFactory.singleton.viewers.size() == 0) {
            return null;
        }
        ArrayList<Object> instances = new ArrayList<Object>();
        for (MeasurementViewerComponent measurementViewerComponent : MeasurementViewerFactory.singleton.viewers) {
            if (!measurementViewerComponent.hasROIToSave()) continue;
            instances.add(measurementViewerComponent);
        }
        return instances;
    }

    public static void saveInstances(List<Object> instances) {
        if (instances != null) {
            for (Object o : instances) {
                if (!(o instanceof MeasurementViewerComponent)) continue;
                MeasurementViewerComponent comp = (MeasurementViewerComponent)o;
                comp.saveAndDiscard();
            }
        }
    }

    public static void onGroupSwitched(boolean success) {
        if (!success) {
            return;
        }
        singleton.clear();
    }

    public static void onROIDeleted(long imageID) {
        if (MeasurementViewerFactory.singleton.viewers.size() == 0) {
            return;
        }
        for (MeasurementViewerComponent measurementViewerComponent : MeasurementViewerFactory.singleton.viewers) {
            measurementViewerComponent.onROIDeleted(imageID);
            if (!measurementViewerComponent.hasROIToSave()) continue;
            measurementViewerComponent.saveROIToServer();
        }
    }

    private MeasurementViewerFactory() {
    }

    private void clear() {
        if (this.viewers.size() == 0) {
            return;
        }
        for (MeasurementViewerComponent measurementViewerComponent : this.viewers) {
            measurementViewerComponent.removeChangeListener(this);
            measurementViewerComponent.discard();
        }
        this.viewers.clear();
        this.requests.clear();
    }

    private MeasurementViewer createROIViewer(MeasurementViewerModel model) {
        for (MeasurementViewerComponent measurementViewerComponent : this.viewers) {
            if (!model.isSameDisplay(measurementViewerComponent.getModel())) continue;
            return measurementViewerComponent;
        }
        MeasurementViewerComponent measurementViewerComponent = new MeasurementViewerComponent(model);
        measurementViewerComponent.initialize();
        measurementViewerComponent.addChangeListener(this);
        this.viewers.add(measurementViewerComponent);
        return measurementViewerComponent;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        MeasurementViewerComponent comp = (MeasurementViewerComponent)e.getSource();
        if (comp.getState() == 6) {
            this.viewers.remove(comp);
        }
    }
}

