/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChannelSelectionForm
extends JPanel {
    static int SUMMARYVALUE = -10;
    private Map<Integer, String> channelNames;
    private List<JCheckBox> checkBox;

    private int getSelectedChannel(String comboBoxName) {
        for (int channel : this.channelNames.keySet()) {
            String channelString = this.channelNames.get(channel);
            if (!channelString.equals(comboBoxName)) continue;
            return channel;
        }
        return -1;
    }

    private void buildComponents() {
        this.checkBox = new ArrayList<JCheckBox>(this.channelNames.size() + 1);
        Iterator<Integer> nameIterator = this.channelNames.keySet().iterator();
        JCheckBox cBox = new JCheckBox("Channel Summary");
        cBox.setSelected(true);
        this.checkBox.add(cBox);
        while (nameIterator.hasNext()) {
            cBox = new JCheckBox(this.channelNames.get(nameIterator.next()));
            cBox.setSelected(false);
            this.checkBox.add(cBox);
        }
    }

    private void buildUI() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JLabel l = new JLabel("Select Channels to Save: ");
        mainPanel.add(UIUtilities.buildComponentPanel(l));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        for (int i = 0; i < this.checkBox.size(); ++i) {
            panel.add(this.checkBox.get(i));
        }
        mainPanel.add(UIUtilities.buildComponentPanel(panel));
        this.setLayout(new BorderLayout());
        this.add((Component)UIUtilities.buildComponentPanel(mainPanel), "Center");
    }

    ChannelSelectionForm(Map<Integer, String> channelNames) {
        this.channelNames = channelNames;
        this.buildComponents();
        this.buildUI();
    }

    List<Integer> getUserSelection() {
        ArrayList<Integer> selection = new ArrayList<Integer>();
        if (this.checkBox.get(0).isSelected()) {
            selection.add(SUMMARYVALUE);
        }
        for (int i = 1; i < this.checkBox.size(); ++i) {
            int index;
            if (!this.checkBox.get(i).isSelected() || (index = this.getSelectedChannel(this.checkBox.get(i).getText())) == -1) continue;
            selection.add(index);
        }
        return selection;
    }
}

