/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROIActionController;

public class ROIAction
extends AbstractAction {
    protected ROIActionController.CreationActionType action;
    protected ROIActionController controller;

    private void setName(String name) {
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
    }

    private void setToolTip(String name) {
        this.putValue("LongDescription", name);
    }

    public ROIAction(ROIActionController controller, ROIActionController.CreationActionType action) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (action == null) {
            throw new IllegalArgumentException("No Action type specified.");
        }
        this.controller = controller;
        this.action = action;
        this.setEnabled(false);
        switch (action) {
            case DUPLICATE: {
                this.setName("Duplicate");
                this.setToolTip("Duplicate the selected ROI, ROIShapes, creating new ROI.");
                break;
            }
            case DELETE: {
                this.setName("Delete");
                this.setToolTip("Delete selected ROI and ROIShapes.");
                break;
            }
            case MERGE: {
                this.setName("Merge");
                this.setToolTip("Merge the selected ROIShapes into a new ROI.");
                break;
            }
            case SPLIT: {
                this.setName("Split");
                this.setToolTip("Split the selected ROIShapes from parent ROI into a new ROI.");
                break;
            }
            case PROPAGATE: {
                this.setName("Propagate");
                this.setToolTip("Propagate the selected ROI through Time and Z Sections.");
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        switch (this.action) {
            case DUPLICATE: {
                this.setName("Duplicate");
                this.controller.duplicateROI();
                break;
            }
            case DELETE: {
                this.setName("Delete");
                this.controller.deleteROI();
                break;
            }
            case MERGE: {
                this.setName("Merge");
                this.controller.mergeROI();
                break;
            }
            case SPLIT: {
                this.setName("Split");
                this.controller.splitROI();
                break;
            }
            case PROPAGATE: {
                this.setName("Propagate");
                this.controller.propagateROI();
            }
        }
    }
}

