/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import com.sun.opengl.util.texture.TextureData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import omero.model.PlaneInfo;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.imviewer.ContainerLoader;
import org.openmicroscopy.shoola.agents.imviewer.DataLoader;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.ImageDataLoader;
import org.openmicroscopy.shoola.agents.imviewer.ImageLoader;
import org.openmicroscopy.shoola.agents.imviewer.MeasurementsLoader;
import org.openmicroscopy.shoola.agents.imviewer.OverlaysRenderer;
import org.openmicroscopy.shoola.agents.imviewer.PlaneInfoLoader;
import org.openmicroscopy.shoola.agents.imviewer.ProjectionSaver;
import org.openmicroscopy.shoola.agents.imviewer.RenderingSettingsCreator;
import org.openmicroscopy.shoola.agents.imviewer.RenderingSettingsLoader;
import org.openmicroscopy.shoola.agents.imviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.imviewer.util.HistoryItem;
import org.openmicroscopy.shoola.agents.imviewer.util.player.ChannelPlayer;
import org.openmicroscopy.shoola.agents.imviewer.util.proj.ProjectionRef;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.data.model.TableResult;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PixelsData;
import pojos.WellData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImViewerModel {
    private static final int MAX_HISTORY = 10;
    private static final int THUMB_MAX_WIDTH = 24;
    private static final int THUMB_MAX_HEIGHT = 24;
    private static final int SETTINGS = 0;
    private static final int RND = 1;
    private DataObject image;
    private int state;
    private ImViewer component;
    private Map<Integer, DataLoader> loaders;
    private Browser browser;
    private ChannelPlayer player;
    private int sizeX;
    private int sizeY;
    private double factor;
    private BufferedImage imageIcon;
    private Rectangle requesterBounds;
    private int tabbedIndex;
    private boolean textVisible;
    private boolean playingMovie;
    private boolean playingChannelMovie;
    private List<HistoryItem> historyItems;
    private int movieIndex;
    private Map renderingSettings;
    private MetadataViewer metadataViewer;
    private boolean metadataLoaded;
    private long currentPixelsID;
    private RndProxyDef alternativeSettings;
    private long selectedUserID;
    private boolean initMagnificationFactor;
    private DataObject parent;
    private DataObject grandParent;
    private Map<Integer, PlaneInfo> planeInfos;
    private long imageID;
    private RndProxyDef originalDef;
    private RndProxyDef lastMainDef;
    private RndProxyDef lastProjDef;
    private ProjectionParam lastProjRef;
    private int lastProjTime;
    private Collection containers;
    private Collection measurements;
    private boolean separateWindow;
    private long overlayTableID;
    private Boolean asynchronousCall;
    private double originalRatio;
    private Dimension computedSize;

    private Integer linearize(int z, int c, int t) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return -1;
        }
        int sizeZ = rnd.getPixelsDimensionsZ();
        int sizeC = rnd.getPixelsDimensionsC();
        int sizeT = rnd.getPixelsDimensionsT();
        if (z < 0 || sizeZ <= z) {
            return -1;
        }
        if (c < 0 || sizeC <= c) {
            return -1;
        }
        if (t < 0 || sizeT <= t) {
            return -1;
        }
        return sizeZ * sizeC * t + sizeZ * c + z;
    }

    private void computeSizes() {
        if (this.sizeX == -1 && this.sizeY == -1) {
            double y;
            this.sizeX = 24;
            this.sizeY = 24;
            double x = (double)this.sizeX / (double)this.getMaxX();
            this.factor = x > (y = (double)this.sizeY / (double)this.getMaxY()) ? x : y;
            double ratio = (double)this.getMaxX() / (double)this.getMaxY();
            if (ratio < 1.0) {
                this.sizeX = (int)((double)this.sizeX * ratio);
            } else if (ratio > 1.0 && ratio != 0.0) {
                this.sizeY = (int)((double)this.sizeY * (1.0 / ratio));
            }
        }
    }

    private double initZoomFactor() {
        return -1.0;
    }

    private void initialize(Rectangle bounds, boolean separateWindow) {
        this.separateWindow = separateWindow;
        this.originalRatio = 1.0;
        this.asynchronousCall = null;
        this.overlayTableID = -1L;
        this.requesterBounds = bounds;
        this.state = 1;
        this.initMagnificationFactor = false;
        this.sizeY = -1;
        this.sizeX = -1;
        this.tabbedIndex = 0;
        this.textVisible = true;
        this.movieIndex = -1;
        this.loaders = new HashMap<Integer, DataLoader>();
        this.metadataViewer = null;
        this.metadataLoaded = false;
        this.currentPixelsID = -1L;
        this.selectedUserID = -1L;
        this.lastProjTime = -1;
        this.lastProjRef = null;
    }

    private void initializeMetadataViewer() {
        this.metadataViewer = MetadataViewerFactory.getViewer("", 1);
        this.metadataViewer.setRootObject(this.image, this.metadataViewer.getUserID());
    }

    private ImageData getImage() {
        if (this.image instanceof WellSampleData) {
            return ((WellSampleData)this.image).getImage();
        }
        return (ImageData)this.image;
    }

    ImViewerModel(long imageID, Rectangle bounds, boolean separateWindow) {
        this.imageID = imageID;
        this.initialize(bounds, separateWindow);
    }

    ImViewerModel(DataObject image, Rectangle bounds, boolean separateWindow) {
        this.image = image;
        this.initialize(bounds, separateWindow);
        this.initializeMetadataViewer();
        this.currentPixelsID = this.getImage().getDefaultPixels().getId();
    }

    void initialize(ImViewer component) {
        this.component = component;
        this.browser = BrowserFactory.createBrowser(component, ImViewerFactory.getPreferences());
    }

    ExperimenterData getUserDetails() {
        return (ExperimenterData)ImViewerAgent.getRegistry().lookup("/current_user/details");
    }

    void setAlternativeSettings(RndProxyDef alternativeSettings, long userID) {
        this.alternativeSettings = alternativeSettings;
        this.selectedUserID = userID;
    }

    long getAlternativeSettingsOwnerId() {
        return this.selectedUserID;
    }

    boolean isSameDisplay(ImViewerModel other) {
        return other != null;
    }

    boolean isSameParent(DataObject data) {
        if (data != null && this.parent != null) {
            if (this.parent instanceof WellData) {
                if (this.grandParent != null && data.getClass().getName().equals(this.grandParent.getClass().getName())) {
                    return data.getId() == this.grandParent.getId();
                }
            } else if (data.getClass().getName().equals(this.parent.getClass().getName())) {
                return data.getId() == this.parent.getId();
            }
        }
        return false;
    }

    String getImageName() {
        if (this.image == null) {
            return "";
        }
        return this.getImage().getName();
    }

    String getImageTitle() {
        return "[ID: " + this.getImageID() + "] " + EditorUtil.getPartialName(this.getImageName());
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.state = 7;
        if (this.image == null) {
            return;
        }
        OmeroImageService svr = ImViewerAgent.getRegistry().getImageService();
        long pixelsID = this.getImage().getDefaultPixels().getId();
        svr.shutDown(pixelsID);
        for (Integer index : this.loaders.keySet()) {
            this.loaders.get(index).cancel();
        }
        if (this.player == null) {
            return;
        }
        this.player.setPlayerState(1);
        this.player = null;
    }

    int getMaxX() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getPixelsDimensionsX();
    }

    int getMaxY() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getPixelsDimensionsY();
    }

    int getMaxZ() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getPixelsDimensionsZ() - 1;
    }

    int getMaxT() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getPixelsDimensionsT() - 1;
    }

    int getDefaultZ() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getDefaultZ();
    }

    int getDefaultT() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getDefaultT();
    }

    String getColorModel() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return "greyscale";
        }
        return rnd.getColorModel();
    }

    List<ChannelData> getChannelData() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return new ArrayList<ChannelData>();
        }
        return rnd.getChannelData();
    }

    ChannelData getChannelData(int index) {
        List<ChannelData> list = this.getChannelData();
        for (ChannelData channel : list) {
            if (channel.getIndex() != index) continue;
            return channel;
        }
        return null;
    }

    Color getChannelColor(int w) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        return rnd.getChannelColor(w);
    }

    boolean isChannelActive(int w) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.isChannelActive(w);
    }

    void firePlaneInfoRetrieval() {
        if (this.planeInfos != null && this.planeInfos.size() > 0) {
            return;
        }
        int size = this.getMaxT() * this.getMaxC() * this.getMaxZ();
        if (size > 6000) {
            return;
        }
        PlaneInfoLoader loader = new PlaneInfoLoader(this.component, this.getPixelsID());
        loader.load();
    }

    void fireImageRetrieval() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        PlaneDef pDef = new PlaneDef();
        pDef.t = this.getDefaultT();
        pDef.z = this.getDefaultZ();
        pDef.slice = 0;
        this.state = 3;
        if (this.asynchronousCall == null) {
            this.asynchronousCall = this.getMaxX() >= 1024 || this.getMaxY() >= 1024;
        }
        if (this.asynchronousCall.booleanValue()) {
            pDef.x = this.computedSize.width;
            pDef.y = this.computedSize.height;
            ImageLoader loader = new ImageLoader(this.component, this.getPixelsID(), pDef, this.isBigImage());
            loader.load();
        } else if (ImViewerAgent.hasOpenGLSupport()) {
            this.component.setImageAsTexture(rnd.renderPlaneAsTexture(pDef));
        } else {
            this.component.setImage(rnd.renderPlane(pDef));
        }
    }

    BufferedImage getSplitComponentImage() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        PlaneDef pDef = new PlaneDef();
        pDef.t = this.getDefaultT();
        pDef.z = this.getDefaultZ();
        pDef.slice = 0;
        return rnd.renderPlane(pDef);
    }

    TextureData getSplitComponentImageAsTexture() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        PlaneDef pDef = new PlaneDef();
        pDef.t = this.getDefaultT();
        pDef.z = this.getDefaultZ();
        pDef.slice = 0;
        return rnd.renderPlaneAsTexture(pDef);
    }

    void onRndLoaded() {
        this.state = 6;
        double f = this.initZoomFactor();
        if (f > 0.0) {
            this.browser.initializeMagnificationFactor(f);
        }
        try {
            Renderer rnd = this.metadataViewer.getRenderer();
            if (this.alternativeSettings != null && rnd != null) {
                rnd.resetSettings(this.alternativeSettings, false);
            }
            this.alternativeSettings = null;
            if (rnd != null) {
                this.originalDef = rnd.getRndSettingsCopy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Browser getBrowser() {
        return this.browser;
    }

    MetadataViewer getMetadataViewer() {
        return this.metadataViewer;
    }

    void setZoomFactor(double factor, boolean reset) {
        this.browser.setZoomFactor(factor, reset);
    }

    double getZoomFactor() {
        return this.browser.getZoomFactor();
    }

    boolean isZoomFitToWindow() {
        return this.getZoomFactor() == -1.0;
    }

    double setImage(BufferedImage image) {
        this.state = 6;
        this.browser.setRenderedImage(image);
        return this.initZoomFactor();
    }

    void createImageIcon() {
        BufferedImage img = this.browser.getRenderedImage();
        if (img != null) {
            this.computeSizes();
            this.imageIcon = Factory.magnifyImage(this.factor, img);
        }
    }

    boolean isInitMagnificationFactor() {
        return this.initMagnificationFactor;
    }

    void setColorModel(String colorModel, boolean update) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        if ("greyscale".equals(colorModel)) {
            rnd.setOverlays(this.overlayTableID, null);
            rnd.setColorModel(colorModel, update);
        } else if ("rgb".equals(colorModel)) {
            rnd.setColorModel("rgb", update);
        }
    }

    void setSelectedXYPlane(int z, int t) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setSelectedXYPlane(z, t, -1);
    }

    void setChannelColor(int index, Color c) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setChannelColor(index, c);
    }

    void setChannelActive(int index, boolean active) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setActive(index, active);
    }

    int getMaxLifetimeBin() {
        if (this.isNumerousChannel()) {
            return this.getMaxC();
        }
        return 0;
    }

    boolean isNumerousChannel() {
        if (this.getMaxC() >= 10) {
            return true;
        }
        return this.getImage().isLifetime();
    }

    boolean allowSplitView() {
        if (this.getMaxC() <= 1) {
            return false;
        }
        return !this.isNumerousChannel();
    }

    boolean isBigImage() {
        return this.getMaxX() > 3072 || this.getMaxY() > 3072;
    }

    int getMaxC() {
        return this.getImage().getDefaultPixels().getSizeC();
    }

    int getActiveChannelsCount() {
        return this.getActiveChannels().size();
    }

    List<Integer> getActiveChannels() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return new ArrayList<Integer>();
        }
        return rnd.getActiveChannels();
    }

    void playMovie(boolean play) {
        if (this.player != null && !play) {
            this.player.setPlayerState(1);
            List l = this.player.getChannels();
            if (l != null) {
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    this.setChannelActive((Integer)i.next(), true);
                }
            }
            this.player = null;
            if (this.state != 3) {
                this.state = 6;
            }
            this.playingChannelMovie = false;
            return;
        }
        this.playingChannelMovie = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImViewerModel.this.player = new ChannelPlayer(ImViewerModel.this.component);
                ImViewerModel.this.player.setPlayerState(0);
            }
        });
        this.state = 8;
    }

    boolean isPlayingChannelMovie() {
        return this.playingChannelMovie;
    }

    void setState(int state) {
        this.state = state;
    }

    BufferedImage getDisplayedImage() {
        return this.browser.getDisplayedImage();
    }

    BufferedImage getOriginalImage() {
        return this.browser.getRenderedImage();
    }

    BufferedImage getProjectedImage() {
        return this.browser.getProjectedImage();
    }

    BufferedImage getGridImage() {
        return this.browser.getGridImage();
    }

    TextureData getImageAsTexture() {
        return this.browser.getImageAsTexture();
    }

    TextureData getProjectedImageAsTexture() {
        return this.browser.getProjectedImageAsTexture();
    }

    double getPixelsSizeX() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return -1.0;
        }
        return rnd.getPixelsSizeX();
    }

    double getPixelsSizeY() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return -1.0;
        }
        return rnd.getPixelsSizeY();
    }

    double getPixelsSizeZ() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return -1.0;
        }
        return rnd.getPixelsSizeZ();
    }

    boolean isUnitBar() {
        return this.browser.isUnitBar();
    }

    BufferedImage getImageIcon() {
        return this.imageIcon;
    }

    Rectangle getRequesterBounds() {
        return this.requesterBounds;
    }

    long getPixelsID() {
        return this.currentPixelsID;
    }

    int getTabbedIndex() {
        return this.tabbedIndex;
    }

    void setTabbedIndex(int index) {
        this.tabbedIndex = index;
    }

    boolean[] hasRGB() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        return rnd.hasRGB();
    }

    boolean isTextVisible() {
        return this.textVisible;
    }

    void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
    }

    boolean isImageLoaded() {
        return this.image != null;
    }

    long getImageID() {
        if (this.image == null) {
            return this.imageID;
        }
        return this.getImage().getId();
    }

    void saveRndSettings(boolean reset) throws RenderingServiceException, DSOutOfServiceException {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        RndProxyDef def = rnd.saveCurrentSettings();
        if (reset) {
            this.originalDef = def;
            if (def != null && this.renderingSettings != null) {
                this.renderingSettings.put(ImViewerAgent.getUserDetails(), def);
            }
        }
    }

    void setPlayingMovie(boolean play, int index) {
        this.playingMovie = play;
        this.movieIndex = index;
    }

    boolean isPlayingMovie() {
        return this.playingMovie;
    }

    boolean isColorComponent(int band, int index) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.isColorComponent(band, index);
    }

    Map<Integer, Color> getActiveChannelsColorMap() {
        List<Integer> l = this.getActiveChannels();
        HashMap<Integer, Color> m = new HashMap<Integer, Color>(l.size());
        for (Integer index : l) {
            m.put(index, this.getChannelColor(index));
        }
        return m;
    }

    Map<Integer, Color> getChannelsColorMap() {
        HashMap<Integer, Color> m = new HashMap<Integer, Color>(this.getMaxC());
        for (int i = 0; i < this.getMaxC(); ++i) {
            m.put(i, this.getChannelColor(i));
        }
        return m;
    }

    void setLastSettingsRef(int index) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        switch (index) {
            case 1: 
            case 2: {
                this.lastMainDef = rnd.getRndSettingsCopy();
                break;
            }
            case 0: {
                this.lastProjDef = rnd.getRndSettingsCopy();
            }
        }
    }

    HistoryItem createHistoryItem() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return null;
        }
        String title = null;
        BufferedImage img = null;
        Color c = null;
        RndProxyDef def = rnd.getRndSettingsCopy();
        switch (this.getTabbedIndex()) {
            case 2: {
                title = "Projection";
                img = this.browser.getProjectedImage();
                this.lastProjDef = def;
                c = Color.GREEN.brighter();
                break;
            }
            case 0: {
                title = "Image";
                img = this.browser.getRenderedImage();
                this.lastMainDef = def;
            }
        }
        if (img == null) {
            return null;
        }
        double ratio = 1.0;
        int w = img.getWidth();
        int h = img.getHeight();
        ratio = w < 96 || h < 96 ? 1.0 : (w >= h ? 96.0 / (double)w : 96.0 / (double)h);
        BufferedImage thumb = Factory.magnifyImage(ratio, img);
        HistoryItem i = new HistoryItem(def, thumb, title);
        i.setHighlight(c);
        i.allowClose(false);
        i.setIndex(this.getTabbedIndex());
        if (this.historyItems == null) {
            this.historyItems = new ArrayList<HistoryItem>();
        }
        if (this.historyItems.size() == 10) {
            this.historyItems.remove(1);
        }
        this.historyItems.add(i);
        return i;
    }

    RndProxyDef getOriginalDef() {
        return this.originalDef;
    }

    RndProxyDef getLastMainDef() {
        return this.lastMainDef;
    }

    RndProxyDef getLastProjDef() {
        return this.lastProjDef;
    }

    void removeHistoryItem(HistoryItem node) {
        if (this.historyItems != null) {
            this.historyItems.remove(node);
        }
    }

    void clearHistory() {
        if (this.historyItems == null || this.historyItems.size() == 0) {
            return;
        }
        HistoryItem node = this.historyItems.get(0);
        this.historyItems.clear();
        this.historyItems.add(node);
        this.lastMainDef = node.getRndSettings();
        this.lastProjDef = null;
        this.lastProjTime = -1;
    }

    List<HistoryItem> getHistory() {
        return this.historyItems;
    }

    void resetMappingSettings(RndProxyDef settings) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.resetSettings(settings, false);
    }

    void setLastRndDef(RndProxyDef settings) {
        switch (this.getTabbedIndex()) {
            case 2: {
                this.lastProjDef = settings;
                break;
            }
            case 0: {
                this.lastMainDef = settings;
            }
        }
    }

    void resetOriginalSettings(RndProxyDef settings) {
        this.originalDef = settings;
        if (settings != null && this.renderingSettings != null) {
            this.renderingSettings.put(ImViewerAgent.getUserDetails(), settings);
        }
    }

    void fireLoadRndSettingsToPaste() {
        long id = ImViewerFactory.getRefImage().getDefaultPixels().getId();
        if (id < 0L) {
            return;
        }
        RenderingSettingsLoader loader = new RenderingSettingsLoader(this.component, id, true);
        loader.load();
        this.state = 14;
    }

    void resetDefaultRndSettings() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.resetSettings();
    }

    void setOriginalRndSettings() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setOriginalRndSettings();
    }

    boolean hasRndToPaste() {
        if (this.metadataViewer == null) {
            return false;
        }
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        ImageData image = ImViewerFactory.getRefImage();
        if (image == null) {
            return false;
        }
        PixelsData pixels = image.getDefaultPixels();
        if (pixels == null) {
            return false;
        }
        return rnd.validatePixels(pixels);
    }

    void copyRenderingSettings() {
        CopyRndSettings evt = new CopyRndSettings(this.getImage());
        EventBus bus = ImViewerAgent.getRegistry().getEventBus();
        bus.post(evt);
    }

    int getMovieIndex() {
        return this.movieIndex;
    }

    boolean isImageCompressed() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.isCompressed();
    }

    void setCompressionLevel(int compressionLevel) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setCompression(compressionLevel);
    }

    int getCompressionLevel() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return 0;
        }
        return rnd.getCompressionLevel();
    }

    void fireRenderingSettingsRetrieval() {
        RenderingSettingsLoader loader = new RenderingSettingsLoader(this.component, this.getImage().getDefaultPixels().getId());
        ((DataLoader)loader).load();
        if (this.loaders.get(0) != null) {
            this.loaders.get(0).cancel();
        }
        this.loaders.put(0, loader);
    }

    void fireOwnerSettingsRetrieval() {
        RenderingSettingsLoader loader = new RenderingSettingsLoader(this.component, this.getImage().getDefaultPixels().getId());
        loader.setOwner(this.getOwnerID());
        loader.load();
        if (this.loaders.get(0) != null) {
            this.loaders.get(0).cancel();
        }
        this.loaders.put(0, loader);
    }

    Map getRenderingSettings() {
        return this.renderingSettings;
    }

    void setRenderingSettings(Map map) {
        this.renderingSettings = map;
        this.loaders.remove(0);
    }

    void setUserSettings(ExperimenterData exp) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        RndProxyDef rndDef = (RndProxyDef)this.renderingSettings.get(exp);
        rnd.resetSettings(rndDef, false);
    }

    long getOwnerID() {
        return this.image.getOwner().getId();
    }

    boolean hasMetadataToSave() {
        if (this.metadataViewer == null) {
            return false;
        }
        return this.metadataViewer.hasDataToSave();
    }

    void saveMetadata() {
        if (this.metadataViewer != null) {
            this.metadataViewer.saveData();
        }
    }

    void loadMetadata() {
        if (!this.metadataLoaded) {
            this.metadataLoaded = true;
            LinkedHashMap<ChannelData, Color> m = new LinkedHashMap<ChannelData, Color>();
            List<ChannelData> sorted = this.getChannelData();
            for (ChannelData channel : sorted) {
                m.put(channel, this.getChannelColor(channel.getIndex()));
            }
            this.metadataViewer.activate(m);
        }
    }

    void resetHistory() {
        this.historyItems = null;
    }

    void fireRenderProjected(int startZ, int endZ, int stepping, int type) {
        this.state = 12;
        ProjectionParam param = new ProjectionParam(this.getPixelsID(), startZ, endZ, stepping, type);
        param.setChannels(this.getActiveChannels());
        this.lastProjRef = param;
        ProjectionSaver loader = new ProjectionSaver(this.component, param, 0);
        loader.load();
    }

    void fireImageProjection(int startZ, int endZ, int stepping, int type, String typeName, ProjectionRef ref) {
        startZ = ref.getStartZ();
        endZ = ref.getEndZ();
        this.state = 13;
        StringBuffer buf = new StringBuffer();
        buf.append("Original Image: " + this.getImageName());
        buf.append("\n");
        buf.append("Original Image ID: " + this.getImageID());
        buf.append("\n");
        buf.append("Projection type: " + typeName);
        buf.append("\n");
        buf.append("z-sections: " + (startZ + 1) + "-" + (endZ + 1));
        buf.append("\n");
        int startT = ref.getStartT();
        int endT = ref.getEndT();
        if (startT == endT) {
            buf.append("timepoint: " + (startT + 1));
        } else {
            buf.append("timepoints: " + (startT + 1) + "-" + (endT + 1));
        }
        List<Integer> channels = ref.getChannels();
        ProjectionParam param = new ProjectionParam(this.getPixelsID(), startZ, endZ, stepping, type, startT, endT, channels, ref.getImageName());
        param.setDescription(buf.toString());
        param.setDatasets(ref.getDatasets());
        param.setDatasetParent(this.getGrandParent());
        param.setChannels(this.getActiveChannels());
        ProjectionSaver loader = new ProjectionSaver(this.component, param, 1, ref.isApplySettings());
        loader.load();
    }

    void fireContainersLoading() {
        this.state = 11;
        ContainerLoader loader = new ContainerLoader(this.component, this.getImageID());
        loader.load();
    }

    String getPixelsType() {
        return this.getImage().getDefaultPixels().getPixelType();
    }

    void fireProjectedRndSettingsCreation(List<Integer> indexes, ImageData image) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        RndProxyDef def = rnd.getRndSettingsCopy();
        RenderingSettingsCreator l = new RenderingSettingsCreator(this.component, image, def, indexes);
        l.load();
    }

    void setContext(DataObject parent, DataObject grandParent) {
        this.parent = parent;
        this.grandParent = grandParent;
        if (this.metadataViewer != null) {
            this.metadataViewer.setParentRootObject(parent, grandParent);
        }
        if (this.isHCSImage()) {
            this.fireMeasurementsLoading();
        }
    }

    DataObject getParent() {
        return this.parent;
    }

    DataObject getGrandParent() {
        return this.grandParent;
    }

    void setPlaneInfo(Collection objects) {
        if (this.planeInfos == null) {
            this.planeInfos = new HashMap<Integer, PlaneInfo>();
        } else {
            this.planeInfos.clear();
        }
        for (PlaneInfo object : objects) {
            Integer index;
            if (object == null || (index = this.linearize(object.getTheZ().getValue(), object.getTheC().getValue(), object.getTheT().getValue())) < 0) continue;
            this.planeInfos.put(index, object);
        }
    }

    PlaneInfo getPlane(int z, int c, int t) {
        Integer index = null;
        try {
            index = this.linearize(z, c, t);
            if (index < 0) {
                return null;
            }
            return this.planeInfos.get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    void fireImageLoading() {
        ImageDataLoader loader = new ImageDataLoader(this.component, this.getImageID());
        loader.load();
        this.state = 10;
    }

    void setImageData(ImageData image) {
        this.image = image;
        this.initializeMetadataViewer();
        this.currentPixelsID = image.getDefaultPixels().getId();
        if (this.metadataViewer != null) {
            this.metadataViewer.setParentRootObject(this.parent, this.grandParent);
        }
    }

    boolean isOriginalSettings() {
        return this.isSameSettings(this.originalDef, false);
    }

    boolean isOriginalPlane() {
        if (this.originalDef.getDefaultZ() != this.getDefaultZ()) {
            return false;
        }
        return this.originalDef.getDefaultT() == this.getDefaultT();
    }

    boolean isSameSettings(RndProxyDef def, boolean checkPlane) {
        if (this.metadataViewer == null) {
            return false;
        }
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.isSameSettings(def, checkPlane);
    }

    void setRenderProjected(Object image) {
        this.state = 6;
        this.browser.setRenderProjected(image);
    }

    void setContainers(Collection containers) {
        this.containers = containers;
        this.state = 6;
    }

    Collection getContainers() {
        return this.containers;
    }

    PixelsData getPixelsData() {
        if (this.image == null) {
            return null;
        }
        return this.getImage().getDefaultPixels();
    }

    ProjectionParam getLastProjRef() {
        return this.lastProjRef;
    }

    void setLastProjectionRef(ProjectionParam ref) {
        this.lastProjRef = ref;
    }

    int getLastProjectionTime() {
        return this.lastProjTime;
    }

    void setLastProjectionTime(int time) {
        this.lastProjTime = time;
    }

    double getUnitInMicrons() {
        return this.browser.getUnitInMicrons();
    }

    void loadAllContainers() {
        ContainerLoader loader = new ContainerLoader(this.component);
        loader.load();
    }

    void makeMovie() {
        if (this.metadataViewer == null) {
            return;
        }
        this.metadataViewer.makeMovie((int)this.getUnitInMicrons(), this.getBrowser().getUnitBarColor());
    }

    void setSelectedBin(int bin) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        List<ChannelData> channels = this.getChannelData();
        for (ChannelData channel : channels) {
            int index;
            rnd.setActive(index, (index = channel.getIndex()) == bin);
        }
    }

    void setForLifetime() {
        if (!this.isNumerousChannel()) {
            return;
        }
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        this.setColorModel("greyscale", true);
        List<ChannelData> channels = this.getChannelData();
        for (ChannelData c : channels) {
            int index = c.getIndex();
            rnd.setChannelWindow(index, c.getGlobalMin(), c.getGlobalMax());
            rnd.setActive(index, index == 0);
        }
    }

    int getSelectedBin() {
        List<Integer> active = this.getActiveChannels();
        if (active == null || active.size() != 1) {
            return 0;
        }
        return active.get(0);
    }

    void setSelectedChannel(int index) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return;
        }
        rnd.setSelectedChannel(index);
    }

    boolean isSeparateWindow() {
        return this.separateWindow;
    }

    void setSeparateWindow(boolean separateWindow) {
        this.separateWindow = separateWindow;
    }

    void fireMeasurementsLoading() {
        if (this.parent instanceof WellData) {
            ImageData p = this.getImage();
            MeasurementsLoader loader = new MeasurementsLoader(this.component, (DataObject)p);
            loader.load();
        }
    }

    void setMeasurements(Collection result) {
        this.measurements = result;
    }

    Collection getMeasurements() {
        return this.measurements;
    }

    double setImageAsTexture(TextureData image) {
        this.state = 6;
        this.browser.setRenderedImage(image);
        return this.initZoomFactor();
    }

    void activityOptions(Component source, Point location) {
        if (this.metadataViewer == null) {
            return;
        }
        this.metadataViewer.activityOptions(source, location, 100);
    }

    boolean isMappedImageRGB(List channels) {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd == null) {
            return false;
        }
        return rnd.isMappedImageRGB(channels);
    }

    Map<Integer, Integer> getOverLays() {
        Iterator i = this.measurements.iterator();
        TableResult table = null;
        while (i.hasNext()) {
            Object object = i.next();
            if (!(object instanceof TableResult)) continue;
            table = (TableResult)object;
            this.overlayTableID = table.getTableID();
            break;
        }
        if (table == null) {
            return null;
        }
        Object[][] data = table.getData();
        LinkedHashMap<Integer, Integer> overlays = new LinkedHashMap<Integer, Integer>();
        int index = 0;
        Color c = null;
        Long value = -1L;
        for (int j = 0; j < data.length; ++j) {
            value = (Long)data[j][2];
            if (value != null) {
                overlays.put((Integer)data[j][0], value.intValue());
            } else {
                if (index == 0) {
                    c = Color.red;
                } else if (index == 1) {
                    c = Color.green;
                } else if (index == 2) {
                    c = Color.blue;
                }
                overlays.put((Integer)data[j][0], UIUtilities.convertColor(c));
            }
            if (++index % 3 != 0) continue;
            index = 0;
        }
        return overlays;
    }

    void renderOverlays(Map<Long, Integer> overlays) {
        PlaneDef pDef = new PlaneDef();
        pDef.t = this.getDefaultT();
        pDef.z = this.getDefaultZ();
        pDef.slice = 0;
        this.state = 3;
        OverlaysRenderer loader = new OverlaysRenderer(this.component, this.getPixelsID(), pDef, this.overlayTableID, overlays);
        loader.load();
    }

    double getOriginalRatio() {
        return this.originalRatio;
    }

    Dimension computeSize() {
        if (!this.isBigImage()) {
            this.computedSize = new Dimension(this.getMaxX(), this.getMaxY());
            return this.computedSize;
        }
        this.originalRatio = Math.min(1024.0 / (double)this.getMaxX(), 1024.0 / (double)this.getMaxY());
        this.computedSize = Factory.computeThumbnailSize(1024, 1024, this.getMaxX(), this.getMaxY());
        if (this.computedSize == null) {
            this.computedSize = new Dimension(1024, 1024);
        }
        return this.computedSize;
    }

    void refresh() {
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd != null) {
            rnd.refresh();
        }
    }

    boolean isWritable() {
        boolean b = this.isUserOwner();
        if (b) {
            return b;
        }
        int level = ImViewerAgent.getRegistry().getAdminService().getPermissionLevel();
        switch (level) {
            case 102: 
            case 104: {
                return true;
            }
        }
        return false;
    }

    boolean isUserOwner() {
        long userID = ImViewerAgent.getUserDetails().getId();
        return EditorUtil.isUserOwner(this.getImage(), userID);
    }

    void setRangeAllChannels(boolean absolute) {
        this.metadataViewer.getRenderer().setRangeAllChannels(absolute);
    }

    boolean isHCSImage() {
        return this.image instanceof WellSampleData;
    }
}

