/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.GLImageCanvas;
import org.openmicroscopy.shoola.agents.imviewer.browser.GridImage;
import org.openmicroscopy.shoola.agents.imviewer.browser.SplitImage;

class GridCanvas
extends GLImageCanvas {
    private static final float HGAP = 0.5f;
    private static final float HGAP_HIGH = 0.33f;
    private static final float ZOOM = 0.25f;

    private void paintGrid(GL gl) {
        List<GridImage> list = this.model.getGridImages();
        Iterator<GridImage> i = list.iterator();
        TextureCoords coords = new TextureCoords(0.0f, 0.0f, 1.0f, 1.0f);
        float hGap = 0.5f;
        float vGap = 1.0f / (float)this.model.getGridRow();
        if (this.model.getMaxC() > 3) {
            hGap = 0.33f;
        }
        float xStart = 0.0f;
        float yStart = 0.0f;
        float xEnd = hGap;
        float yEnd = vGap;
        int col = 0;
        int columns = this.model.getGridColumn();
        while (i.hasNext()) {
            TextureData data;
            GridImage img = i.next();
            if (img.isActive() && (data = img.getTextureData()) != null) {
                if (this.texture == null) {
                    this.texture = TextureIO.newTexture((TextureData)data);
                } else {
                    this.texture.updateImage(data);
                }
                gl.glBegin(7);
                gl.glScaled(0.25, -1.0, 1.0);
                gl.glTexCoord2f(coords.left(), coords.bottom());
                gl.glVertex3f(xStart, yStart, 0.0f);
                gl.glTexCoord2f(coords.right(), coords.bottom());
                gl.glVertex3d((double)xEnd, (double)yStart, 0.0);
                gl.glTexCoord2f(coords.right(), coords.top());
                gl.glVertex3f(xEnd, yEnd, 0.0f);
                gl.glTexCoord2f(coords.left(), coords.top());
                gl.glVertex3f(xStart, yEnd, 0.0f);
                gl.glEnd();
            }
            if (++col == columns) {
                col = 0;
                xStart = 0.0f;
                xEnd = hGap;
                yStart += vGap;
                yEnd += vGap;
                continue;
            }
            xStart = hGap;
            xEnd += hGap;
        }
    }

    private void paintText(GL gl) {
        int columns = this.model.getGridColumn();
        int col = 0;
        Color c = this.model.getUnitBarColor();
        gl.glColor3f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
        List<GridImage> list = this.model.getGridImages();
        Iterator<GridImage> i = list.iterator();
        float start = 0.01f;
        float y = 0.03f;
        float x = start;
        float hGap = 0.5f;
        float vGap = 1.0f / (float)this.model.getGridRow();
        if (this.model.getMaxC() > 3) {
            hGap = 0.33f;
        }
        while (i.hasNext()) {
            GridImage img = i.next();
            if (img.isActive()) {
                gl.glRasterPos2f(x, y);
                this.glut.glutBitmapString(6, img.getLabel());
            }
            if (++col == columns) {
                col = 0;
                x = start;
                y += vGap;
                continue;
            }
            x += hGap;
        }
    }

    private void paintGridAsRGB(GL gl) {
        List<GridImage> list = this.model.getGridImages();
        Iterator<GridImage> i = list.iterator();
        TextureCoords coords = new TextureCoords(0.0f, 0.0f, 1.0f, 1.0f);
        float hGap = 0.5f;
        float vGap = 1.0f / (float)this.model.getGridRow();
        if (this.model.getMaxC() > 3) {
            hGap = 0.33f;
        }
        float xStart = 0.0f;
        float yStart = 0.0f;
        float xEnd = hGap;
        float yEnd = vGap;
        int col = 0;
        int columns = this.model.getGridColumn();
        while (i.hasNext()) {
            GridImage img = i.next();
            if (img.isActive()) {
                boolean[] rgb = img.getRGB();
                gl.glColorMask(rgb[0], rgb[1], rgb[2], true);
                gl.glBegin(7);
                gl.glScaled(0.25, -1.0, 1.0);
                gl.glTexCoord2f(coords.left(), coords.bottom());
                gl.glVertex3f(xStart, yStart, 0.0f);
                gl.glTexCoord2f(coords.right(), coords.bottom());
                gl.glVertex3d((double)xEnd, (double)yStart, 0.0);
                gl.glTexCoord2f(coords.right(), coords.top());
                gl.glVertex3f(xEnd, yEnd, 0.0f);
                gl.glTexCoord2f(coords.left(), coords.top());
                gl.glVertex3f(xStart, yEnd, 0.0f);
                gl.glEnd();
            }
            if (++col == columns) {
                col = 0;
                xStart = 0.0f;
                xEnd = hGap;
                yStart += vGap;
                yEnd += vGap;
                continue;
            }
            xStart = hGap;
            xEnd += hGap;
        }
    }

    GridCanvas(BrowserModel model, BrowserUI view) {
        super(model, view);
    }

    BufferedImage getGridImage() {
        return null;
    }

    Point isOnImageInGrid(Rectangle r) {
        Rectangle imageRectangle;
        BufferedImage image;
        List images = this.model.getSplitImages();
        if (images == null) {
            return null;
        }
        SplitImage combined = null;
        int n = images.size();
        if (n <= 3) {
            n = 4;
        }
        if (n > 4 && n % 2 != 0) {
            combined = (SplitImage)images.get(images.size() - 1);
            images.remove(images.size() - 1);
        }
        n = (int)Math.floor(Math.sqrt(n));
        Iterator channels = images.iterator();
        int x = 0;
        int y = 0;
        BufferedImage original = this.model.getCombinedImage();
        int w = original.getWidth();
        int h = original.getHeight();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n && channels.hasNext(); ++j) {
                SplitImage channel = (SplitImage)channels.next();
                image = channel.getImage();
                x = j * (w + 0);
                if (image == null || !(imageRectangle = new Rectangle(x, y, w, h)).contains(r)) continue;
                return new Point(r.x - imageRectangle.x, r.y - imageRectangle.y);
            }
            x = 0;
            y = (i + 1) * (h + 0);
        }
        if (combined != null) {
            image = combined.getImage();
            y = 0;
            x = n * (w + 0);
            if (image != null && (imageRectangle = new Rectangle(x, y, w, h)).contains(r)) {
                return new Point(r.x - imageRectangle.x, r.y - imageRectangle.y);
            }
            return null;
        }
        return null;
    }

    public void display(GLAutoDrawable drawable) {
        TextureData data = this.model.getRenderedImageAsTexture();
        GL gl = drawable.getGL();
        gl.glClear(16640);
        if (data == null) {
            return;
        }
        if (this.model.isTextVisible() && this.model.getGridRatio() > 0.25) {
            this.paintText(gl);
        }
        gl.glTexEnvi(8960, 8704, 7681);
        if (this.texture == null) {
            this.texture = TextureIO.newTexture((TextureData)data);
        } else {
            this.texture.updateImage(data);
        }
        this.texture.enable();
        this.texture.bind();
        this.paintGrid(gl);
        float vGap = 1.0f / (float)this.model.getGridRow();
        float xStart = 0.5f;
        float yStart = 0.0f;
        float xEnd = 1.0f;
        float yEnd = vGap;
        switch (this.model.getMaxC()) {
            case 2: {
                xStart = 0.0f;
                xEnd = 0.5f;
                yEnd += vGap;
                yStart += vGap;
                break;
            }
            case 3: {
                yStart = vGap;
                yEnd += vGap;
                break;
            }
            default: {
                xStart = 0.66f;
                xEnd = 1.0f;
            }
        }
        if (this.texture == null) {
            this.texture = TextureIO.newTexture((TextureData)data);
        } else {
            this.texture.updateImage(data);
        }
        TextureCoords coords = new TextureCoords(0.0f, 0.0f, 1.0f, 1.0f);
        gl.glColorMask(true, true, true, true);
        gl.glBegin(7);
        gl.glScaled(0.25, -1.0, 1.0);
        gl.glTexCoord2f(coords.left(), coords.bottom());
        gl.glVertex3f(xStart, yStart, 0.0f);
        gl.glTexCoord2f(coords.right(), coords.bottom());
        gl.glVertex3d((double)xEnd, (double)yStart, 0.0);
        gl.glTexCoord2f(coords.right(), coords.top());
        gl.glVertex3f(xEnd, yEnd, 0.0f);
        gl.glTexCoord2f(coords.left(), coords.top());
        gl.glVertex3f(xStart, yEnd, 0.0f);
        gl.glEnd();
        this.saveDisplayedImage(gl);
        this.texture.disable();
        gl.glFlush();
    }
}

