/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.ImageCanvas;
import org.openmicroscopy.shoola.agents.imviewer.browser.SplitImage;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;

class GridBICanvas
extends ImageCanvas {
    private void paintImage(Graphics2D g2D, int w, int h, boolean bar) {
        String name;
        int textWidth;
        BufferedImage image;
        int i;
        List images = this.model.getSplitImages();
        if (images == null) {
            return;
        }
        SplitImage combined = null;
        g2D.setColor(this.model.getBackgroundColor());
        Dimension d = this.getSize();
        g2D.fillRect(0, 0, d.width, d.height);
        int row = this.model.getGridRow();
        int colum = this.model.getGridColumn();
        int n = this.model.getMaxC();
        if (n == 1) {
            row = 1;
        } else if (n == 3 || n == 2) {
            row = 2;
        } else if (n >= 4) {
            combined = (SplitImage)images.get(images.size() - 1);
            images.remove(images.size() - 1);
        }
        Iterator channels = images.iterator();
        String v = this.model.getUnitBarValue();
        int s = (int)(this.model.getGridBarSize() * this.model.getGridRatio());
        Color c = this.model.getUnitBarColor();
        Font font = this.getFont();
        FontMetrics fm = this.getFontMetrics(font);
        boolean text = this.model.isTextVisible();
        g2D.setColor(BACKGROUND);
        int widthGrid = w * colum;
        int heightGrid = h * row;
        int x = 0;
        int y = 0;
        for (i = 0; i <= row; ++i) {
            g2D.drawLine(x, y, x + widthGrid, y);
            y = (i + 1) * h - 1;
        }
        x = 0;
        y = 0;
        for (i = 0; i <= colum; ++i) {
            g2D.drawLine(x, y, x, y + heightGrid);
            x = (i + 1) * w - 1;
        }
        x = 0;
        y = 0;
        for (i = 0; i < row; ++i) {
            for (int j = 0; j < colum; ++j) {
                if (!channels.hasNext()) continue;
                SplitImage channel = (SplitImage)channels.next();
                image = channel.getImage();
                x = j * (w + 0);
                if (image != null) {
                    g2D.drawImage(image, null, x, y);
                    if (text && (textWidth = fm.stringWidth(name = channel.getName()) + 4) < w) {
                        g2D.setColor(this.getBackground());
                        g2D.drawString(name, x + 2, y + this.height);
                    }
                    if (!bar || v == null || (textWidth = fm.stringWidth(v) + 4) >= w / 2) continue;
                    ImagePaintingFactory.paintScaleBar(g2D, x + w - s - 5, y + h - 5, s, v, c);
                    continue;
                }
                name = channel.getName();
                textWidth = fm.stringWidth(name) + 4;
                if (textWidth >= w || !text) continue;
                g2D.drawString(name, x + 2, y + this.height);
            }
            x = 0;
            y = (i + 1) * (h + 0);
        }
        if (combined != null) {
            image = combined.getImage();
            y = 0;
            x = colum * (w + 0);
            if (image != null) {
                g2D.drawImage(image, null, x, y);
                if (text && (textWidth = fm.stringWidth(name = combined.getName()) + 4) < w) {
                    g2D.setColor(this.getBackground());
                    g2D.drawString(name, x + 2, y + this.height);
                }
                if (bar && v != null && (textWidth = fm.stringWidth(v) + 4) < w / 2) {
                    ImagePaintingFactory.paintScaleBar(g2D, x + w - s - 5, y + h - 5, s, v, c);
                }
            } else {
                name = combined.getName();
                textWidth = fm.stringWidth(name) + 4;
                if (textWidth < w && text) {
                    g2D.drawString(name, x + 2, y + this.height);
                }
            }
        }
    }

    GridBICanvas(BrowserModel model, BrowserUI view) {
        super(model, view);
    }

    Point isOnImageInGrid(Rectangle r) {
        Rectangle imageRectangle;
        BufferedImage image;
        List images = this.model.getSplitImages();
        if (images == null) {
            return null;
        }
        SplitImage combined = null;
        int n = images.size();
        if (n <= 3) {
            n = 4;
        }
        if (n > 4 && n % 2 != 0) {
            combined = (SplitImage)images.get(images.size() - 1);
            images.remove(images.size() - 1);
        }
        n = (int)Math.floor(Math.sqrt(n));
        Iterator channels = images.iterator();
        int x = 0;
        int y = 0;
        BufferedImage original = this.model.getCombinedImage();
        int w = original.getWidth();
        int h = original.getHeight();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n && channels.hasNext(); ++j) {
                SplitImage channel = (SplitImage)channels.next();
                image = channel.getImage();
                x = j * (w + 0);
                if (image == null || !(imageRectangle = new Rectangle(x, y, w, h)).contains(r)) continue;
                return new Point(r.x - imageRectangle.x, r.y - imageRectangle.y);
            }
            x = 0;
            y = (i + 1) * (h + 0);
        }
        if (combined != null) {
            image = combined.getImage();
            y = 0;
            x = n * (w + 0);
            if (image != null && (imageRectangle = new Rectangle(x, y, w, h)).contains(r)) {
                return new Point(r.x - imageRectangle.x, r.y - imageRectangle.y);
            }
            return null;
        }
        return null;
    }

    BufferedImage getGridImage() {
        BufferedImage original = this.model.getCombinedImage();
        int w = original.getWidth();
        int h = original.getHeight();
        Dimension d = this.getSize();
        BufferedImage gridImage = new BufferedImage(d.width, d.height, 1);
        Graphics2D g2D = (Graphics2D)gridImage.getGraphics();
        ImagePaintingFactory.setGraphicRenderingSettings(g2D);
        this.paintImage(g2D, w, h, this.model.isUnitBar());
        return gridImage;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        ImagePaintingFactory.setGraphicRenderingSettings(g2D);
        BufferedImage original = this.model.getCombinedImage();
        if (original == null) {
            return;
        }
        this.paintImage(g2D, original.getWidth(), original.getHeight(), this.model.isUnitBar());
    }
}

