/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.uiComponents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.model.tables.IMutableTableModel;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;

public class TableEditUI
extends JPanel
implements ActionListener {
    private JTable table;
    private TableModel tableModel;
    private JButton addRowButton;
    private JButton removeRowsButton;
    public static final String ADD_ROW = "addRow";
    public static final String REMOVE_ROW = "removeRow";
    public static final String SIZE_CHANGED = "sizeChanged";

    private void initialise() {
        if (this.table == null) {
            this.table = new JTable(this.tableModel);
        }
        IconManager iM = IconManager.getInstance();
        Icon addRowIcon = iM.getIcon(25);
        Icon clearRowIcon = iM.getIcon(26);
        this.addRowButton = new CustomButton(addRowIcon);
        this.addRowButton.setToolTipText("Add a new row");
        this.addRowButton.setActionCommand(ADD_ROW);
        this.addRowButton.addActionListener(this);
        this.removeRowsButton = new CustomButton(clearRowIcon);
        this.removeRowsButton.setToolTipText("Remove the highlighted rows");
        this.removeRowsButton.setActionCommand(REMOVE_ROW);
        this.removeRowsButton.addActionListener(this);
        if (!(this.tableModel instanceof IMutableTableModel)) {
            this.addRowButton.setEnabled(false);
            this.removeRowsButton.setEnabled(false);
        }
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(null);
        JScrollPane tableScroller = new JScrollPane(this.table, 20, 30);
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(this.addRowButton);
        verticalBox.add(this.removeRowsButton);
        this.add((Component)verticalBox, "West");
        this.add((Component)tableScroller, "Center");
        this.refreshViewportSize();
    }

    private void refreshViewportSize() {
        int rows = this.table.getRowCount();
        int cols = this.table.getColumnCount();
        int height = rows * this.table.getRowHeight();
        int width = cols * 120;
        this.table.setPreferredScrollableViewportSize(new Dimension(width, height));
    }

    private void refreshEditingSize() {
        this.firePropertyChange(SIZE_CHANGED, null, null);
    }

    public TableEditUI(TableModel tableModel) {
        this.tableModel = tableModel;
        this.initialise();
        this.buildUI();
    }

    public TableEditUI(JTable table) {
        this.table = table;
        this.tableModel = table.getModel();
        this.initialise();
        this.buildUI();
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int width = (int)size.getWidth();
        int height = (this.table.getRowCount() + 2) * this.table.getRowHeight();
        size.setSize(width, height);
        return size;
    }

    public void actionPerformed(ActionEvent e) {
        String com = e.getActionCommand();
        if (ADD_ROW.equals(com)) {
            if (this.tableModel instanceof IMutableTableModel) {
                IMutableTableModel mtm = (IMutableTableModel)this.tableModel;
                int selected = this.table.getSelectedColumnCount();
                if (selected == 0) {
                    mtm.addEmptyRow();
                } else {
                    int[] rows = this.table.getSelectedRows();
                    int lastSelectedIndex = rows[selected - 1];
                    mtm.addEmptyRow(lastSelectedIndex + 1);
                }
                this.refreshEditingSize();
            }
        } else if (REMOVE_ROW.equals(com) && this.tableModel instanceof IMutableTableModel) {
            IMutableTableModel mtm = (IMutableTableModel)this.tableModel;
            int delete = JOptionPane.showConfirmDialog(this.table, "Are you sure you want to delete rows?\nThis cannot be undone.", "Really delete rows?", 2);
            if (delete == 0) {
                int[] highlightedRows = this.table.getSelectedRows();
                mtm.removeRows(highlightedRows);
                this.refreshEditingSize();
            }
        }
        this.firePropertyChange("sizeChangedPropery", null, this.getPreferredSize());
    }

    public JTable getTable() {
        return this.table;
    }
}

