/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.uiComponents;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;

public class PopupMenuButton
extends CustomButton {
    private JPopupMenu popupMenu;

    public PopupMenuButton(String toolTipText, Icon icon) {
        this(toolTipText, icon, null);
    }

    public PopupMenuButton(String toolTipText, Icon icon, Action[] actions) {
        super(icon);
        this.setToolTipText(toolTipText);
        this.popupMenu = new JPopupMenu();
        if (actions != null) {
            for (int i = 0; i < actions.length; ++i) {
                this.addAction(actions[i]);
            }
        }
        this.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.getComponent().isVisible()) {
                    try {
                        PopupMenuButton.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public void addAction(Action newAction) {
        JMenuItem menuItem = new JMenuItem(newAction);
        this.popupMenu.add(menuItem);
    }
}

