/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.undo.AbstractUndoableEdit;
import org.openmicroscopy.shoola.agents.editor.model.ExperimentInfo;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.ProtocolRootField;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.TreeEdit;

public class AddExpInfoEdit
extends AbstractUndoableEdit
implements TreeEdit {
    private ProtocolRootField field;
    private IAttributes expInfo;
    private IAttributes oldExpInfo;
    private DefaultMutableTreeNode node;
    DefaultTreeModel treeModel;

    public AddExpInfoEdit(JTree tree) {
        this.setTree(tree);
    }

    public void doEdit() {
        if (this.treeModel == null) {
            return;
        }
        this.node = (DefaultMutableTreeNode)this.treeModel.getRoot();
        Object ob = this.node.getUserObject();
        if (!(ob instanceof ProtocolRootField)) {
            return;
        }
        this.field = (ProtocolRootField)ob;
        this.oldExpInfo = this.field.getExpInfo();
        this.expInfo = new ExperimentInfo();
        this.redo();
    }

    public void undo() {
        this.field.setExpInfo(this.oldExpInfo);
        this.notifyNodeChanged();
    }

    public void redo() {
        this.field.setExpInfo(this.expInfo);
        this.notifyNodeChanged();
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    public String getPresentationName() {
        return "Add Experiment Info";
    }

    private void notifyNodeChanged() {
        if (this.treeModel != null) {
            this.treeModel.nodeChanged(this.node);
        }
    }

    public void setTree(JTree tree) {
        if (tree != null) {
            this.treeModel = (DefaultTreeModel)tree.getModel();
        }
    }
}

