/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.tables;

import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.params.FieldParamsFactory;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.model.tables.IMutableTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldTableModelAdaptor
extends AbstractTableModel
implements IMutableTableModel {
    private IField field;

    public FieldTableModelAdaptor(IField field) {
        this.field = field;
    }

    @Override
    public int getColumnCount() {
        return this.field.getAtomicParams().size();
    }

    @Override
    public int getRowCount() {
        List<IParam> params = this.field.getAtomicParams();
        int maxRows = 0;
        for (IParam param : params) {
            int rows = param.getValueCount();
            maxRows = Math.max(maxRows, rows);
        }
        return maxRows;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List<IParam> params = this.field.getAtomicParams();
        if (columnIndex > params.size()) {
            return null;
        }
        IParam param = params.get(columnIndex);
        if (param.getValueCount() - 1 < rowIndex) {
            return null;
        }
        return param.getValueAt(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        List<IParam> params = this.field.getAtomicParams();
        if (columnIndex > params.size()) {
            return;
        }
        params.get(columnIndex).setValueAt(rowIndex, aValue);
    }

    @Override
    public String getColumnName(int col) {
        List<IParam> params = this.field.getAtomicParams();
        if (col > params.size()) {
            return "";
        }
        IParam p = params.get(col);
        String name = p.getAttribute("paramName");
        String units = p.getAttribute("paramUnits");
        if (units != null) {
            name = (name == null ? "" : name + " ") + "(" + units + ")";
        }
        if (name == null) {
            name = params.get(col).getAttribute("paramType");
            name = FieldParamsFactory.getTypeForDisplay(name);
        }
        return name == null ? "" : name;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public Class<? extends Object> getColumnClass(int col) {
        Object obj;
        List<IParam> params = this.field.getAtomicParams();
        if (col > params.size()) {
            return Object.class;
        }
        if (params.get(col).getValueCount() > 0 && (obj = params.get(col).getValueAt(0)) != null) {
            return obj.getClass();
        }
        return Object.class;
    }

    @Override
    public void addEmptyRow() {
        int rowCount = this.getRowCount();
        this.addEmptyRow(rowCount);
    }

    @Override
    public void addEmptyRow(int addAtThisRow) {
        List<IParam> params = this.field.getAtomicParams();
        for (IParam param : params) {
            param.insertValue(addAtThisRow, "");
        }
        this.fireTableRowsInserted(addAtThisRow, addAtThisRow);
    }

    @Override
    public void removeRows(int[] rowIndecies) {
        List<IParam> params = this.field.getAtomicParams();
        for (IParam param : params) {
            for (int i = rowIndecies.length - 1; i > -1; --i) {
                int rowToRemove = rowIndecies[i];
                param.removeValueAt(rowToRemove);
                this.fireTableRowsDeleted(rowToRemove, rowToRemove);
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }
}

