/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.model.Field;
import org.openmicroscopy.shoola.agents.editor.model.FieldNode;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeModelMethods {
    public static void insertNodesInto(DefaultTreeModel treeModel, List<MutableTreeNode> nodes, MutableTreeNode parent, int index) {
        if (index > parent.getChildCount()) {
            index = parent.getChildCount();
        }
        for (MutableTreeNode node : nodes) {
            treeModel.insertNodeInto(node, parent, index);
            ++index;
        }
    }

    public static void removeNodesFromParent(DefaultTreeModel treeModel, List<MutableTreeNode> nodes) {
        for (MutableTreeNode node : nodes) {
            treeModel.removeNodeFromParent(node);
        }
    }

    public static void selectNodes(List<MutableTreeNode> nodes, JTree tree) {
        if (tree == null) {
            return;
        }
        TreePath[] paths = new TreePath[nodes.size()];
        int index = 0;
        for (MutableTreeNode node : nodes) {
            if (!(node instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode dnode = (DefaultMutableTreeNode)node;
            paths[index++] = new TreePath(dnode.getPath());
        }
        tree.setSelectionPaths(paths);
        if (paths.length > 0) {
            tree.scrollPathToVisible(paths[0]);
        }
    }

    public static void selectDNodes(List<DefaultMutableTreeNode> nodes, JTree tree) {
        ArrayList<MutableTreeNode> mtNodes = new ArrayList<MutableTreeNode>();
        for (DefaultMutableTreeNode node : nodes) {
            mtNodes.add(node);
        }
        TreeModelMethods.selectNodes(mtNodes, tree);
    }

    public static void selectNode(TreeNode node, JTree tree) {
        ArrayList<MutableTreeNode> nodes = new ArrayList<MutableTreeNode>();
        if (node instanceof MutableTreeNode) {
            nodes.add((MutableTreeNode)node);
            TreeModelMethods.selectNodes(nodes, tree);
        }
    }

    public static DefaultMutableTreeNode duplicateNode(DefaultMutableTreeNode oldNode) {
        Field oldField = (Field)oldNode.getUserObject();
        Field newField = (Field)oldField.clone();
        FieldNode newNode = new FieldNode(newField);
        for (int i = 0; i < oldNode.getChildCount(); ++i) {
            DefaultMutableTreeNode oldChild = (DefaultMutableTreeNode)oldNode.getChildAt(i);
            DefaultMutableTreeNode newChild = TreeModelMethods.duplicateNode(oldChild);
            newNode.add(newChild);
        }
        return newNode;
    }

    public static void indentNodesRight(List<DefaultMutableTreeNode> nodes, DefaultTreeModel treeModel) {
        if (nodes == null) {
            return;
        }
        if (nodes.isEmpty()) {
            return;
        }
        DefaultMutableTreeNode firstNode = nodes.get(0);
        DefaultMutableTreeNode previousSibling = firstNode.getPreviousSibling();
        if (previousSibling == null) {
            return;
        }
        for (DefaultMutableTreeNode node : nodes) {
            previousSibling.add(node);
        }
        treeModel.nodeStructureChanged(previousSibling.getParent());
    }

    public static void moveFieldsUp(List<DefaultMutableTreeNode> nodes, DefaultTreeModel treeModel) {
        if (nodes == null) {
            return;
        }
        if (nodes.isEmpty()) {
            return;
        }
        int nodeCount = nodes.size();
        DefaultMutableTreeNode firstNode = nodes.get(0);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)firstNode.getParent();
        int firstNodeIndex = parent.getIndex(firstNode);
        DefaultMutableTreeNode previousSibling = firstNode.getPreviousSibling();
        if (previousSibling == null) {
            return;
        }
        parent.remove(previousSibling);
        int indexToInsert = firstNodeIndex + nodeCount - 1;
        if (indexToInsert <= parent.getChildCount()) {
            parent.insert(previousSibling, indexToInsert);
        }
        treeModel.nodeStructureChanged(parent);
    }

    public static void moveFieldsDown(List<DefaultMutableTreeNode> nodes, DefaultTreeModel treeModel) {
        if (nodes == null) {
            return;
        }
        if (nodes.isEmpty()) {
            return;
        }
        int nodeCount = nodes.size();
        DefaultMutableTreeNode lastNode = nodes.get(nodes.size() - 1);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)lastNode.getParent();
        int lastNodeIndex = parent.getIndex(lastNode);
        DefaultMutableTreeNode nextSibling = lastNode.getNextSibling();
        if (nextSibling == null) {
            return;
        }
        parent.remove(nextSibling);
        int indexToInsert = lastNodeIndex - nodeCount + 1;
        if (indexToInsert >= 0) {
            parent.insert(nextSibling, indexToInsert);
        }
        treeModel.nodeStructureChanged(parent);
    }

    public static void indentNodesLeft(List<DefaultMutableTreeNode> nodes, DefaultTreeModel treeModel) {
        if (nodes == null) {
            return;
        }
        if (nodes.isEmpty()) {
            return;
        }
        DefaultMutableTreeNode firstNode = nodes.get(0);
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)firstNode.getParent();
        if (parentNode == null) {
            return;
        }
        DefaultMutableTreeNode grandParentNode = (DefaultMutableTreeNode)parentNode.getParent();
        if (grandParentNode == null) {
            return;
        }
        DefaultMutableTreeNode lastNode = nodes.get(nodes.size() - 1);
        DefaultMutableTreeNode lastNodeSibling = lastNode.getNextSibling();
        while (lastNodeSibling != null) {
            lastNode.add(lastNodeSibling);
            lastNodeSibling = lastNode.getNextSibling();
        }
        for (int n = nodes.size() - 1; n > -1; --n) {
            DefaultMutableTreeNode node = nodes.get(n);
            TreeModelMethods.indentNodeLeft(node);
        }
        treeModel.nodeStructureChanged(grandParentNode);
    }

    public static void indentNodeLeft(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        if (parentNode == null) {
            return;
        }
        DefaultMutableTreeNode grandParentNode = (DefaultMutableTreeNode)parentNode.getParent();
        if (grandParentNode == null) {
            return;
        }
        int indexOfParent = grandParentNode.getIndex(parentNode);
        grandParentNode.insert(node, indexOfParent + 1);
    }

    public static String getAttributeFromAncestor(String attributeName, TreeNode node) {
        for (DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent(); parent != null; parent = (DefaultMutableTreeNode)parent.getParent()) {
            IAttributes field;
            String value;
            Object userObject = parent.getUserObject();
            if (!(userObject instanceof IAttributes) || (value = (field = (IAttributes)userObject).getAttribute(attributeName)) == null) continue;
            return value;
        }
        return null;
    }

    public static String getNodeName(DefaultMutableTreeNode node) {
        if (node.isRoot()) {
            return "Protocol Title";
        }
        String steps = "Step ";
        TreeNode[] pathNodes = node.getPath();
        for (int i = 0; i < pathNodes.length - 1; ++i) {
            DefaultMutableTreeNode pathNode = (DefaultMutableTreeNode)pathNodes[i];
            int index = pathNode.getIndex(pathNodes[i + 1]) + 1;
            steps = steps + (i > 0 ? "." : "") + index;
        }
        return steps;
    }
}

