/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomComboBox;

public class EnumEditor
extends AbstractParamEditor
implements ActionListener {
    private String[] ddOptions;
    private JComboBox comboBox;
    private String attributeName;
    public static final int NULL_INDEX = 0;
    public static final String NO_OPTION_CHOSEN = " ";

    private void setDropDownOptions(String options) {
        this.comboBox.removeAllItems();
        if (options != null) {
            int i;
            String dropDownOptions = options;
            String[] optionsSplit = dropDownOptions.split(",");
            this.ddOptions = new String[optionsSplit.length + 1];
            this.ddOptions[0] = NO_OPTION_CHOSEN;
            for (i = 1; i < this.ddOptions.length; ++i) {
                this.ddOptions[i] = optionsSplit[i - 1].trim();
            }
            for (i = 0; i < this.ddOptions.length; ++i) {
                this.comboBox.addItem(this.ddOptions[i]);
            }
            String value = this.getParameter().getAttribute(this.attributeName);
            if (value != null) {
                for (int i2 = 1; i2 < this.ddOptions.length; ++i2) {
                    if (!value.equals(this.ddOptions[i2])) continue;
                    this.comboBox.setSelectedIndex(i2);
                }
            } else {
                this.comboBox.setSelectedIndex(0);
            }
        }
    }

    private void initialise() {
        this.comboBox = new CustomComboBox(150);
        String dropDownOptions = this.getParameter().getAttribute("enumOptions");
        this.setDropDownOptions(dropDownOptions);
        this.comboBox.addActionListener(this);
    }

    private void buildUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(null);
        this.add(this.comboBox);
    }

    public EnumEditor(IAttributes param) {
        super(param);
        this.attributeName = "value";
        this.initialise();
        this.buildUI();
    }

    public EnumEditor(IAttributes param, String attributeName) {
        super(param);
        this.attributeName = attributeName;
        this.initialise();
        this.buildUI();
    }

    public void actionPerformed(ActionEvent e) {
        Object ob = this.comboBox.getSelectedItem();
        if (ob == null) {
            return;
        }
        String newValue = this.comboBox.getSelectedItem().toString();
        if (this.comboBox.getSelectedIndex() == 0) {
            newValue = null;
        }
        this.attributeEdited(this.attributeName, newValue);
    }

    public String getEditDisplayName() {
        return "Edit Dropdown Option";
    }
}

