/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.AttributeEditNoLabel;
import org.openmicroscopy.shoola.agents.editor.model.DataReference;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;
import org.openmicroscopy.shoola.agents.editor.uiComponents.ImagePreview;
import org.openmicroscopy.shoola.agents.editor.uiComponents.PopupMenuButton;
import org.openmicroscopy.shoola.util.ui.BrowserLauncher;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

public class DataRefEditor
extends AbstractParamEditor
implements PropertyChangeListener,
ActionListener {
    public static final String DATA_REF_DELETED = "dataRefDeleted";
    public static final String DELETE_DATA_REF = "deleteDataRef";
    public static final String GO_TO_LINK = "goToLink";
    private PropertyChangeListener parent;
    private String ref;
    private JButton linkButton;
    private JButton getLinkButton;
    private Icon wwwIcon;
    private Icon linkLocalIcon;
    private JPanel imagePreview;

    private void initialise() {
        IconManager imF = IconManager.getInstance();
        Icon chooseLinkIcon = imF.getIcon(24);
        this.wwwIcon = imF.getIcon(15);
        this.linkLocalIcon = imF.getIcon(19);
        IAttributes dataRef = this.getParameter();
        this.ref = dataRef.getAttribute("reference");
        String linkText = this.ref == null ? "No link set" : this.ref;
        this.linkButton = new CustomButton(linkText);
        this.linkButton.setActionCommand(GO_TO_LINK);
        this.linkButton.setCursor(new Cursor(12));
        this.linkButton.setForeground(Color.BLUE);
        this.linkButton.addActionListener(this);
        String desc = dataRef.getAttribute("description");
        String size = dataRef.getAttribute("size");
        String lastM = dataRef.getAttribute("modification-time");
        String mime = dataRef.getAttribute("mime-type");
        String creat = dataRef.getAttribute("creation-time");
        String toolTip = "<html>" + this.ref + "<br>" + "Description: " + (desc == null ? "" : desc) + "<br>" + "Size: " + (size == null ? "" : size) + "<br>" + "Last Modified: " + (lastM == null ? "" : this.formatUTC(lastM)) + "<br>" + "Created: " + (creat == null ? "" : this.formatUTC(creat)) + "<br>" + "Mime type: " + (mime == null ? "" : mime) + "</html>";
        this.linkButton.setToolTipText(toolTip);
        Action[] getLinkActions = new Action[]{new GetURLAction(), new GetLinkPathAction()};
        this.getLinkButton = new PopupMenuButton("Choose a link to a URL or local file", chooseLinkIcon, getLinkActions);
        if (DataReference.showImage(this.ref)) {
            this.imagePreview = new ImagePreview(this.ref);
        }
    }

    private String formatUTC(String utcMillis) {
        SimpleDateFormat fmt = new SimpleDateFormat("d MMM, yyyy");
        if (utcMillis == null) {
            return "";
        }
        long millis = new Long(utcMillis);
        Date date = new Date(millis);
        return fmt.format(date);
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        MatteBorder lineBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, UIUtilities.LIGHT_GREY);
        this.setBorder(lineBorder);
        EmptyBorder eb = new EmptyBorder(3, 4, 3, 4);
        AttributeEditNoLabel nameEditor = new AttributeEditNoLabel(this.getParameter(), "name", "Data Link Name");
        nameEditor.addPropertyChangeListener("valueChangedProperty", this.parent);
        nameEditor.setBorder(eb);
        JToolBar rightToolBar = new JToolBar();
        rightToolBar.setBackground(null);
        rightToolBar.setFloatable(false);
        MatteBorder bottomLeft = BorderFactory.createMatteBorder(0, 1, 1, 0, UIUtilities.LIGHT_GREY);
        rightToolBar.setBorder(bottomLeft);
        IconManager iM = IconManager.getInstance();
        Icon delete = iM.getIcon(84);
        CustomButton deleteButton = new CustomButton(delete);
        deleteButton.setActionCommand(DELETE_DATA_REF);
        deleteButton.addActionListener(this);
        deleteButton.setToolTipText("Delete this data reference");
        rightToolBar.add(deleteButton);
        Box titleToolBar = Box.createHorizontalBox();
        nameEditor.setAlignmentY(0.0f);
        titleToolBar.add(nameEditor);
        rightToolBar.setAlignmentY(0.0f);
        titleToolBar.add(rightToolBar);
        this.add((Component)titleToolBar, "North");
        Box buttonsBox = Box.createHorizontalBox();
        this.getLinkButton.setBorder(eb);
        buttonsBox.add(this.getLinkButton);
        buttonsBox.add(this.linkButton);
        this.add((Component)buttonsBox, "West");
        if (this.imagePreview != null) {
            this.imagePreview.setBorder(eb);
            this.add((Component)this.imagePreview, "South");
        }
    }

    private void getAndSaveLink() {
        FileChooser chooser = new FileChooser(null, 0, "Open File", "Choose a file to open in the Editor");
        chooser.addPropertyChangeListener("approveSelection", this);
        UIUtilities.centerAndShow(chooser);
    }

    public DataRefEditor(IAttributes param, PropertyChangeListener parent) {
        super(param);
        this.parent = parent;
        this.initialise();
        this.buildUI();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("approveSelection".equals(name)) {
            File f = (File)evt.getNewValue();
            HashMap<String, String> edits = new HashMap<String, String>();
            edits.put("reference", f.getAbsolutePath());
            edits.put("modification-time", f.lastModified() + "");
            edits.put("mime-type", null);
            edits.put("size", null);
            edits.put("creation-time", null);
            this.attributeEdited("Data Link", edits);
        }
    }

    public String getEditDisplayName() {
        return "Edit Link";
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (DELETE_DATA_REF.equals(cmd)) {
            this.firePropertyChange(DATA_REF_DELETED, false, true);
        } else if (GO_TO_LINK.equals(cmd) && this.ref != null) {
            try {
                URL validUrl = new URL(this.ref);
            }
            catch (MalformedURLException ex) {
                this.ref = UIUtilities.isMacOS() ? "file://" + this.ref : "file:///" + this.ref;
            }
            this.ref = this.ref.replace(" ", "%20");
            new BrowserLauncher().openURL(this.ref);
        }
    }

    private class GetLinkPathAction
    extends AbstractAction {
        public GetLinkPathAction() {
            this.putValue("Name", "Set Link to local file");
            this.putValue("ShortDescription", "Choose a file, that will be linked from this file");
            this.putValue("SmallIcon", DataRefEditor.this.linkLocalIcon);
        }

        public void actionPerformed(ActionEvent e) {
            DataRefEditor.this.getAndSaveLink();
        }
    }

    private class GetURLAction
    extends AbstractAction {
        public GetURLAction() {
            this.putValue("Name", "Set URL");
            this.putValue("ShortDescription", "Link to a web page");
            this.putValue("SmallIcon", DataRefEditor.this.wwwIcon);
        }

        public void actionPerformed(ActionEvent e) {
            String url = (String)JOptionPane.showInputDialog(null, "Enter URL:", "Enter URL", -1, DataRefEditor.this.wwwIcon, null, "http://");
            if (url == null || url.length() == 0) {
                return;
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException ex) {
                url = "http://" + url;
            }
            DataRefEditor.this.attributeEdited("reference", url);
        }
    }
}

