/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs;

import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.ITreeEditComp;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;

public abstract class AbstractParamEditor
extends JPanel
implements ITreeEditComp {
    private IAttributes param;
    private String lastEditedAttribute;
    protected BrowserControl controller;

    public AbstractParamEditor(IAttributes param) {
        if (param == null) {
            throw new NullPointerException("No param.");
        }
        this.param = param;
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(null);
        String paramName = param.getAttribute("paramName");
        if (paramName != null && paramName.length() > 0) {
            this.setToolTipText(paramName);
        }
    }

    public void setController(BrowserControl controller) {
        this.controller = controller;
    }

    public Component add(Component comp) {
        String paramName;
        if (comp instanceof JComponent && (paramName = this.param.getAttribute("paramName")) != null && paramName.length() > 0) {
            ((JComponent)comp).setToolTipText(paramName);
        }
        return super.add(comp);
    }

    public void attributeEdited(String attributeName, Object newValue) {
        if (attributeName == null) {
            return;
        }
        String oldValue = this.param.getAttribute(attributeName);
        this.lastEditedAttribute = attributeName;
        this.firePropertyChange("valueChangedProperty", oldValue, newValue);
    }

    public IAttributes getParameter() {
        return this.param;
    }

    public String getAttributeName() {
        return this.lastEditedAttribute;
    }
}

