/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.tree.TreeModel;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.editor.browser.MetadataPanelsComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.ScrollablePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class MetadataUI
extends ScrollablePanel
implements PropertyChangeListener {
    private BrowserControl controller;
    private TreeModel model;
    private BrowserUI view;
    private MetadataPanelsComponent imageAcquisition;
    private JXTaskPane imagePane;
    private JPanel container;
    private GridBagConstraints constraints;
    static final String DEFAULT_TEXT = "None";

    private void initComponents() {
        this.container = new JPanel();
        this.imageAcquisition = new MetadataPanelsComponent(this);
        this.imageAcquisition.addPropertyChangeListener(this);
        this.imagePane = EditorUtil.createTaskPane("OMERO.editor");
        this.imagePane.add((Component)this.imageAcquisition);
        this.imagePane.addPropertyChangeListener("collapsed", (PropertyChangeListener)this);
    }

    private void buildGUI() {
        this.container.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.container.setLayout(new GridBagLayout());
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BorderLayout(0, 0));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 2, 2, 0);
        this.constraints.weightx = 1.0;
        this.container.add((Component)this.imagePane, this.constraints);
        this.add((Component)this.container, "North");
    }

    void setTreeModel(TreeModel treeModel) {
        this.model = treeModel;
        this.imageAcquisition.setTreeModel(treeModel);
        this.refreshTitle();
    }

    void refreshTitle() {
        String rootName = this.model.getRoot().toString();
        this.imagePane.setTitle(rootName);
    }

    MetadataUI(BrowserUI view, TreeModel model, BrowserControl controller) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.model = model;
        this.controller = controller;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (!"collapsed".equals(name)) {
            return;
        }
    }
}

