/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.PlateSaver;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailFieldsLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.CellDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.env.data.model.TableResult;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.WellGridElement;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourObject;
import pojos.DataObject;
import pojos.PlateData;
import pojos.WellData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WellsModel
extends DataBrowserModel {
    private int rows;
    private int columns;
    private Dimension wellDimension;
    private List wellNodes;
    private Set<CellDisplay> cells;
    private int fieldsNumber;
    private int selectedField;
    private WellImageSet selectedNode;
    private int rowSequenceIndex;
    private int columnSequenceIndex;
    private List<WellGridElement> validWells;
    private boolean withThumbnails;

    private List sortByRow(Set nodes) {
        ArrayList l = new ArrayList();
        if (nodes == null) {
            return l;
        }
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            l.add(i.next());
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                WellData w1 = (WellData)((WellImageSet)o1).getHierarchyObject();
                WellData w2 = (WellData)((WellImageSet)o2).getHierarchyObject();
                int n1 = w1.getRow();
                int n2 = w2.getRow();
                int v = 0;
                if (n1 < n2) {
                    v = -1;
                } else if (n1 > n2) {
                    v = 1;
                } else if (n1 == n2) {
                    int c2;
                    int c1 = w1.getColumn();
                    if (c1 < (c2 = w2.getColumn().intValue())) {
                        v = -1;
                    } else if (c1 > c2) {
                        v = 1;
                    }
                }
                return v;
            }
        };
        Collections.sort(l, c);
        return l;
    }

    private Color createColor(WellData data) {
        int red = data.getRed();
        int green = data.getGreen();
        int blue = data.getBlue();
        int alpha = data.getAlpha();
        if (red < 0 || green < 0 || blue < 0 || alpha < 0) {
            return null;
        }
        if (red > 255 || green > 255 || blue > 255 || alpha > 255) {
            return null;
        }
        return new Color(red, green, blue, alpha);
    }

    private boolean isSameColor(Color c1, Color c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null && c2 != null) {
            return false;
        }
        if (c1 != null && c2 == null) {
            return false;
        }
        return c1.getRed() == c2.getRed() && c1.getBlue() == c2.getBlue() && c1.getGreen() == c2.getGreen() && c1.getAlpha() == c2.getAlpha();
    }

    private boolean isSameDescription(String d1, String d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null && d2 != null) {
            return false;
        }
        if (d1 != null && d2 == null) {
            return false;
        }
        return d1.trim().equals(d2.trim());
    }

    private void handleCellSelection(CellDisplay cell, WellImageSet well, List<DataObject> results) {
        String description = cell.getDescription();
        Color c = cell.getHighlight();
        WellData data = (WellData)well.getHierarchyObject();
        data.setWellType(description);
        well.setDescription(description);
        results.add((DataObject)data);
        if (c == null || !cell.isSpecified()) {
            data.setRed(null);
        } else {
            data.setRed(Integer.valueOf(c.getRed()));
            data.setGreen(Integer.valueOf(c.getGreen()));
            data.setBlue(Integer.valueOf(c.getBlue()));
            data.setAlpha(Integer.valueOf(c.getAlpha()));
        }
        well.setHighlight(c);
    }

    WellsModel(Object parent, Set<WellData> wells, boolean withThumbnails) {
        CellDisplay cell;
        int k;
        String rowSequence;
        String columnSequence;
        ColourObject co;
        if (wells == null) {
            throw new IllegalArgumentException("No wells.");
        }
        this.withThumbnails = withThumbnails;
        this.wellDimension = null;
        this.parent = parent;
        this.wellNodes = this.sortByRow(DataBrowserTranslator.transformHierarchy(wells, DataBrowserAgent.getUserDetails().getId(), 0L));
        PlateData plate = (PlateData)parent;
        this.columnSequenceIndex = plate.getColumnSequenceIndex();
        this.rowSequenceIndex = plate.getRowSequenceIndex();
        this.selectedField = plate.getDefaultSample();
        if (this.selectedField < 0) {
            this.selectedField = 0;
        }
        HashSet<ImageNode> samples = new HashSet<ImageNode>();
        this.cells = new HashSet<CellDisplay>();
        this.rows = -1;
        this.columns = -1;
        Iterator j = this.wellNodes.iterator();
        HashMap<Integer, ColourObject> cMap = new HashMap<Integer, ColourObject>();
        HashMap<Integer, ColourObject> rMap = new HashMap<Integer, ColourObject>();
        this.validWells = new ArrayList<WellGridElement>();
        while (j.hasNext()) {
            Color color;
            WellImageSet node = (WellImageSet)j.next();
            int row = node.getRow();
            int column = node.getColumn();
            WellData data = (WellData)node.getHierarchyObject();
            String type = data.getWellType();
            if (cMap.containsKey(column)) {
                co = (ColourObject)cMap.get(column);
                color = this.createColor(data);
                if (!this.isSameColor(co.getColor(), color) || !this.isSameDescription(co.getDescription(), type)) {
                    co.setColor(null);
                    co.setDescription(null);
                    cMap.put(column, co);
                }
            } else {
                cMap.put(column, new ColourObject(this.createColor(data), type));
            }
            if (rMap.containsKey(row)) {
                co = (ColourObject)rMap.get(row);
                color = this.createColor(data);
                if (!this.isSameColor(co.getColor(), color) || !this.isSameDescription(co.getDescription(), type)) {
                    co.setColor(null);
                    co.setDescription(null);
                    rMap.put(row, co);
                }
            } else {
                rMap.put(row, new ColourObject(this.createColor(data), type));
            }
            if (row > this.rows) {
                this.rows = row;
            }
            if (column > this.columns) {
                this.columns = column;
            }
            columnSequence = "";
            if (this.columnSequenceIndex == 1) {
                columnSequence = UIUtilities.LETTERS.get(column + 1);
            } else if (this.columnSequenceIndex == 0) {
                columnSequence = "" + (column + 1);
            }
            rowSequence = "";
            if (this.rowSequenceIndex == 1) {
                rowSequence = UIUtilities.LETTERS.get(row + 1);
            } else if (this.rowSequenceIndex == 0) {
                rowSequence = "" + (row + 1);
            }
            node.setCellDisplay(columnSequence, rowSequence);
            int f = node.getNumberOfSamples();
            if (this.fieldsNumber < f) {
                this.fieldsNumber = f;
            }
            node.setSelectedWellSample(this.selectedField);
            ImageNode selected = node.getSelectedWellSample();
            samples.add(selected);
            boolean b = false;
            if (((DataObject)selected.getHierarchyObject()).getId() >= 0L) {
                this.wellDimension = selected.getThumbnail().getOriginalSize();
                b = true;
            }
            this.validWells.add(new WellGridElement(row, column, b));
        }
        ++this.columns;
        ++this.rows;
        for (k = 1; k <= this.columns; ++k) {
            columnSequence = "";
            if (this.columnSequenceIndex == 1) {
                columnSequence = UIUtilities.LETTERS.get(k + 1);
            } else if (this.columnSequenceIndex == 0) {
                columnSequence = "" + k;
            }
            cell = new CellDisplay(k - 1, columnSequence);
            co = (ColourObject)cMap.get(k - 1);
            if (co != null) {
                cell.setHighlight(co.getColor());
                cell.setDescription(co.getDescription());
            }
            samples.add(cell);
            this.cells.add(cell);
        }
        for (k = 1; k <= this.rows; ++k) {
            rowSequence = "";
            if (this.rowSequenceIndex == 1) {
                rowSequence = UIUtilities.LETTERS.get(k);
            } else if (this.rowSequenceIndex == 0) {
                rowSequence = "" + k;
            }
            cell = new CellDisplay(k - 1, rowSequence, 0);
            co = (ColourObject)rMap.get(k - 1);
            if (co != null) {
                cell.setHighlight(co.getColor());
                cell.setDescription(co.getDescription());
            }
            samples.add(cell);
            this.cells.add(cell);
        }
        this.browser = BrowserFactory.createBrowser(samples);
        this.layoutBrowser(3);
        if (this.wellDimension == null) {
            this.wellDimension = new Dimension(96, 96);
        }
    }

    int getColumnSequenceIndex() {
        if (this.columnSequenceIndex == 1) {
            return 0;
        }
        return 1;
    }

    int getRowSequenceIndex() {
        if (this.rowSequenceIndex == 1) {
            return 0;
        }
        return 1;
    }

    List<WellGridElement> getValidWells() {
        return this.validWells;
    }

    int getFieldsNumber() {
        return this.fieldsNumber;
    }

    int getSelectedField() {
        return this.selectedField;
    }

    void setSelectedWell(WellImageSet node) {
        this.selectedNode = node;
    }

    WellImageSet getSelectedWell() {
        return this.selectedNode;
    }

    void viewField(int index) {
        WellSampleNode selected;
        if (index < 0 || index >= this.fieldsNumber) {
            return;
        }
        this.selectedField = index;
        HashSet<ImageDisplay> samples = new HashSet<ImageDisplay>();
        List<ImageDisplay> l = this.getNodes();
        Iterator<ImageDisplay> i = l.iterator();
        int row = -1;
        int col = -1;
        Collection c = this.browser.getSelectedDisplays();
        HashMap<Integer, Integer> location = new HashMap<Integer, Integer>();
        if (c != null && c.size() > 0) {
            for (Object object : c) {
                if (!(object instanceof WellSampleNode)) continue;
                selected = (WellSampleNode)object;
                location.put(selected.getRow(), selected.getColumn());
            }
        }
        ArrayList<ImageDisplay> nodes = new ArrayList<ImageDisplay>();
        while (i.hasNext()) {
            WellImageSet well = (WellImageSet)i.next();
            well.setSelectedWellSample(index);
            selected = (WellSampleNode)well.getSelectedWellSample();
            row = selected.getRow();
            if (location.containsKey(row)) {
                col = (Integer)location.get(row);
                if (selected.getColumn() == col) {
                    nodes.add(selected);
                }
            }
            samples.add(selected);
        }
        samples.addAll(this.cells);
        this.browser.refresh(samples, nodes);
        this.layoutBrowser(3);
        PlateData plate = (PlateData)this.parent;
        long userID = DataBrowserAgent.getUserDetails().getId();
        if (plate.getOwner().getId() == userID) {
            plate.setDefaultSample(this.selectedField);
            ArrayList<DataObject> list = new ArrayList<DataObject>();
            list.add((DataObject)plate);
            PlateSaver loader = new PlateSaver(this.component, list);
            ((DataBrowserLoader)loader).load();
        }
    }

    @Override
    void setTabularData(List<TableResult> data) {
        List<ImageDisplay> nodes = this.getNodes();
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        for (WellImageSet wellImageSet : nodes) {
            wellImageSet.setTabularData(data);
        }
    }

    void setSelectedCell(CellDisplay cell) {
        if (cell == null) {
            return;
        }
        ArrayList<DataObject> results = new ArrayList<DataObject>();
        List<ImageDisplay> l = this.getNodes();
        Iterator<ImageDisplay> i = l.iterator();
        int index = cell.getIndex();
        if (cell.getType() == 1) {
            while (i.hasNext()) {
                WellImageSet well = (WellImageSet)i.next();
                if (well.getColumn() != index) continue;
                this.handleCellSelection(cell, well, results);
            }
        } else {
            while (i.hasNext()) {
                WellImageSet well = (WellImageSet)i.next();
                if (well.getRow() != index) continue;
                this.handleCellSelection(cell, well, results);
            }
        }
        if (results.size() > 0) {
            PlateSaver loader = new PlateSaver(this.component, results);
            ((DataBrowserLoader)loader).load();
        }
    }

    void setSelectedField(WellSampleNode node) {
        this.browser.setSelectedDisplay(node, false, true);
    }

    int getRows() {
        return this.rows;
    }

    int getColumns() {
        return this.columns;
    }

    boolean isSameWell(int row, int column) {
        if (this.selectedNode == null) {
            return false;
        }
        return this.selectedNode.getRow() == row && this.selectedNode.getColumn() == column;
    }

    WellImageSet getWell(int row, int column) {
        List<ImageDisplay> l = this.getNodes();
        for (WellImageSet wellImageSet : l) {
            if (wellImageSet.getColumn() != column || wellImageSet.getRow() != row) continue;
            return wellImageSet;
        }
        return null;
    }

    DataBrowserLoader createFieldsLoader(int row, int column) {
        List<ImageDisplay> l = this.getNodes();
        Iterator<ImageDisplay> i = l.iterator();
        ArrayList<DataObject> images = new ArrayList<DataObject>();
        while (i.hasNext()) {
            WellImageSet wis;
            ImageSet node = (ImageSet)i.next();
            if (!(node instanceof WellImageSet) || (wis = (WellImageSet)node).getRow() != row || wis.getColumn() != column) continue;
            this.selectedNode = wis;
            List<WellSampleNode> nodes = wis.getWellSamples();
            for (WellSampleNode n : nodes) {
                WellSampleData data = (WellSampleData)n.getHierarchyObject();
                if (data.getId() < 0L) {
                    Thumbnail thumb = n.getThumbnail();
                    thumb.setValid(false);
                    thumb.setFullScaleThumb(Factory.createDefaultImageThumbnail(this.wellDimension.width, this.wellDimension.height));
                    continue;
                }
                images.add((DataObject)data.getImage());
            }
        }
        if (images.size() == 0) {
            return null;
        }
        return new ThumbnailFieldsLoader(this.component, images, row, column);
    }

    @Override
    protected DataBrowserLoader createDataLoader(boolean refresh, Collection ids) {
        if (!this.withThumbnails) {
            return null;
        }
        List<ImageDisplay> l = this.getNodes();
        Iterator<ImageDisplay> i = l.iterator();
        ArrayList<DataObject> images = new ArrayList<DataObject>();
        while (i.hasNext()) {
            ImageSet node = (ImageSet)i.next();
            if (!(node instanceof WellImageSet)) continue;
            ImageNode selected = ((WellImageSet)node).getSelectedWellSample();
            WellSampleData data = (WellSampleData)selected.getHierarchyObject();
            if (data.getId() < 0L) {
                Thumbnail thumb = selected.getThumbnail();
                thumb.setValid(false);
                thumb.setFullScaleThumb(Factory.createDefaultImageThumbnail(this.wellDimension.width, this.wellDimension.height));
                continue;
            }
            images.add((DataObject)data.getImage());
        }
        if (images.size() == 0) {
            return null;
        }
        return new ThumbnailLoader(this.component, images);
    }

    @Override
    protected int getType() {
        return 5;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return this.wellNodes;
    }
}

