/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserControl;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserStatusBar;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserToolBar;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserWellToolBar;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImageTableView;
import org.openmicroscopy.shoola.agents.dataBrowser.view.PlateGridUI;
import org.openmicroscopy.shoola.agents.dataBrowser.view.PopupMenu;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SlideShowView;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellFieldsView;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.MagnificationVisitor;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.ScrollablePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.search.SearchObject;
import pojos.DataObject;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataBrowserUI
extends ScrollablePanel {
    static final int THUMB_VIEW = 0;
    static final int COLUMNS_VIEW = 1;
    static final int FIELDS_VIEW = 2;
    static final int SORT_BY_NAME = 2;
    static final int SORT_BY_DATE = 3;
    private DataBrowserToolBar toolBar;
    private DataBrowserWellToolBar wellToolBar;
    private DataBrowserStatusBar statusBar;
    private PlateGridUI plateGridUI;
    private DataBrowserModel model;
    private DataBrowserControl controller;
    private SlideShowView slideShowView;
    private int selectedView;
    private PopupMenu popupMenu;
    private WellFieldsView fieldsView;
    private double factor;

    DataBrowserUI() {
        super(true);
    }

    void initialize(DataBrowserModel model, DataBrowserControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.model = model;
        this.controller = controller;
        this.wellToolBar = new DataBrowserWellToolBar(this, controller);
        this.toolBar = new DataBrowserToolBar(model, this, controller);
        if (model.getType() == 5) {
            this.plateGridUI = new PlateGridUI((WellsModel)model, controller);
        }
        this.statusBar = new DataBrowserStatusBar(this);
        this.selectedView = 0;
        this.factor = 0.5;
        this.setNumberOfImages(-1);
        this.setLayout(new BorderLayout(0, 0));
        this.buildGUI(true);
    }

    void buildGUI(boolean full) {
        this.removeAll();
        if (full) {
            if (this.model.getType() == 5) {
                this.add((Component)this.wellToolBar, "North");
            } else {
                this.add((Component)this.toolBar, "North");
            }
            this.add((Component)this.statusBar, "South");
        }
        this.add((Component)this.model.getBrowser().getUI(), "Center");
    }

    PlateGridUI getGridUI() {
        return this.plateGridUI;
    }

    SearchObject getSelectedFilter() {
        return this.toolBar.getSelectedFilter();
    }

    Collection getExistingTags() {
        return this.model.getExistingTags();
    }

    void setTags(Collection tags) {
        this.toolBar.setTags(tags);
    }

    void slideShowView(boolean create) {
        List<ImageNode> nodes;
        this.toolBar.enableSlideShow(!create);
        if (!create) {
            if (this.slideShowView != null) {
                this.model.cancelSlideShow();
                this.slideShowView.close();
            }
            return;
        }
        Browser browser = this.model.getBrowser();
        Collection selected = browser.getSelectedDisplays();
        if (selected != null && selected.size() > 0) {
            nodes = new ArrayList<ImageNode>();
            for (Object n : selected) {
                if (!(n instanceof ImageNode)) continue;
                nodes.add((ImageNode)n);
            }
        } else {
            nodes = browser.getVisibleImageNodes();
        }
        if (nodes == null || nodes.size() == 0) {
            this.toolBar.enableSlideShow(true);
            return;
        }
        ArrayList<ImageNode> selection = new ArrayList<ImageNode>(nodes.size());
        for (ImageNode n : nodes) {
            selection.add(n.copy());
        }
        Registry reg = DataBrowserAgent.getRegistry();
        this.slideShowView = new SlideShowView(reg.getTaskBar().getFrame(), selection);
        this.slideShowView.addPropertyChangeListener(this.controller);
        this.model.fireFullSizeLoading(selection);
        UIUtilities.centerAndShow(this.slideShowView);
        if (this.model.getState() != 6) {
            this.setSlideViewStatus(true, -1);
        }
    }

    void setSlideViewStatus(boolean hideProgressBar, int progressPerc) {
        if (this.slideShowView != null) {
            this.slideShowView.setProgress(hideProgressBar, progressPerc);
        }
    }

    boolean isRollOver() {
        return this.model.isRollOver();
    }

    void layoutUI() {
        switch (this.selectedView) {
            case 0: {
                Browser b = this.model.getBrowser();
                this.model.layoutBrowser();
                b.getUI().repaint();
                this.model.loadData(false, null);
                b.getUI().repaint();
                break;
            }
            case 1: {
                ImageTableView v = this.model.getTableView();
                if (v == null) break;
                v.refreshTable();
            }
        }
    }

    void setSelectedView(int index) {
        this.removeAll();
        double f = 0.5;
        switch (index) {
            case 0: {
                this.selectedView = index;
                if (this.model.getType() == 5) {
                    this.add((Component)this.wellToolBar, "North");
                    this.wellToolBar.displayFieldsOptions(false);
                } else {
                    this.add((Component)this.toolBar, "North");
                    this.layoutUI();
                }
                this.add((Component)this.model.getBrowser().getUI(), "Center");
                f = this.factor;
                break;
            }
            case 2: {
                this.selectedView = index;
                this.add((Component)this.wellToolBar, "North");
                if (this.fieldsView == null) {
                    f = 2.5;
                    this.fieldsView = new WellFieldsView((WellsModel)this.model, this.controller, f);
                }
                this.wellToolBar.displayFieldsOptions(true);
                this.add((Component)this.fieldsView, "Center");
                f = this.fieldsView.getMagnification();
                break;
            }
            case 1: {
                Collection nodes;
                this.selectedView = index;
                this.add((Component)this.toolBar, "North");
                ImageTableView existed = this.model.getTableView();
                ImageTableView v = this.model.createImageTableView();
                if (existed != null && v != null) {
                    v.refreshTable();
                }
                if ((nodes = this.model.getBrowser().getSelectedDisplays()) != null) {
                    Iterator i = nodes.iterator();
                    ArrayList<DataObject> objects = new ArrayList<DataObject>();
                    while (i.hasNext()) {
                        ImageDisplay display = (ImageDisplay)i.next();
                        Object ho = display.getHierarchyObject();
                        if (!(ho instanceof DataObject)) continue;
                        objects.add((DataObject)ho);
                    }
                    v.setSelectedNodes(objects);
                }
                if (existed == null) {
                    v.addPropertyChangeListener(this.controller);
                }
                v.validate();
                v.repaint();
                this.add((Component)v, "Center");
            }
        }
        this.add((Component)this.statusBar, "South");
        this.toolBar.setSelectedViewIndex(this.selectedView);
        this.statusBar.setSelectedViewIndex(this.selectedView, f);
        this.revalidate();
        this.repaint();
    }

    int getSelectedView() {
        return this.selectedView;
    }

    void setRollOver(boolean rollOver) {
        this.model.getBrowser().setRollOver(rollOver);
    }

    void setItemsPerRow(int number) {
        Browser browser = this.model.getBrowser();
        Layout layout = browser.getSelectedLayout();
        layout.setImagesPerRow(number);
        browser.accept(layout, 1);
    }

    void setNumberOfImages(int value) {
        if (value < 0) {
            value = this.model.getNumberOfImages();
        }
        this.toolBar.setNumberOfImages(value, this.model.getNumberOfImages());
    }

    void sortBy(int index) {
        this.model.getSorter().setByDate(3 == index);
        this.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = this.model.getBrowser();
        browser.accept(browser.getSelectedLayout(), 1);
        ImageTableView v = this.model.getTableView();
        if (v != null) {
            v.refreshTable();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    void setMagnificationFactor(double factor) {
        switch (this.selectedView) {
            case 0: {
                MagnificationVisitor visitor = new MagnificationVisitor(factor);
                Browser browser = this.model.getBrowser();
                browser.accept(visitor, 0);
                browser.accept(browser.getSelectedLayout(), 1);
                break;
            }
            case 2: {
                if (this.fieldsView == null) break;
                this.fieldsView.setMagnificationFactor(factor);
            }
        }
    }

    void setMagnificationUnscaled(double factor) {
        if (this.selectedView == 2 && this.fieldsView != null) {
            this.fieldsView.setMagnificationUnscaled(factor);
        }
    }

    void showPopup(Point p) {
        if (this.popupMenu == null) {
            this.popupMenu = new PopupMenu(this.controller, this.model);
        }
        JPanel comp = null;
        switch (this.selectedView) {
            case 0: {
                comp = this.model.getBrowser().getLastSelectedDisplay();
                break;
            }
            case 1: {
                comp = this.model.getTableView();
            }
        }
        if (comp != null) {
            this.popupMenu.populateOpenWith();
            this.popupMenu.show(comp, p.x, p.y);
        }
    }

    List<ApplicationData> getApplications() {
        return this.model.getApplications();
    }

    void viewSelectedNode() {
        ImageDisplay node = this.model.getBrowser().getLastSelectedDisplay();
        if (!(node instanceof ImageNode)) {
            return;
        }
        ImageData data = (ImageData)node.getHierarchyObject();
        EventBus bus = DataBrowserAgent.getRegistry().getEventBus();
        bus.post(new ViewImage((DataObject)data, null));
    }

    void setStatus(String status, boolean hideProgressBar, int progressPerc) {
        this.statusBar.setStatus(status);
        this.statusBar.setProgress(hideProgressBar, progressPerc);
    }

    void filterByContext(FilterContext context) {
        if (context == null) {
            return;
        }
        this.toolBar.filterByContext(context);
    }

    void setFilterStatus(boolean busy) {
        this.toolBar.setFilterStatus(busy);
    }

    void setFilterLabel(String value) {
        this.toolBar.setFilterLabel(value);
    }

    int getFieldsNumber() {
        if (this.model instanceof WellsModel) {
            return ((WellsModel)this.model).getFieldsNumber();
        }
        return -1;
    }

    int getSelectedField() {
        if (this.model instanceof WellsModel) {
            return ((WellsModel)this.model).getSelectedField();
        }
        return 0;
    }

    void viewField() {
        this.setMagnificationFactor(this.statusBar.getMagnificationFactor());
    }

    void setFieldsStatus(boolean status) {
        this.wellToolBar.setStatus(status);
    }

    void displayFields(List<WellSampleNode> nodes) {
        if (this.fieldsView == null) {
            return;
        }
        this.setFieldsStatus(false);
        if (this.selectedView == 2) {
            this.fieldsView.displayFields(nodes);
        }
    }

    void onSelectedWell() {
        if (!(this.model instanceof WellsModel)) {
            return;
        }
        this.plateGridUI.onSelectedWell();
    }

    void setSelectedFieldLayout(int index) {
        if (this.fieldsView == null) {
            return;
        }
        this.fieldsView.setLayoutFields(index);
        if (this.selectedView == 2) {
            this.fieldsView.displayFields(this.fieldsView.getNodes());
        }
    }

    void onExperimenterSet() {
        this.toolBar.onExperimenterSet();
    }

    Object getParentOfNodes() {
        return this.model.getParent();
    }

    Object getGrandParentOfNodes() {
        return this.model.getGrandParent();
    }
}

