/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserUI;
import org.openmicroscopy.shoola.util.ui.MagnificationComponent;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;

class DataBrowserStatusBar
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    private static final int FACTOR = 10;
    private DataBrowserUI view;
    private OneKnobSlider fieldsZoomSlider;
    private OneKnobSlider zoomSlider;
    private JProgressBar progressBar;
    private JLabel status;
    private MagnificationComponent mag;
    private OneKnobSlider refSlider;

    private void initComponents() {
        this.mag = new MagnificationComponent(0.25, 2.5, 0.5);
        this.mag.addPropertyChangeListener("magnification", this);
        this.fieldsZoomSlider = new OneKnobSlider(0, 10, 40, 10);
        this.fieldsZoomSlider.setToolTipText("Magnifies the thumbnails.");
        this.zoomSlider = new OneKnobSlider(0, 2, 25, 5);
        this.zoomSlider.addChangeListener(this);
        this.zoomSlider.setToolTipText("Magnifies the thumbnails.");
        this.fieldsZoomSlider.addChangeListener(this);
        this.refSlider = this.zoomSlider;
        this.progressBar = new JProgressBar();
        this.status = new JLabel();
        this.progressBar.setVisible(false);
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 0));
        JPanel right = new JPanel();
        right.setLayout(new FlowLayout(2, 0, 0));
        right.add(this.progressBar);
        JPanel left = new JPanel();
        left.setLayout(new FlowLayout(0, 0, 0));
        left.add(this.mag);
        left.add(Box.createHorizontalStrut(5));
        left.add(this.refSlider);
        this.add(left);
        this.add(right);
    }

    DataBrowserStatusBar(DataBrowserUI view) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    void setSelectedViewIndex(int index, double magnification) {
        this.refSlider = this.zoomSlider;
        this.mag.setOriginal(magnification);
        if (index == 2) {
            this.refSlider = this.fieldsZoomSlider;
        }
        this.removeAll();
        this.buildGUI();
    }

    void setStatus(String s) {
        this.status.setText(s);
    }

    void setProgress(boolean hide, int perc) {
        this.progressBar.setVisible(!hide);
        if (perc < 0) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setStringPainted(true);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(perc);
        }
    }

    double getMagnificationFactor() {
        return this.mag.getMagnification();
    }

    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.fieldsZoomSlider) {
            int v = this.fieldsZoomSlider.getValue();
            double f = (double)v / 10.0;
            this.view.setMagnificationUnscaled(f);
        } else if (src == this.zoomSlider) {
            int v = this.zoomSlider.getValue();
            double f = (double)v / 10.0;
            this.view.setMagnificationFactor(f);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("magnification".equals(name)) {
            double v = (Double)evt.getNewValue();
            this.view.setMagnificationFactor(v);
            int value = (int)(v * 10.0);
            this.zoomSlider.removeChangeListener(this);
            this.zoomSlider.setValue(value);
            this.zoomSlider.addChangeListener(this);
        }
    }
}

