/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ThumbnailCanvas;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;
import pojos.WellSampleData;

public class ImageNode
extends ImageDisplay {
    public static final String CLASSIFY_NODE_PROPERTY = "classifyNode";
    public static final String PIN_THUMBNAIL_PROPERTY = "pinThumbnail";
    private static final String LEFT = " (";
    private static final String RIGHT = ")";
    private Thumbnail thumbnail;
    private ThumbnailCanvas canvas;

    protected void doAccept(ImageDisplayVisitor visitor) {
        visitor.visit(this);
    }

    void pinThumbnail() {
        this.firePropertyChange(PIN_THUMBNAIL_PROPERTY, null, this);
    }

    public ImageNode(String title, Object hierarchyObject, Thumbnail t) {
        this(title, hierarchyObject, t, 1);
    }

    public ImageNode(String title, Object hierarchyObject, Thumbnail t, int titleBar) {
        super(title, "", hierarchyObject);
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body>");
        buf.append(UIUtilities.formatString(title, -1));
        buf.append("<br>");
        buf.append(this.getFormattedAcquisitionTime());
        this.setTitle(this.getPartialName(title + LEFT + this.getFormattedAcquisitionTime() + RIGHT));
        this.setToolTipText(buf.toString());
        this.setNodeDecoration();
        this.thumbnail = t;
        if (t != null) {
            this.canvas = new ThumbnailCanvas(this);
            this.getInternalDesktop().add((Component)this.canvas, (Object)0);
            this.setCanvasSize(t.getWidth(), t.getHeight());
            this.setCanvasToolTip(this.getToolTipText());
        }
        this.setTitleBarType(titleBar);
    }

    public void addMouseListenerToComponents(MouseListener listener) {
        this.getTitleBar().addMouseListener(listener);
        if (this.canvas != null) {
            this.canvas.addMouseListener(listener);
        }
    }

    public void addChildDisplay(ImageDisplay child) {
        throw new IllegalArgumentException("Can't add a child to an ImageNode.");
    }

    public boolean containsImages() {
        return false;
    }

    public Thumbnail getThumbnail() {
        return this.thumbnail;
    }

    public Timestamp getAcquisitionTime() {
        ImageData img;
        Object uo = this.getHierarchyObject();
        Timestamp t = null;
        if (uo instanceof ImageData) {
            t = ((ImageData)uo).getAcquisitionDate();
        } else if (uo instanceof WellSampleData && (img = ((WellSampleData)uo).getImage()) != null) {
            t = img.getAcquisitionDate();
        }
        if (t == null) {
            t = new Timestamp(new Date().getTime());
        }
        return t;
    }

    public String getFormattedAcquisitionTime() {
        return DateFormat.getDateInstance().format(this.getAcquisitionTime());
    }

    public void setCanvasSize(int w, int h) {
        if (this.canvas != null) {
            this.canvas.setBounds(0, 0, w, h);
        }
        this.getInternalDesktop().setSize(w, h);
        this.getInternalDesktop().setPreferredSize(new Dimension(w, h));
    }

    public void setCanvasToolTip(String text) {
        if (this.canvas != null) {
            this.canvas.setToolTipText(text);
        }
    }

    public ImageNode copy() {
        ImageNode img = new ImageNode(this.getTitle(), this.getHierarchyObject(), this.getThumbnail());
        if (this.canvas != null) {
            img.setCanvasSize(this.canvas.getWidth(), this.canvas.getHeight());
        }
        return img;
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.setResizable(false);
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.setResizable(false);
    }
}

