/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.FileData;
import pojos.ImageData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageFinder
implements ImageDisplayVisitor {
    private Set<ImageDisplay> imageNodes;
    private Set<DataObject> images = new HashSet<DataObject>();
    private List<ImageNode> visibleImageNodes;
    private Set<DataObject> visibleImages;

    public ImageFinder() {
        this.imageNodes = new HashSet<ImageDisplay>();
        this.visibleImages = new HashSet<DataObject>();
        this.visibleImageNodes = new ArrayList<ImageNode>();
    }

    public Set<ImageDisplay> getImageNodes() {
        return this.imageNodes;
    }

    public Set<DataObject> getImages() {
        return this.images;
    }

    public List<ImageNode> getVisibleImageNodes() {
        return this.visibleImageNodes;
    }

    public Set<DataObject> getVisibleImages() {
        return this.visibleImages;
    }

    @Override
    public void visit(ImageNode node) {
        this.imageNodes.add(node);
        Object ho = node.getHierarchyObject();
        if (ho instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)ho;
            ho = wsd.getImage();
        }
        if (ho instanceof ImageData) {
            this.images.add((DataObject)((ImageData)ho));
        }
    }

    @Override
    public void visit(ImageSet node) {
        if (node == null) {
            return;
        }
        JComponent desktop = node.getInternalDesktop();
        Component[] comps = desktop.getComponents();
        if (comps != null) {
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                if (!(c instanceof ImageNode)) continue;
                ImageNode n = (ImageNode)c;
                Object ho = n.getHierarchyObject();
                if (ho instanceof WellSampleData) {
                    WellSampleData wsd = (WellSampleData)ho;
                    ho = wsd.getImage();
                    continue;
                }
                if (ho instanceof ImageData) {
                    this.visibleImages.add((DataObject)((ImageData)ho));
                    this.visibleImageNodes.add(n);
                    continue;
                }
                if (ho instanceof FileData) {
                    this.visibleImages.add((DataObject)((FileData)ho));
                    this.visibleImageNodes.add(n);
                    continue;
                }
                if (!(ho instanceof ExperimenterData)) continue;
                this.visibleImages.add((DataObject)((ExperimenterData)ho));
                this.visibleImageNodes.add(n);
            }
        }
    }
}

