/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailProvider;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import pojos.ExperimenterData;
import pojos.ImageData;

public class ThumbnailsManager {
    private int totalIDs;
    private Set<Object> processedIDs;
    private Map<Object, Set> thumbProviders;

    public ThumbnailsManager(Collection nodes, int totalIDs) {
        if (nodes == null) {
            throw new NullPointerException("No image nodes.");
        }
        this.totalIDs = totalIDs;
        this.processedIDs = new HashSet<Object>();
        this.thumbProviders = new HashMap<Object, Set>();
        Iterator i = nodes.iterator();
        ImageData is = null;
        Thumbnail thumb = null;
        Object ho = null;
        while (i.hasNext()) {
            Set<Thumbnail> providers;
            ImageDisplay node = (ImageDisplay)i.next();
            if (node instanceof WellImageSet) {
                is = ((WellImageSet)node).getSelectedImage();
                thumb = ((WellImageSet)node).getSelectedWellSample().getThumbnail();
            } else if (node instanceof ImageNode) {
                ho = node.getHierarchyObject();
                if (ho instanceof ImageData && (is = (ImageData)ho).getId() < 0L) {
                    is = null;
                }
                thumb = ((ImageNode)node).getThumbnail();
            }
            if (is != null) {
                Long id = is.getId();
                providers = this.thumbProviders.get(id);
                if (providers == null) {
                    providers = new HashSet();
                    this.thumbProviders.put(id, providers);
                }
                providers.add(thumb);
                continue;
            }
            if (ho instanceof ImageData) {
                providers = this.thumbProviders.get(ho);
                if (providers == null) {
                    providers = new HashSet<Thumbnail>();
                    this.thumbProviders.put(ho, providers);
                }
                providers.add(thumb);
                continue;
            }
            if (!(ho instanceof ExperimenterData)) continue;
            ExperimenterData exp = (ExperimenterData)ho;
            providers = this.thumbProviders.get(exp.getId());
            if (providers == null) {
                providers = new HashSet();
                this.thumbProviders.put(exp.getId(), providers);
            }
            providers.add(thumb);
        }
    }

    public void setThumbnail(Object ref, BufferedImage thumb, boolean valid) {
        Set providers;
        if (thumb == null) {
            throw new NullPointerException("No thumbnail.");
        }
        if ((ref instanceof Long || ref instanceof ImageData) && (providers = this.thumbProviders.get(ref)) != null) {
            for (ThumbnailProvider tp : providers) {
                tp.setValid(valid);
                tp.setFullScaleThumb(thumb);
            }
            this.processedIDs.add(ref);
        }
    }

    public void setFullSizeImage(long imageID, BufferedImage thumb) {
        if (thumb == null) {
            throw new NullPointerException("No thumbnail.");
        }
        Long id = imageID;
        Set providers = this.thumbProviders.get(id);
        if (providers != null) {
            Iterator p = providers.iterator();
            while (p.hasNext()) {
                ((ThumbnailProvider)p.next()).setFullSizeImage(thumb);
            }
            this.processedIDs.add(id);
        }
    }

    public boolean isDone() {
        return this.processedIDs.size() == this.totalIDs;
    }
}

