/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.FileData;
import pojos.ImageData;
import pojos.PixelsData;

public class ThumbnailProvider
implements Thumbnail {
    public static final int THUMB_MAX_WIDTH = 96;
    public static final int THUMB_MAX_HEIGHT = 96;
    private static final double ZOOM_FACTOR = 1.5;
    private static final int BORDER = 1;
    private static final Color BORDER_COLOR = Color.WHITE;
    private DataObject imgInfo;
    private ImageNode display;
    private int width;
    private int height;
    private int originalWidth;
    private int originalHeight;
    private BufferedImage fullScaleThumb;
    private BufferedImage displayThumb;
    private BufferedImage fullSizeImage;
    private double scalingFactor;
    private Icon iconThumb;
    private boolean valid;

    private void computeDims() {
        PixelsData pxd = null;
        this.width = 48;
        this.height = 48;
        this.originalWidth = 96;
        this.originalHeight = 96;
        try {
            if (!(this.imgInfo instanceof ImageData)) {
                return;
            }
            pxd = ((ImageData)this.imgInfo).getDefaultPixels();
        }
        catch (Exception e) {
            this.width = 48;
            this.height = 48;
            this.originalWidth = 96;
            this.originalHeight = 96;
            return;
        }
        if (pxd == null) {
            this.width = 48;
            this.height = 48;
            this.originalWidth = 96;
            this.originalHeight = 96;
            return;
        }
        double pixSizeX = pxd.getSizeX();
        double pixSizeY = pxd.getSizeY();
        Dimension size = Factory.computeThumbnailSize(this.width, this.height, pixSizeX, pixSizeY);
        this.width = size.width;
        this.height = size.height;
        size = Factory.computeThumbnailSize(this.originalWidth, this.originalHeight, pixSizeX, pixSizeY);
        this.originalWidth = size.width;
        this.originalHeight = size.height;
    }

    public ThumbnailProvider(DataObject is) {
        if (is == null) {
            throw new IllegalArgumentException("No image.");
        }
        if (!(is instanceof ImageData || is instanceof ExperimenterData || is instanceof FileData)) {
            throw new IllegalArgumentException("Objet to supported.");
        }
        this.imgInfo = is;
        this.scalingFactor = 0.5;
        this.computeDims();
        this.valid = true;
    }

    public void setImageNode(ImageNode node) {
        if (node == null) {
            throw new IllegalArgumentException("No Image node");
        }
        this.display = node;
    }

    public void setFullScaleThumb(BufferedImage t) {
        this.fullScaleThumb = t;
        this.fullSizeImage = null;
        if (this.fullScaleThumb != null) {
            this.scale(this.scalingFactor);
        }
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        if (!valid && this.display != null) {
            Registry reg = DataBrowserAgent.getRegistry();
            Boolean b = (Boolean)reg.lookup("/views/DisplayNonValidImage");
            this.display.setVisible(b);
        }
    }

    public BufferedImage getDisplayedImage() {
        return this.displayThumb;
    }

    public void scale(double f) {
        if (f < 0.25 || f > 2.5) {
            return;
        }
        this.scalingFactor = f;
        int w = (int)((double)this.originalWidth * f);
        int h = (int)((double)this.originalHeight * f);
        if (this.fullScaleThumb != null) {
            this.displayThumb = Factory.magnifyImage(f, this.fullScaleThumb);
            w = this.displayThumb.getWidth();
            h = this.displayThumb.getHeight();
        }
        if (this.display != null) {
            this.display.setCanvasSize(w, h);
            this.display.pack();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public BufferedImage getFullScaleThumb() {
        return this.fullScaleThumb;
    }

    public BufferedImage getZoomedFullScaleThumb() {
        return Factory.magnifyImage(1.5, this.fullScaleThumb);
    }

    public Icon getIcon() {
        if (this.iconThumb != null) {
            return this.iconThumb;
        }
        if (this.fullScaleThumb == null) {
            return null;
        }
        BufferedImage img = Factory.magnifyImage(0.16, this.fullScaleThumb);
        BufferedImage newImg = new BufferedImage(img.getWidth() + 2, img.getHeight() + 2, img.getType());
        Graphics g = newImg.getGraphics();
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(BORDER_COLOR);
        g2D.fillRect(0, 0, newImg.getWidth(), newImg.getHeight());
        g2D.drawImage(img, null, 1, 1);
        this.iconThumb = new ImageIcon(newImg);
        return this.iconThumb;
    }

    public boolean isThumbnailLoaded() {
        return this.fullScaleThumb != null;
    }

    public void setFullSizeImage(BufferedImage image) {
        this.fullSizeImage = image;
    }

    public BufferedImage getFullSizeImage() {
        return this.fullSizeImage;
    }

    public Dimension getOriginalSize() {
        return new Dimension(this.originalWidth, this.originalHeight);
    }
}

