/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.Collection;
import java.util.List;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailLoader
extends DataBrowserLoader {
    public static final int EXPERIMENTER = 1;
    public static final int FS_FILE = 2;
    public static final int IMAGE = 0;
    private int max;
    private Collection<DataObject> objects;
    private int type;
    private boolean thumbnail;
    private CallHandle handle;

    public ThumbnailLoader(DataBrowser viewer, Collection<DataObject> objects, int type) {
        this(viewer, objects, true, type);
    }

    public ThumbnailLoader(DataBrowser viewer, Collection<DataObject> objects) {
        this(viewer, objects, true, 0);
    }

    public ThumbnailLoader(DataBrowser viewer, Collection<DataObject> objects, boolean thumbnail, int type) {
        super(viewer);
        if (objects == null) {
            throw new IllegalArgumentException("Collection shouldn't be null.");
        }
        this.type = type < 0 ? 0 : type;
        this.objects = objects;
        this.thumbnail = thumbnail;
        this.max = objects.size();
    }

    @Override
    public void load() {
        long userID = DataBrowserAgent.getUserDetails().getId();
        this.handle = this.thumbnail ? this.hiBrwView.loadThumbnails(this.objects, 96, 96, userID, this.type, this) : this.hiBrwView.loadThumbnails(this.objects, 288, 288, userID, this.type, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        block8: {
            int percDone;
            String status;
            block7: {
                if (this.viewer.getState() == 5) {
                    return;
                }
                status = fe.getStatus();
                percDone = fe.getPercentDone();
                if (!this.thumbnail) break block7;
                if (status == null) {
                    status = percDone == 100 ? "Done" : "";
                }
                this.viewer.setStatus(status, percDone);
                List l = (List)fe.getPartialResult();
                if (l == null || l.size() <= 0) break block8;
                for (ThumbnailData td : l) {
                    Object ref = td.getRefObject();
                    if (ref == null) {
                        ref = td.getImageID();
                    }
                    this.viewer.setThumbnail(ref, td.getThumbnail(), td.isValidImage(), this.max);
                }
                break block8;
            }
            if (status == null) {
                status = percDone == 100 ? "Done" : "";
            }
            this.viewer.setSlideViewStatus(status, percDone);
            List l = (List)fe.getPartialResult();
            if (l != null) {
                for (ThumbnailData td : l) {
                    this.viewer.setSlideViewImage(td.getImageID(), td.getThumbnail());
                }
            }
        }
    }

    @Override
    public void handleNullResult() {
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Thumbnail Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Thumbnail Retrieval Failure", s, exc);
    }
}

