/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.slider;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.openmicroscopy.shoola.util.ui.GridModel;
import org.openmicroscopy.shoola.util.ui.PlateGrid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridSlider
extends JTable {
    public static final String COLUMN_SELECTION_PROPERTY = "columnSelection";
    public static final Dimension CELL_SIZE = new Dimension(14, 14);
    private Map<Integer, Boolean> selectedCells;
    private Map<Integer, String> cellNames;
    private int textIncrement;

    private void initiliaze(int columns) {
        this.setTableHeader(null);
        this.selectedCells = new HashMap<Integer, Boolean>();
        this.setModel(new GridModel(1, columns));
        int width = GridSlider.CELL_SIZE.width;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            col.setMinWidth(width);
            col.setMaxWidth(width);
            col.setPreferredWidth(width);
            col.setResizable(false);
        }
        this.setRowHeight(GridSlider.CELL_SIZE.height);
        this.setDefaultRenderer(Object.class, new GridSliderRenderer(this));
        this.setAutoResizeMode(0);
        this.setGridColor(PlateGrid.GRID_COLOR);
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                int column = GridSlider.this.getSelectedColumn();
                boolean selected = !GridSlider.this.selectedCells.containsKey(column);
                GridSlider.this.selectCell(column, selected);
                GridSlider.this.firePropertyChange(GridSlider.COLUMN_SELECTION_PROPERTY, !selected, selected);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                int column = GridSlider.this.getSelectedColumn();
                boolean selected = !GridSlider.this.selectedCells.containsKey(column);
                GridSlider.this.selectCell(column, selected);
                GridSlider.this.firePropertyChange(GridSlider.COLUMN_SELECTION_PROPERTY, !selected, selected);
            }
        });
        this.selectCells(1);
    }

    public GridSlider(int columns) {
        this.initiliaze(columns);
    }

    public GridSlider(int columns, int textIncrement) {
        this.initiliaze(columns);
        this.textIncrement = textIncrement;
    }

    String getCellTooltipText(int column) {
        if (this.cellNames != null && this.cellNames.containsKey(column)) {
            return this.cellNames.get(column);
        }
        return "" + (column + this.textIncrement);
    }

    boolean isSelected(int column) {
        return this.selectedCells.containsKey(column);
    }

    public void setCellNames(Map<Integer, String> cellNames) {
        this.cellNames = cellNames;
    }

    public void selectCell(int column, boolean selected) {
        if (selected) {
            this.selectedCells.put(column, selected);
        } else {
            this.selectedCells.remove(column);
        }
        this.setColumnSelectionInterval(column, column);
        this.setRowSelectionInterval(0, 0);
        this.repaint();
    }

    public void selectCells(int frequency) {
        this.selectedCells.clear();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (i % frequency != 0) continue;
            this.selectedCells.put(i, true);
        }
        this.repaint();
    }

    public List<Integer> getSelectedCells() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Iterator<Integer> i = this.selectedCells.keySet().iterator();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    public int getNumberOfSelectedCells() {
        return this.selectedCells.size();
    }

    class GridSliderRenderer
    extends DefaultTableCellRenderer {
        private GridSlider model;

        GridSliderRenderer(GridSlider model) {
            this.model = model;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setToolTipText(this.model.getCellTooltipText(column));
            if (this.model.isSelected(column)) {
                this.setBackground(PlateGrid.SELECTED_COLOR);
            } else {
                this.setBackground(PlateGrid.BACKGROUND_COLOR);
            }
            return this;
        }
    }
}

