/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.PartialLineBorder;
import org.openmicroscopy.shoola.util.ui.login.ServerTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerEditor
extends JPanel {
    public static final String REMOVE_MESSAGE_PROPERTY = "removeMessage";
    public static final String ADD_MESSAGE_PROPERTY = "addMessage";
    static final String EDIT_PROPERTY = "edit";
    static final String REMOVE_PROPERTY = "remove";
    static final String ADD_PROPERTY = "add";
    static final String APPLY_SERVER_PROPERTY = "applyServer";
    static final String SERVER_PORT_SEPARATOR = ":";
    static final String SERVER_NAME_SEPARATOR = ",";
    static final int MIN_PORT = 0;
    static final int MAX_PORT = 64000;
    private static final List<String> OLD_PORTS;
    private static final String EXAMPLE = "e.g. test.openmicroscopy.org or 134.20.12.33";
    private static final String NOTE = "You should not have to modify the port.";
    private static final String HEADER = "Server Address and Port";
    private static final String OMERO_SERVER = "omeroServer";
    private static final Font FONT;
    private JButton removeButton;
    private JButton addButton;
    private JButton editButton;
    private ServerTable table;
    private JPanel emptyMessagePanel;
    private IconManager icons = IconManager.getInstance();
    private boolean warning;
    private boolean editing;
    private String activeServer;
    private String activePort;
    private String defaultPort;
    private int originalRow;
    private int editedRow;

    private void removeRow(int row) {
        TableCellEditor editor;
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        if (row < 0) {
            return;
        }
        if (model.getColumnCount() < 2) {
            return;
        }
        String oldValue = null;
        if (row < model.getRowCount()) {
            oldValue = (String)model.getValueAt(row, 1);
        }
        if ((editor = this.table.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        this.table.removeRow(row);
        int m = model.getRowCount() - 1;
        String newValue = null;
        if (m > -1 && this.table.getColumnCount() > 1) {
            this.table.changeSelection(m, 1, false, false);
            newValue = (String)model.getValueAt(m, 1);
            this.requestFocusInWindow();
        }
        if ((editor = this.table.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        if (model.getRowCount() == 0) {
            this.setEditing(false);
        }
        this.handleServers(this.activeServer, this.activePort);
        this.editing = false;
        this.fireEditProperty(model.getRowCount() != 0);
        this.firePropertyChange(REMOVE_PROPERTY, oldValue, newValue);
    }

    private void addRow() {
        if (this.editing) {
            TableCellEditor editor = this.table.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            this.editing = false;
            this.addRow();
            return;
        }
        this.addButton.setEnabled(false);
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        int m = model.getRowCount();
        Object[] newRow = new Object[]{this.icons.getIcon(23), "", this.defaultPort};
        model.insertRow(m, newRow);
        model.fireTableDataChanged();
        this.requestFocusOnEditedCell(m, 1);
        this.setEditing(true);
    }

    private void initComponents(Map<String, String> servers, boolean enabled) {
        this.editedRow = -1;
        this.table = new ServerTable(this, servers, this.icons.getIcon(23));
        this.removeButton = new JButton(this.icons.getIcon(24));
        UIUtilities.unifiedButtonLookAndFeel(this.removeButton);
        this.removeButton.setToolTipText("Remove the selected server from the list of servers.");
        this.addButton = new JButton(this.icons.getIcon(28));
        this.addButton.setToolTipText("Add a new server to the list of servers.");
        this.addButton.setBorder(new TitledBorder(""));
        UIUtilities.unifiedButtonLookAndFeel(this.addButton);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerEditor.this.removeRow(ServerEditor.this.table.getSelectedRow());
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerEditor.this.addRow();
            }
        });
        this.editButton = new JButton(this.icons.getIcon(116));
        UIUtilities.unifiedButtonLookAndFeel(this.editButton);
        this.editButton.setToolTipText("Edit an existing server.");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = ServerEditor.this.table.getSelectedRow();
                if (ServerEditor.this.editedRow == row) {
                    ServerEditor.this.requestFocusOnEditedCell(row, 2);
                } else {
                    ServerEditor.this.requestFocusOnEditedCell(row, 1);
                }
            }
        });
        this.addButton.setEnabled(enabled);
        this.editButton.setEnabled(enabled);
    }

    private void buildGUI() {
        JPanel labels = new JPanel();
        labels.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        JLabel label = UIUtilities.setTextFont(HEADER);
        labels.add((Component)label, c);
        label = new JLabel(EXAMPLE);
        label.setFont(FONT);
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        labels.add((Component)label, c);
        label = new JLabel(NOTE);
        label.setFont(FONT);
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        labels.add((Component)label, c);
        if (this.activeServer != null) {
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            label = UIUtilities.setTextFont("Connected to ");
            labels.add((Component)label, c);
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.gridx = 1;
            label = new JLabel(this.activeServer + SERVER_PORT_SEPARATOR + this.activePort);
            labels.add((Component)label, c);
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        p.add(new JScrollPane(this.table));
        p.add(this.buildControls());
        this.setLayout(new BoxLayout(this, 1));
        JPanel content = UIUtilities.buildComponentPanel(labels);
        this.add(content);
        this.add(p);
    }

    private JPanel buildControls() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.addButton);
        bar.add(this.removeButton);
        bar.add(this.editButton);
        return UIUtilities.buildComponentPanel(bar);
    }

    private void setButtonsEnabled(boolean b) {
        this.addButton.setEnabled(b);
        this.removeButton.setEnabled(b);
        this.editButton.setEnabled(b);
    }

    private void fireEditProperty(boolean b) {
        this.firePropertyChange(EDIT_PROPERTY, (Object)(!b ? 1 : 0), (Object)b);
    }

    private void buildEmptyPanel() {
        if (this.emptyMessagePanel != null) {
            return;
        }
        this.emptyMessagePanel = new JPanel();
        this.emptyMessagePanel.setOpaque(false);
        this.emptyMessagePanel.setBorder(new PartialLineBorder(Color.BLACK));
        this.emptyMessagePanel.setLayout(new BoxLayout(this.emptyMessagePanel, 0));
    }

    private void initFocus() {
        int n = 0;
        Map<String, String> servers = this.getServers();
        if (servers != null) {
            n = servers.size();
        }
        this.originalRow = -1;
        if (n == 0) {
            this.requestFocusOnEditedCell(this.table.getRowCount() - 1, 1);
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.originalRow = n - 1;
            this.table.setRowSelectionInterval(this.originalRow, this.originalRow);
        }
    }

    ServerEditor(String defaultPort) {
        this(null, null, defaultPort);
    }

    ServerEditor(String activeServer, String activePort, String defaultPort) {
        this.activeServer = activeServer;
        if (defaultPort == null) {
            defaultPort = "";
        }
        this.defaultPort = defaultPort;
        if (activePort == null || activePort.trim().length() == 0) {
            this.activePort = defaultPort;
        }
        int n = 0;
        Map<String, String> servers = this.getServers();
        if (servers != null) {
            n = servers.size();
        }
        this.initComponents(servers, n != 0);
        this.editing = false;
        this.editedRow = -1;
        this.buildGUI();
    }

    String getDefaultPort() {
        return this.defaultPort;
    }

    void setEditing(boolean b) {
        this.addButton.setEnabled(!b);
        this.editButton.setEnabled(!b);
        this.editing = b;
    }

    boolean isEditing() {
        return this.editing;
    }

    void requestFocusOnEditedCell(int row, int col) {
        if (col == 0) {
            return;
        }
        if (this.table.getColumnCount() > 1) {
            this.editing = true;
            this.editedRow = row;
            TableCellEditor editor = this.table.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            this.table.editCellAt(row, col);
            this.table.changeSelection(row, col, false, false);
            this.table.requestFocus();
        }
    }

    void changeSelection(int row, int previousRow, String text) {
        TableCellEditor editor;
        this.fireEditProperty(row != -1);
        if (previousRow == -1 || previousRow == row) {
            return;
        }
        this.editing = false;
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (i == previousRow) continue;
            values.add((String)this.table.getValueAt(i, 1));
        }
        if (this.activeServer != null && !values.contains(this.activeServer)) {
            values.add(this.activeServer);
        }
        Iterator j = values.iterator();
        boolean found = false;
        while (j.hasNext()) {
            String name = (String)j.next();
            if (!name.equals(text)) continue;
            found = true;
            break;
        }
        this.handleServers(this.activeServer, this.activePort);
        if ((found || text == null || text.trim().length() == 0) && previousRow != -1) {
            this.removeRow(previousRow);
        }
        if ((editor = this.table.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
    }

    void showMessagePanel(boolean warning) {
        this.warning = warning;
        this.fireEditProperty(!warning);
        this.setButtonsEnabled(!warning);
        if (warning) {
            if (this.emptyMessagePanel != null) {
                return;
            }
            this.buildEmptyPanel();
            this.firePropertyChange(ADD_MESSAGE_PROPERTY, null, this.emptyMessagePanel);
        } else {
            if (this.emptyMessagePanel == null) {
                return;
            }
            this.firePropertyChange(REMOVE_MESSAGE_PROPERTY, null, this.emptyMessagePanel);
            this.emptyMessagePanel = null;
        }
    }

    void finishEdition(String text) {
        if (!this.editing) {
            return;
        }
        this.editing = false;
        this.setButtonsEnabled(true);
        if (this.warning || text == null || text.length() == 0) {
            this.removeRow(this.table.getSelectedRow());
            this.showMessagePanel(false);
            return;
        }
        this.handleServers(this.activeServer, this.activePort);
    }

    void stopEdition() {
        this.setEditing(false);
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    String getSelectedServer() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        String v = (String)this.table.getValueAt(row, 1);
        if (v == null) {
            return null;
        }
        String trim = v.trim();
        if (trim.length() == 0) {
            return null;
        }
        return trim;
    }

    String getSelectedPort() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        String v = (String)this.table.getValueAt(row, 2);
        if (v == null) {
            return null;
        }
        return v.trim();
    }

    String getActiveServer() {
        return this.activeServer;
    }

    String getActivePort() {
        return this.activePort;
    }

    Map<String, String> getServers() {
        Preferences prefs = Preferences.userNodeForPackage(ServerEditor.class);
        String servers = prefs.get(OMERO_SERVER, null);
        if (servers == null || servers.length() == 0) {
            return null;
        }
        String[] l = servers.split(SERVER_NAME_SEPARATOR, 0);
        if (l == null) {
            return null;
        }
        LinkedHashMap<String, String> listOfServers = new LinkedHashMap<String, String>();
        for (int index = 0; index < l.length; ++index) {
            String p;
            String server = l[index].trim();
            if (server.length() <= 0) continue;
            String[] values = server.split(SERVER_PORT_SEPARATOR, 0);
            String name = values[0];
            if (values.length > 1) {
                p = values[1];
                if (OLD_PORTS.contains(p)) {
                    p = this.defaultPort;
                }
            } else {
                p = this.defaultPort;
            }
            if (name.equals(this.activeServer)) continue;
            listOfServers.put(name, p);
        }
        return listOfServers;
    }

    void handleServers(String serverName, String port) {
        LinkedHashMap<String, String> l = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            String v = (String)this.table.getValueAt(i, 1);
            if (v == null || v.trim().length() <= 0) continue;
            l.put(v, (String)this.table.getValueAt(i, 2));
        }
        if (this.activeServer != null && l.get(this.activeServer) == null) {
            l.put(this.activeServer, this.activePort);
        }
        Preferences prefs = Preferences.userNodeForPackage(ServerEditor.class);
        if (l == null || l.size() == 0) {
            prefs.put(OMERO_SERVER, "");
            return;
        }
        LinkedHashMap<String, String> servers = new LinkedHashMap<String, String>(l.size());
        Set set = l.entrySet();
        for (Map.Entry entry : set) {
            String name = (String)entry.getKey();
            if (name.equals(serverName)) continue;
            servers.put(name, (String)entry.getValue());
        }
        if (serverName != null && serverName.length() != 0) {
            servers.put(serverName, port);
        }
        Iterator i = servers.entrySet().iterator();
        int n = servers.size() - 1;
        int index = 0;
        String list = "";
        while (i.hasNext()) {
            Map.Entry entry;
            entry = i.next();
            String value = (String)entry.getKey();
            list = list + value;
            list = list + SERVER_PORT_SEPARATOR;
            list = entry.getValue() != null ? list + (String)entry.getValue() : list + this.defaultPort;
            if (index != n) {
                list = list + SERVER_NAME_SEPARATOR;
            }
            ++index;
        }
        if (list.length() != 0) {
            prefs.put(OMERO_SERVER, list);
        }
    }

    void setFocus(String server) {
        if (server == null || server.equals("Add a new server ->")) {
            this.initFocus();
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        int m = model.getRowCount();
        int row = -1;
        for (int i = 0; i < m; ++i) {
            String value = (String)model.getValueAt(i, 1);
            if (!server.equals(value)) continue;
            row = i;
        }
        if (row > -1) {
            this.table.setRowSelectionInterval(row, row);
        }
    }

    void onApply() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        int m = model.getRowCount();
        if (m <= 1) {
            return;
        }
        ArrayList<Integer> rowToDelete = new ArrayList<Integer>();
        for (int i = 0; i < m; ++i) {
            String value = (String)model.getValueAt(i, 1);
            if (value != null && value.trim().length() != 0) continue;
            rowToDelete.add(i);
        }
        Iterator j = rowToDelete.iterator();
        while (j.hasNext()) {
            this.removeRow((Integer)j.next());
        }
    }

    int getOriginalRow() {
        return this.originalRow;
    }

    boolean isOriginal(String value) {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        String v = (String)model.getValueAt(this.table.getSelectedRow(), 1);
        if (value == null) {
            return false;
        }
        return value.equals(v);
    }

    static {
        FONT = new Font("SansSerif", 2, 10);
        OLD_PORTS = new ArrayList<String>();
        OLD_PORTS.add("1099");
        OLD_PORTS.add("4063");
    }
}

