/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourSwatchUI;
import org.openmicroscopy.shoola.util.ui.colourpicker.HSVColourWheelUI;
import org.openmicroscopy.shoola.util.ui.colourpicker.PaintPotUI;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBControl;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBSliderUI;

class TabbedPaneUI
extends JPanel
implements ChangeListener,
DocumentListener {
    static final int TEXTBOX_COLUMN = 2;
    private static final String COLOURWHEELPANE = "Colour Wheel Pane";
    private static final String RGBSLIDERPANE = "RGB Slider Pane";
    private static final String SWATCHPANE = "Swatch Pane";
    private JToolBar toolbar;
    private JPanel userActionPanel;
    private JToggleButton colourWheelButton;
    private JToggleButton RGBSlidersButton;
    private JToggleButton colourSwatchButton;
    private JButton acceptButton;
    private JButton revertButton;
    private JButton cancelButton;
    private JTextField fieldDescription;
    private HSVColourWheelUI colourWheelPane;
    private RGBSliderUI RGBSliderPane;
    private ColourSwatchUI swatchPane;
    private CardLayout tabPaneLayout;
    private JPanel tabPanel;
    private PaintPotUI paintPotPane;
    private RGBControl control;
    private ColourPicker parent;
    private String originalDescription;

    private void createToolbar() {
        this.toolbar = new JToolBar();
        IconManager icons = IconManager.getInstance();
        this.colourWheelButton = new JToggleButton(icons.getIcon(2));
        UIUtilities.unifiedButtonLookAndFeel(this.colourWheelButton);
        this.colourWheelButton.setBorderPainted(true);
        this.colourWheelButton.setToolTipText("Show HSV Colour Wheel");
        AbstractAction action = new AbstractAction("HSV Wheel Colour Button"){

            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.clearToggleButtons();
                TabbedPaneUI.this.pickWheelPane();
            }
        };
        this.colourWheelButton.addActionListener(action);
        this.RGBSlidersButton = new JToggleButton(icons.getIcon(0));
        UIUtilities.unifiedButtonLookAndFeel(this.RGBSlidersButton);
        this.RGBSlidersButton.setBorderPainted(true);
        this.RGBSlidersButton.setToolTipText("Show RGB Colour Sliders");
        action = new AbstractAction("RGB Slider Button"){

            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.clearToggleButtons();
                TabbedPaneUI.this.pickRGBSliderPane();
            }
        };
        this.RGBSlidersButton.addActionListener(action);
        this.colourSwatchButton = new JToggleButton(icons.getIcon(1));
        this.colourSwatchButton.setToolTipText("Show Colour List");
        UIUtilities.unifiedButtonLookAndFeel(this.colourSwatchButton);
        this.colourSwatchButton.setBorderPainted(true);
        action = new AbstractAction("Colour Swatch Button"){

            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.clearToggleButtons();
                TabbedPaneUI.this.pickSwatchPane();
            }
        };
        this.colourSwatchButton.addActionListener(action);
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.add(this.colourWheelButton);
        this.toolbar.add(this.RGBSlidersButton);
        this.toolbar.add(this.colourSwatchButton);
    }

    private void createActionbar() {
        this.userActionPanel = new JPanel();
        this.userActionPanel.setLayout(new FlowLayout());
        this.acceptButton = new JButton("Accept");
        this.acceptButton.setToolTipText("Accept the selected colour.");
        AbstractAction action = new AbstractAction("Accept Button Action"){

            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.parent.accept();
            }
        };
        this.acceptButton.addActionListener(action);
        this.revertButton = new JButton("Revert");
        this.revertButton.setToolTipText("Revert to the original colour.");
        action = new AbstractAction("Revert Button Action"){

            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.revertAction();
            }
        };
        this.revertButton.addActionListener(action);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Close the Colour Picker.");
        action = new AbstractAction("Cancel Button Action"){

            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.parent.cancel();
            }
        };
        this.cancelButton.addActionListener(action);
        this.userActionPanel.add(this.acceptButton);
        this.userActionPanel.add(this.revertButton);
        this.userActionPanel.add(this.cancelButton);
        this.setButtonsEnabled(false);
        this.parent.getRootPane().setDefaultButton(this.cancelButton);
    }

    private void createPanels() {
        this.colourWheelPane = new HSVColourWheelUI(this.control);
        this.paintPotPane = new PaintPotUI(this.control.getColour(), this.control);
        this.RGBSliderPane = new RGBSliderUI(this.control);
        this.swatchPane = new ColourSwatchUI(this.control);
    }

    private void createUI(boolean field) {
        this.createToolbar();
        this.createActionbar();
        this.createPanels();
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)this.toolbar, "West");
        this.setLayout(new BoxLayout(this, 1));
        this.add(container);
        this.paintPotPane.setPreferredSize(new Dimension(260, 24));
        this.add(Box.createVerticalStrut(5));
        this.add(this.paintPotPane);
        this.add(Box.createVerticalStrut(5));
        this.tabPanel = new JPanel();
        this.tabPaneLayout = new CardLayout();
        this.tabPanel.setLayout(this.tabPaneLayout);
        this.tabPanel.add((Component)this.colourWheelPane, COLOURWHEELPANE);
        this.tabPanel.add((Component)this.RGBSliderPane, RGBSLIDERPANE);
        this.tabPanel.add((Component)this.swatchPane, SWATCHPANE);
        this.add(this.tabPanel);
        if (field) {
            this.add(new JSeparator());
            JLabel label = UIUtilities.setTextFont("Description: ");
            JPanel p = new JPanel();
            double[][] size = new double[][]{{-2.0, -1.0}, {-2.0}};
            p.setLayout((LayoutManager)new TableLayout((double[][])size));
            p.add((Component)label, "0, 0");
            this.fieldDescription = new JTextField();
            p.add((Component)this.fieldDescription, "1, 0");
            this.add(p);
        }
        this.add(this.userActionPanel);
        this.pickSwatchPane();
    }

    private void clearToggleButtons() {
        this.colourWheelButton.setSelected(false);
        this.RGBSlidersButton.setSelected(false);
        this.colourSwatchButton.setSelected(false);
    }

    private void pickWheelPane() {
        this.colourWheelButton.setSelected(true);
        this.colourWheelPane.setActive(true);
        this.tabPaneLayout.show(this.tabPanel, COLOURWHEELPANE);
        this.RGBSliderPane.setActive(false);
        this.swatchPane.setActive(false);
        this.colourWheelPane.findPuck();
        this.colourWheelPane.refresh();
        this.colourWheelPane.repaint();
    }

    private void pickSwatchPane() {
        this.tabPaneLayout.show(this.tabPanel, SWATCHPANE);
        this.colourSwatchButton.setSelected(true);
        this.swatchPane.setActive(true);
        this.RGBSliderPane.setActive(false);
        this.colourWheelPane.setActive(false);
        this.doLayout();
        this.swatchPane.refresh();
    }

    private void pickRGBSliderPane() {
        this.tabPaneLayout.show(this.tabPanel, RGBSLIDERPANE);
        this.RGBSlidersButton.setSelected(true);
        this.RGBSliderPane.setActive(true);
        this.colourWheelPane.setActive(false);
        this.swatchPane.setActive(false);
        this.doLayout();
        this.RGBSliderPane.refresh();
    }

    TabbedPaneUI(ColourPicker parent, RGBControl control, boolean field) {
        if (parent == null) {
            throw new NullPointerException("No parent.");
        }
        if (control == null) {
            throw new NullPointerException("No control.");
        }
        this.parent = parent;
        this.control = control;
        this.createUI(field);
        this.control.addListener(this);
    }

    void setButtonsEnabled(boolean enabled) {
        this.acceptButton.setEnabled(enabled);
        this.revertButton.setEnabled(enabled);
    }

    void revertAction() {
        this.control.revert();
    }

    String getDescription() {
        if (this.fieldDescription == null) {
            return null;
        }
        String text = this.fieldDescription.getText();
        if (text == null) {
            return null;
        }
        return text.trim();
    }

    void setColorDescription(String description) {
        if (this.fieldDescription == null || description == null) {
            return;
        }
        this.originalDescription = description;
        this.fieldDescription.setText(description);
        this.fieldDescription.getDocument().addDocumentListener(this);
    }

    public void stateChanged(ChangeEvent evt) {
        if (this.RGBSliderPane != null && this.RGBSliderPane.isVisible()) {
            this.RGBSliderPane.refresh();
        }
        if (this.colourWheelPane != null && this.colourWheelPane.isVisible()) {
            this.colourWheelPane.refresh();
        }
        if (this.swatchPane != null && this.swatchPane.isVisible()) {
            this.swatchPane.refresh();
        }
        if (this.fieldDescription == null) {
            this.setButtonsEnabled(!this.control.isOriginalColour());
        } else {
            String text = this.fieldDescription.getText();
            this.setButtonsEnabled(!text.equals(this.originalDescription) || !this.control.isOriginalColour());
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.fieldDescription == null) {
            return;
        }
        String text = this.fieldDescription.getText();
        this.setButtonsEnabled(!text.equals(this.originalDescription) || !this.control.isOriginalColour());
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.fieldDescription == null) {
            return;
        }
        String text = this.fieldDescription.getText();
        this.setButtonsEnabled(!text.equals(this.originalDescription) || !this.control.isOriginalColour());
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

