/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.checkboxlist;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openmicroscopy.shoola.util.ui.checkboxlist.CheckBoxModel;
import org.openmicroscopy.shoola.util.ui.checkboxlist.CheckBoxRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxList
extends JTable {
    public CheckBoxList(CheckBoxModel model) {
        super(model);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (CheckBoxList.this.getSelectedColumn() == 1) {
                    CheckBoxList.this.toggleValue();
                }
            }
        });
    }

    CheckBoxList() {
        this(new CheckBoxModel());
    }

    private void toggleValue() {
        int col = this.getSelectedColumn();
        int row = this.getSelectedRow();
        boolean value = (Boolean)this.getModel().getValueAt(row, col);
        this.getModel().setValueAt(!value, row, col);
        this.repaint();
    }

    @Override
    public DefaultCellEditor getCellEditor(int row, int col) {
        CheckBoxRenderer renderer = (CheckBoxRenderer)this.getCellRenderer(row, col);
        return new DefaultCellEditor((JCheckBox)renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col));
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return new CheckBoxRenderer();
    }

    public List<String> getTrueValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (int row = 0; row < this.getModel().getRowCount(); ++row) {
            if (!((Boolean)this.getValueAt(row, 1)).booleanValue()) continue;
            values.add((String)this.getValueAt(row, 0));
        }
        return values;
    }

    public void setTrueValues(List<String> values) {
        for (String value : values) {
            int row = this.findValue(value);
            if (row == -1) continue;
            this.getModel().setValueAt(true, row, 1);
        }
    }

    public int findValue(String value) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!value.equals(this.getModel().getValueAt(i, 0))) continue;
            return i;
        }
        return -1;
    }
}

