/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jdesktop.swingx.JXBusyLabel;

public class FileTableNode
extends JPanel {
    private static final Dimension SIZE = new Dimension(16, 16);
    private File file;
    private Exception exception;
    private JXBusyLabel status;
    private JCheckBox selected;

    private void buildGUI() {
        this.removeAll();
        this.setLayout(new FlowLayout(0));
        this.add((Component)this.status);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.selected);
        this.add(new JSeparator(1));
        this.add(new JLabel(this.file.getName()));
        this.add(Box.createHorizontalStrut(15));
    }

    FileTableNode(File file, Exception exception) {
        if (file == null) {
            throw new IllegalArgumentException("No file");
        }
        this.file = file;
        this.exception = exception;
        this.status = new JXBusyLabel(SIZE);
        this.selected = new JCheckBox("Send file");
        this.selected.setSelected(true);
        this.buildGUI();
    }

    boolean isSelected() {
        return this.selected.isSelected();
    }

    public File getFile() {
        return this.file;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setStatus(boolean busy) {
        this.status.setBusy(busy);
        if (!busy) {
            this.status.setText("done");
        }
    }

    public void setBackground(Color color) {
        if (this.status != null) {
            this.status.setBackground(color);
        }
        if (this.selected != null) {
            this.selected.setBackground(color);
        }
        super.setBackground(color);
    }
}

