/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.image.io;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.openmicroscopy.shoola.util.image.io.Encoder;
import org.openmicroscopy.shoola.util.image.io.EncoderException;

public class WriterImage {
    public static void saveImage(File f, BufferedImage img, String format) throws EncoderException {
        if (f == null) {
            throw new IllegalArgumentException("No file specified.");
        }
        if (img == null) {
            throw new IllegalArgumentException("No image specified.");
        }
        try {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
            ImageWriter writer = writers.next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(f);
            writer.setOutput(ios);
            writer.write(img);
            ios.close();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot encode the image.", e);
        }
    }

    public static void saveImage(Encoder encoder) throws EncoderException {
        if (encoder == null) {
            throw new IllegalArgumentException("No encoder specified.");
        }
        try {
            encoder.write();
            encoder.getOutput().close();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot encode the image.", e);
        }
    }

    public static byte[] imageToByteStreamAsJPEG(BufferedImage image) throws EncoderException {
        if (image == null) {
            throw new IllegalArgumentException("No image specified.");
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)bos);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
            param.setQuality(1.0f, false);
            encoder.setJPEGEncodeParam(param);
            encoder.encode(image);
            bos.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot encode the image.", e);
        }
    }

    public static BufferedImage bytesToImageJPEG(byte[] values) throws EncoderException {
        if (values == null) {
            throw new IllegalArgumentException("No array specified.");
        }
        JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)new ByteArrayInputStream(values));
        try {
            return decoder.decodeAsBufferedImage();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot decode the image.", e);
        }
    }

    public static int[] bytesToDataBufferJPEG(byte[] values) throws EncoderException {
        if (values == null) {
            throw new IllegalArgumentException("No array specified.");
        }
        try {
            BufferedImage img = WriterImage.bytesToImageJPEG(values);
            if (img == null) {
                return null;
            }
            DataBufferInt buf = (DataBufferInt)img.getData().getDataBuffer();
            return buf.getData();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot decode the image.", e);
        }
    }
}

